/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.IAppendableDataSource;
import com.inmethod.grid.column.editable.AddDeletePanel;
import com.inmethod.grid.column.editable.SubmitCancelColumn;
import com.inmethod.grid.common.AbstractGrid;
import com.inmethod.grid.common.Icons;
import com.inmethod.grid.datagrid.DataGrid;
import com.inmethod.icon.Icon;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class AddDeleteColumn<M, I, S>
extends SubmitCancelColumn<M, I, S> {
    public AddDeleteColumn(String columnId, IModel<String> headerModel) {
        super(columnId, headerModel);
    }

    @Override
    public Component newCell(WebMarkupContainer parent, String componentId, final IModel<I> rowModel) {
        return new AddDeletePanel<M, I>(componentId, rowModel, this.getGrid()){
            private static final long serialVersionUID = 1L;

            private WebMarkupContainer getRowComponent() {
                return this.getGrid().findParentRow((Component)this);
            }

            @Override
            protected void onCancel(AjaxRequestTarget target) {
                AddDeleteColumn.this.onCancel(target, rowModel, this.getRowComponent());
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                AddDeleteColumn.this.onError(target, rowModel, this.getRowComponent());
            }

            @Override
            protected void onSubmitted(AjaxRequestTarget target) {
                AddDeleteColumn.this.onSubmitted(target, rowModel, this.getRowComponent());
            }

            @Override
            protected void onDelete(AjaxRequestTarget target) {
                AddDeleteColumn.this.onDelete(target, rowModel, this.getRowComponent());
            }

            @Override
            protected Icon getSubmitIcon() {
                return AddDeleteColumn.this.getSubmitIcon();
            }

            @Override
            protected Icon getCancelIcon() {
                return AddDeleteColumn.this.getCancelIcon();
            }

            @Override
            protected Icon getDeleteIcon() {
                return AddDeleteColumn.this.getDeleteIcon();
            }
        };
    }

    protected Icon getDeleteIcon() {
        return Icons.DELETE;
    }

    protected void onDelete(AjaxRequestTarget target, IModel<I> rowModel, WebMarkupContainer rowComponent) {
        AbstractGrid ag = this.getGrid();
        if (ag instanceof DataGrid) {
            DataGrid dg = (DataGrid)ag;
            long rows = dg.getRowsPerPage();
            Object ds = dg.getDataSource();
            if (ds instanceof IAppendableDataSource) {
                IAppendableDataSource ads = (IAppendableDataSource)ds;
                ads.deleteRow(0L, rowModel.getObject());
            }
            if (dg.getCurrentPageItemCount() == 1L) {
                if (0L == dg.getCurrentPage()) {
                    dg.markAllItemsDirty();
                } else {
                    dg.setCurrentPage(dg.getCurrentPage() - 1L);
                }
            }
        }
        ag.markItemDirty(rowModel);
        ag.update();
    }
}

