/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column;

import com.inmethod.grid.IRenderable;
import com.inmethod.grid.column.AbstractLightWeightColumn;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;

public class PropertyColumn<M, I, P, S>
extends AbstractLightWeightColumn<M, I, S> {
    private static final long serialVersionUID = 1L;
    private final String propertyExpression;
    private boolean escapeMarkup = true;

    public PropertyColumn(String columnId, IModel<String> headerModel, String propertyExpression, S sortProperty) {
        super(columnId, headerModel, sortProperty);
        this.propertyExpression = propertyExpression;
    }

    public PropertyColumn(String columnId, IModel<String> headerModel, String propertyExpression) {
        this(columnId, headerModel, propertyExpression, null);
    }

    public PropertyColumn(IModel<String> headerModel, String propertyExpression, S sortProperty) {
        this(propertyExpression, headerModel, propertyExpression, sortProperty);
    }

    public PropertyColumn(IModel<String> headerModel, String propertyExpression) {
        this(propertyExpression, headerModel, propertyExpression);
    }

    public PropertyColumn<M, I, P, S> setEscapeMarkup(boolean escape) {
        this.escapeMarkup = escape;
        return this;
    }

    public boolean isEscapeMarkup() {
        return this.escapeMarkup;
    }

    protected P getProperty(Object object, String propertyExpression) {
        return (P)PropertyResolver.getValue((String)propertyExpression, (Object)object);
    }

    protected I getModelObject(IModel<I> rowModel) {
        return (I)rowModel.getObject();
    }

    private CharSequence getValue(IModel<I> rowModel) {
        I rowObject = this.getModelObject(rowModel);
        Object property = null;
        if (rowObject != null) {
            try {
                property = this.getProperty(rowObject, this.getPropertyExpression());
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        CharSequence string = this.convertToString(property);
        if (this.isEscapeMarkup() && string != null) {
            string = Strings.escapeMarkup((CharSequence)((Object)string).toString());
        }
        return string;
    }

    protected <C> IConverter<C> getConverter(Class<C> type) {
        return Application.get().getConverterLocator().getConverter(type);
    }

    protected Locale getLocale() {
        return Session.get().getLocale();
    }

    protected <C> CharSequence convertToString(C object) {
        if (object != null) {
            Class<?> cKlazz = object.getClass();
            IConverter<?> converter = this.getConverter(cKlazz);
            return converter.convertToString(object, this.getLocale());
        }
        return "";
    }

    @Override
    public IRenderable<I> newCell(IModel<I> rowModel) {
        return new IRenderable<I>(){

            @Override
            public void render(IModel<I> rowModel, Response response) {
                CharSequence value = PropertyColumn.this.getValue(rowModel);
                if (value != null) {
                    response.write(value);
                }
            }
        };
    }

    public String getPropertyExpression() {
        return this.propertyExpression;
    }
}

