/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column;

import com.inmethod.grid.column.AbstractColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class CheckBoxColumn<M, I, S>
extends AbstractColumn<M, I, S> {
    private static final long serialVersionUID = 1L;

    public CheckBoxColumn(String columnId) {
        super(columnId, null);
        this.setResizable(false);
        this.setInitialSize(30);
    }

    @Override
    public Component newCell(WebMarkupContainer parent, String componentId, IModel<I> rowModel) {
        return new BodyCheckBoxPanel(componentId, rowModel);
    }

    @Override
    public Component newHeader(String componentId) {
        return new HeadPanel(componentId);
    }

    private void processTag(ComponentTag tag, IModel<I> model) {
        TreeGrid grid;
        Object parent;
        if (!this.isCheckBoxEnabled(model)) {
            tag.put("disabled", (CharSequence)"disabled");
        } else if (this.getGrid() instanceof TreeGrid && ((TreeGrid)this.getGrid()).isAutoSelectChildren() && (parent = (grid = (TreeGrid)this.getGrid()).getTree().getParentNode(model.getObject())) != null && grid.getTreeState().isNodeSelected(parent)) {
            tag.put("disabled", (CharSequence)"disabled");
        }
    }

    protected boolean isCheckBoxEnabled(IModel<I> model) {
        return true;
    }

    protected boolean isCheckBoxVisible(IModel<I> model) {
        return true;
    }

    @Override
    public String getCellCssClass(IModel<I> rowModel, int rowNum) {
        return "imxt-select";
    }

    @Override
    public String getHeaderCssClass() {
        return "imxt-select";
    }

    protected IModel<String> getRowTooltipModel(IModel<I> itemModel) {
        return null;
    }

    private class HeadCheckBoxPanel
    extends Panel {
        private static final long serialVersionUID = 1L;

        private HeadCheckBoxPanel(String id) {
            super(id);
            WebMarkupContainer checkbox = new WebMarkupContainer("checkbox"){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    Object object;
                    super.onComponentTag(tag);
                    if (CheckBoxColumn.this.getHeaderTooltipModel() != null && (object = CheckBoxColumn.this.getHeaderTooltipModel().getObject()) != null) {
                        tag.put("title", (CharSequence)object.toString());
                    }
                }
            };
            this.add(new Component[]{checkbox});
            checkbox.add(new Behavior[]{new AjaxFormSubmitBehavior(CheckBoxColumn.this.getGrid().getForm(), "onclick"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                }

                protected void onError(AjaxRequestTarget target) {
                }

                protected void onEvent(AjaxRequestTarget target) {
                    Form form = this.getForm();
                    form.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

                        public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                            if (formComponent.isVisibleInHierarchy()) {
                                formComponent.inputChanged();
                            }
                        }
                    });
                    boolean checked = HeadCheckBoxPanel.this.getRequest().getRequestParameters().getParameterValue("checked").toBoolean();
                    if (checked) {
                        CheckBoxColumn.this.getGrid().selectAllVisibleItems();
                    } else {
                        CheckBoxColumn.this.getGrid().resetSelectedItems();
                    }
                    CheckBoxColumn.this.getGrid().update();
                }

                protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                    super.updateAjaxAttributes(attributes);
                    String checkedParameter = "return {'checked': Wicket.$(attrs.c).checked}";
                    attributes.getDynamicExtraParameters().add(checkedParameter);
                }

                protected CharSequence getPreconditionScript() {
                    return "window.setTimeout(function(){this.checked=!this.checked}.bind(this),0);" + super.getPreconditionScript();
                }
            }});
        }
    }

    private class HeadPanel
    extends Panel {
        private static final long serialVersionUID = 1L;

        private HeadPanel(String id) {
            super(id);
            this.add(new Component[]{new HeadCheckBoxPanel("checkbox"){
                private static final long serialVersionUID = 1L;

                public boolean isVisible() {
                    return CheckBoxColumn.this.getGrid().isAllowSelectMultiple();
                }
            }});
            this.add(new Component[]{new WebMarkupContainer("space"){
                private static final long serialVersionUID = 1L;

                public boolean isVisible() {
                    return !CheckBoxColumn.this.getGrid().isAllowSelectMultiple();
                }

                protected void onComponentTag(ComponentTag tag) {
                    Object object;
                    super.onComponentTag(tag);
                    if (CheckBoxColumn.this.getHeaderTooltipModel() != null && (object = CheckBoxColumn.this.getHeaderTooltipModel().getObject()) != null) {
                        tag.put("title", (CharSequence)object.toString());
                    }
                }
            }});
        }
    }

    private class BodyCheckBoxPanel
    extends Panel {
        private static final long serialVersionUID = 1L;

        private BodyCheckBoxPanel(String id, final IModel<I> model) {
            super(id, model);
            WebMarkupContainer checkbox = new WebMarkupContainer("checkbox"){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    Object object;
                    IModel<String> tooltipModel;
                    super.onComponentTag(tag);
                    if (CheckBoxColumn.this.getGrid().isItemSelected(model)) {
                        tag.put("checked", (CharSequence)"checked");
                    }
                    if ((tooltipModel = CheckBoxColumn.this.getRowTooltipModel(model)) != null && (object = tooltipModel.getObject()) != null) {
                        tag.put("title", (CharSequence)object.toString());
                    }
                    CheckBoxColumn.this.processTag(tag, model);
                }

                public boolean isVisible() {
                    return CheckBoxColumn.this.isCheckBoxVisible(model);
                }
            };
            checkbox.setOutputMarkupId(true);
            this.add(new Component[]{checkbox});
            checkbox.add(new Behavior[]{new AjaxFormSubmitBehavior(CheckBoxColumn.this.getGrid().getForm(), "onclick"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                }

                protected void onError(AjaxRequestTarget target) {
                }

                protected void onEvent(AjaxRequestTarget target) {
                    Form form = this.getForm();
                    form.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

                        public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                            if (formComponent.isVisibleInHierarchy()) {
                                formComponent.inputChanged();
                            }
                        }
                    });
                    boolean selected = CheckBoxColumn.this.getGrid().isItemSelected(model);
                    CheckBoxColumn.this.getGrid().selectItem(model, !selected);
                    CheckBoxColumn.this.getGrid().update();
                }

                protected CharSequence getPreconditionScript() {
                    return "window.setTimeout(function(){this.checked=!this.checked}.bind(this),0);" + super.getPreconditionScript();
                }
            }});
        }
    }
}

