/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column;

import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.IRenderable;
import com.inmethod.grid.SizeUnit;
import com.inmethod.grid.common.AbstractGrid;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public abstract class AbstractColumn<M, I, S>
implements IGridColumn<M, I, S> {
    private static final long serialVersionUID = 1L;
    private final String columnId;
    private final IModel<String> headerModel;
    private IModel<String> headerTooltipModel;
    private final S sortProperty;
    private int initialSize = 150;
    private SizeUnit sizeUnit = SizeUnit.PX;
    private int maxSize = 0;
    private int minSize = 0;
    private boolean reorderable = true;
    private boolean resizable = true;
    private AbstractGrid<M, I, S> grid = null;
    private boolean wrapText = false;

    public AbstractColumn(String columnId, IModel<String> headerModel, S sortProperty) {
        this.columnId = columnId;
        this.headerModel = headerModel;
        this.sortProperty = sortProperty;
    }

    public AbstractColumn(String columnId, IModel<String> headerModel) {
        this(columnId, headerModel, null);
    }

    public AbstractColumn<M, I, S> setHeaderTooltipModel(IModel<String> headerTooltipModel) {
        this.headerTooltipModel = headerTooltipModel;
        return this;
    }

    public IModel<String> getHeaderTooltipModel() {
        return this.headerTooltipModel;
    }

    public IModel<String> getHeaderModel() {
        return this.headerModel;
    }

    @Override
    public String getCellCssClass(IModel<I> rowModel, int rowNum) {
        return null;
    }

    @Override
    public int getColSpan(IModel<I> rowModel) {
        return 1;
    }

    @Override
    public String getHeaderCssClass() {
        return null;
    }

    @Override
    public String getId() {
        return this.columnId;
    }

    public AbstractColumn<M, I, S> setInitialSize(int initialSize) {
        this.initialSize = initialSize;
        return this;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public AbstractColumn<M, I, S> setSizeUnit(SizeUnit sizeUnit) {
        this.sizeUnit = sizeUnit;
        return this;
    }

    @Override
    public SizeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public AbstractColumn<M, I, S> setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public AbstractColumn<M, I, S> setMinSize(int minSize) {
        this.minSize = minSize;
        return this;
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }

    @Override
    public S getSortProperty() {
        return this.sortProperty;
    }

    public AbstractColumn<M, I, S> setReorderable(boolean reorderable) {
        this.reorderable = reorderable;
        return this;
    }

    @Override
    public boolean isReorderable() {
        return this.reorderable;
    }

    public AbstractColumn<M, I, S> setResizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    @Override
    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public boolean isLightWeight(IModel<I> rowModel) {
        return false;
    }

    @Override
    public abstract Component newCell(WebMarkupContainer var1, String var2, IModel<I> var3);

    @Override
    public IRenderable<I> newCell(IModel<I> rowModel) {
        return null;
    }

    @Override
    public Component newHeader(String componentId) {
        return new Label(componentId, this.getHeaderModel()){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                Object object;
                super.onComponentTag(tag);
                if (AbstractColumn.this.getHeaderTooltipModel() != null && (object = AbstractColumn.this.getHeaderTooltipModel().getObject()) != null) {
                    tag.put("title", (CharSequence)object.toString());
                }
            }
        };
    }

    public void detach() {
    }

    @Override
    public void setGrid(AbstractGrid<M, I, S> grid) {
        if (this.grid != null && this.grid != grid) {
            throw new IllegalStateException("One column instance can not be used with multiple grid instances.");
        }
        this.grid = grid;
    }

    public AbstractGrid<M, I, S> getGrid() {
        return this.grid;
    }

    public AbstractColumn<M, I, S> setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
        return this;
    }

    @Override
    public boolean getWrapText() {
        return this.wrapText;
    }

    @Override
    public boolean cellClicked(IModel<I> rowModel) {
        return false;
    }
}

