/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid;

import com.inmethod.grid.DataProviderAdapter;
import com.inmethod.grid.IAppendableDataSource;
import com.inmethod.grid.IDataSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.repeater.data.IDataProvider;

public class AppendableDataProviderAdapter<T, S>
extends DataProviderAdapter<T, S>
implements IAppendableDataSource<T> {
    private long _newItemCount = 0L;
    private long appendIndex;
    private List<T> items = null;

    public AppendableDataProviderAdapter(IDataProvider<T> dataProvider) {
        super(dataProvider);
    }

    @Override
    public void insertRow(long index, T item) {
        ++this._newItemCount;
        if (null == this.items) {
            this.items = new ArrayList<T>();
        }
        this.items.add(item);
        this.appendIndex = index;
    }

    @Override
    public void deleteRow(long index, T item) {
        if (null != this.items && this._newItemCount > 0L && this.items.remove(item)) {
            --this._newItemCount;
        }
    }

    @Override
    public void query(IDataSource.IQuery query, IDataSource.IQueryResult<T> result) {
        super.query(query, result);
        if (this._newItemCount > 0L) {
            result.setTotalCount(this.dataProvider.size() + this._newItemCount);
            long longSize = this.dataProvider.size() + this._newItemCount;
            int intSize = 0;
            if (longSize > Integer.MAX_VALUE) {
                intSize = Integer.MAX_VALUE;
            }
            ArrayList<Object> allItems = new ArrayList<Object>(intSize);
            Iterator it = this.dataProvider.iterator(query.getFrom(), query.getCount());
            while (it.hasNext()) {
                allItems.add(it.next());
            }
            try {
                allItems.addAll((int)this.appendIndex, this.items);
            }
            catch (Exception iob) {
                allItems.addAll(this.items);
            }
            result.setItems(allItems.iterator());
        }
    }
}

