/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.shape;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.wicketstuff.html5.shape.Shape;

public class ShapeBuilder
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private String width = "100%";
    private String height = "100%";
    private String margin = "0";
    private Shape shape = null;
    private Shape transition = null;
    private Orientation orientation = Orientation.left;

    public ShapeBuilder(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    public ShapeBuilder(String id, IModel<?> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("class", (CharSequence)this.getMarkupId());
    }

    public void renderHead(IHeaderResponse response) {
        String shapeDefinition = "shape-outside: " + this.shape.getName() + "(" + this.shape.getValues() + ");";
        String css = String.format("." + this.getMarkupId() + "{ float: %s %s %s %s %s %s", this.getOrientation().name() + ";", this.getDimension(), "-webkit-" + shapeDefinition, shapeDefinition, "-webkit-shape-margin:" + this.getMargin() + ";", "shape-margin:" + this.getMargin() + ";");
        String transitionCss = "";
        if (this.transition != null) {
            css = css + " transition: " + (this.transition.getTransitionTime() != null ? this.transition.getTransitionTime() + ";" : "1s;");
            String shapeTransitionDefinition = "shape-outside: " + this.transition.getName() + "(" + this.transition.getValues() + ");";
            transitionCss = String.format("." + this.getMarkupId() + ":hover{ %s %s }", "-webkit-" + shapeTransitionDefinition, shapeTransitionDefinition);
        }
        css = css + "}";
        response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)(css + " " + transitionCss), (String)(this.getMarkupId() + "css")));
    }

    protected String getDimension() {
        return "min-height: " + this.getHeight() + "; height:" + this.getHeight() + "; width: " + this.getWidth() + ";";
    }

    public String getWidth() {
        return this.width;
    }

    public ShapeBuilder useWidth(String width) {
        this.width = width;
        return this;
    }

    public String getHeight() {
        return this.height;
    }

    public ShapeBuilder useHeight(String height) {
        this.height = height;
        return this;
    }

    public String getMargin() {
        return this.margin;
    }

    public ShapeBuilder withMargin(String margin) {
        this.margin = margin;
        return this;
    }

    public Shape getShape() {
        return this.shape;
    }

    public ShapeBuilder shape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public Shape getTransition() {
        return this.transition;
    }

    public ShapeBuilder transition(Shape transition) {
        this.transition = transition;
        return this;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public ShapeBuilder orientation(Orientation orientation) {
        this.orientation = orientation;
        return this;
    }

    public static enum Orientation {
        left,
        right;

    }
}

