/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.shape;

import java.util.Arrays;
import java.util.List;
import org.wicketstuff.html5.shape.AbstractShape;

public class Polygon
extends AbstractShape {
    private List<String> keyValuePairs;

    public Polygon(String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalStateException("The key value pairs do not have a even number.");
        }
        if (keyValuePairs.length > 6) {
            throw new IllegalStateException("There has to be at least 6 values for a polygon.");
        }
        this.keyValuePairs = Arrays.asList(keyValuePairs);
    }

    @Override
    public String getName() {
        return "polygon";
    }

    @Override
    public String getValues() {
        StringBuilder values = new StringBuilder(50);
        int i = 0;
        for (String value : this.keyValuePairs) {
            values.append(value);
            values.append(" ");
            if ((i + 1) % 2 == 0 && i + 1 != this.keyValuePairs.size()) {
                values.append(",");
            }
            ++i;
        }
        return values.toString();
    }
}

