/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.media.webvtt;

import java.util.ArrayList;
import java.util.List;
import org.wicketstuff.html5.media.webvtt.VttCue;
import org.wicketstuff.html5.media.webvtt.VttRegion;

public class WebVtt {
    private List<VttCue> vttCues = new ArrayList<VttCue>();
    private List<VttRegion> vttRegions = new ArrayList<VttRegion>();
    private String description;
    private String note;

    public String getDescription() {
        return this.description;
    }

    public WebVtt setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public WebVtt setNote(String note) {
        this.note = note;
        return this;
    }

    public void addCue(VttCue vttCue) {
        this.vttCues.add(vttCue);
    }

    public void removeCue(VttCue vttCue) {
        this.vttCues.remove(vttCue);
    }

    public void removeCue(int index) {
        this.vttCues.remove(index);
    }

    public void addRegion(VttRegion vttRegion) {
        this.vttRegions.add(vttRegion);
    }

    public void removeRegion(VttRegion vttRegion) {
        this.vttRegions.remove(vttRegion);
    }

    public void removeRegion(int index) {
        this.vttRegions.remove(index);
    }

    public String create() {
        StringBuilder builder = new StringBuilder(1000);
        builder.append("WEBVTT");
        if (this.getDescription() != null) {
            builder.append(" - ");
            builder.append(this.getDescription().replace("\n", " "));
        }
        if (this.getNote() != null) {
            builder.append("\n\n");
            builder.append("NOTE \n");
            builder.append(this.getNote());
            builder.append("\n");
        }
        for (VttRegion vttRegion : this.vttRegions) {
            builder.append("\n");
            builder.append((CharSequence)vttRegion.getRepresentation());
        }
        for (VttCue vttCue : this.vttCues) {
            builder.append("\n\n");
            String note = vttCue.getNote();
            if (note != null) {
                builder.append("NOTE \n");
                builder.append(note);
                builder.append("\n\n");
            }
            builder.append((CharSequence)vttCue.getRepresentation());
        }
        return builder.toString();
    }
}

