/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.fileapi;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Bytes;
import org.wicketstuff.html5.fileapi.FileFieldChangeBehavior;
import org.wicketstuff.html5.fileapi.FileList;

public abstract class FileFieldSizeCheckBehavior
extends FileFieldChangeBehavior {
    private static final long serialVersionUID = -3780833214149694593L;
    private static final String UPLOAD_TOO_LARGE_RESOURCE_KEY = "uploadTooLarge";

    public FileFieldSizeCheckBehavior() {
    }

    public FileFieldSizeCheckBehavior(int maxNumOfFiles) {
        super(maxNumOfFiles);
    }

    protected FileFieldSizeCheckBehavior(String event, int maxNumOfFiles) {
        super(event, maxNumOfFiles);
    }

    @Override
    protected void onEvent(AjaxRequestTarget target, FileList fileList) {
        Bytes maxSize = this.getMaxSize();
        if (maxSize.lessThan(fileList.getSize())) {
            this.addErrorMsg(target, fileList);
            this.onError(target, fileList);
        } else {
            this.onSubmit(target, fileList);
        }
    }

    public Bytes getMaxSize() {
        return this.getFormComponent().getForm().getMaxSize();
    }

    protected void onBind() {
        super.onBind();
        if (!(this.getComponent() instanceof FormComponent)) {
            throw new WicketRuntimeException("Behavior " + ((Object)((Object)this)).getClass().getName() + " can only be added to an instance of a FormComponent");
        }
    }

    protected final FormComponent<?> getFormComponent() {
        return (FormComponent)this.getComponent();
    }

    protected void addErrorMsg(AjaxRequestTarget target, FileList fileList) {
        FormComponent<?> component = this.getFormComponent();
        Bytes maxSize = this.getMaxSize();
        HashMap<String, Bytes> model = new HashMap<String, Bytes>();
        model.put("maxSize", maxSize);
        String defaultValue = "Upload must be less than " + String.valueOf(maxSize);
        String msg = component.getString(component.getId() + ".uploadTooLarge", Model.ofMap(model), defaultValue);
        component.error((Serializable)((Object)msg));
    }

    protected abstract void onSubmit(AjaxRequestTarget var1, FileList var2);

    protected abstract void onError(AjaxRequestTarget var1, FileList var2);
}

