/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.eventsource;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventSourceResource
implements IResource {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceResource.class);

    public final void respond(IResource.Attributes attributes) {
        Response response = attributes.getResponse();
        HttpServletResponse containerResponse = (HttpServletResponse)response.getContainerResponse();
        EventSource eventSource = new EventSource(containerResponse, attributes.getParameters());
        this.respond(eventSource);
    }

    protected abstract void respond(EventSource var1);

    public static class EventSource {
        private static final Charset UTF8 = Charset.forName("UTF-8");
        private final HttpServletResponse containerResponse;
        private final OutputStream out;
        private final PageParameters parameters;
        private boolean isClosed = false;

        private EventSource(HttpServletResponse containerResponse, PageParameters parameters) {
            try {
                this.containerResponse = containerResponse;
                this.out = containerResponse.getOutputStream();
                this.parameters = parameters;
                containerResponse.setCharacterEncoding("UTF-8");
                containerResponse.setContentType("text/event-stream");
            }
            catch (IOException iox) {
                throw new WicketRuntimeException("An error occurred while getting servlet's response", (Throwable)iox);
            }
        }

        public EventSource event(String eventName) {
            Args.notNull((Object)eventName, (String)"eventName");
            this.write("event: " + eventName + "\n");
            return this;
        }

        public EventSource data(String data) {
            Args.notNull((Object)data, (String)"data");
            this.write("data: " + data + "\n");
            return this;
        }

        public EventSource id(String id) {
            if (id != null) {
                this.write("id: " + id);
            } else {
                this.write("id");
            }
            this.end();
            return this;
        }

        public EventSource retry(Duration retryTimeout) {
            Args.notNull((Object)retryTimeout, (String)"retryTimeout");
            if (!retryTimeout.equals(Duration.ZERO)) {
                this.write("retry: " + retryTimeout.toMillis());
                this.end();
            }
            return this;
        }

        public EventSource raw(String rawData) {
            if (rawData != null) {
                this.write(rawData);
            }
            return this;
        }

        public EventSource end() {
            this.write("\n");
            return this;
        }

        public void close() {
            try {
                this.isClosed = true;
                this.containerResponse.setStatus(410);
                this.containerResponse.setContentType("text/plain");
                this.out.flush();
                this.out.close();
            }
            catch (IOException iox) {
                LOG.debug("An error occurred while closing the connection", (Throwable)iox);
            }
        }

        public final PageParameters getParameters() {
            return this.parameters;
        }

        public final boolean isClosed() {
            return this.isClosed;
        }

        private void write(String data) {
            this.checkClosed();
            try {
                this.out.write(data.getBytes(UTF8));
                this.out.flush();
            }
            catch (IOException iox) {
                LOG.debug("An error occurred while writing the response", (Throwable)iox);
            }
        }

        private void checkClosed() {
            if (this.isClosed) {
                throw new WicketRuntimeException("The EventSource connection is already closed.");
            }
        }
    }
}

