/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.clipboardjs;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.clipboardjs.ClipboardJsReference;

public class ClipboardJsBehavior
extends Behavior {
    private String target;
    private IModel<String> textModel;
    private Action action = Action.COPY;

    public ClipboardJsBehavior setTarget(Component target) {
        Args.notNull((Object)target, (String)"target");
        target.setOutputMarkupId(true);
        this.target = "#" + target.getMarkupId();
        return this;
    }

    public ClipboardJsBehavior setTarget(String selector) {
        Args.notNull((Object)selector, (String)"selector");
        this.target = selector;
        return this;
    }

    public ClipboardJsBehavior setText(IModel<String> textModel) {
        Args.notNull(textModel, (String)"textModel");
        this.textModel = textModel;
        return this;
    }

    public ClipboardJsBehavior setAction(Action action) {
        this.action = action != null ? action : Action.COPY;
        return this;
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        String text;
        super.onComponentTag(component, tag);
        if (this.action == Action.CUT) {
            tag.put("data-clipboard-action", (CharSequence)"cut");
        }
        if (!Strings.isEmpty((String)this.target)) {
            tag.put("data-clipboard-target", (CharSequence)this.target);
        }
        if (this.textModel != null && !Strings.isEmpty((String)(text = (String)this.textModel.getObject()))) {
            tag.put("data-clipboard-text", (CharSequence)text);
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)ClipboardJsReference.INSTANCE));
        this.initializeClipboardJs(response, component);
    }

    protected void initializeClipboardJs(IHeaderResponse response, Component component) {
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("new ClipboardJS('#%s')", component.getMarkupId())));
    }

    public void detach(Component component) {
        super.detach(component);
        if (this.textModel != null) {
            this.textModel.detach();
        }
    }

    public static enum Action {
        COPY,
        CUT;

    }
}

