/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.annotation.scan;

import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.mapper.HomePageMapper;
import org.apache.wicket.core.request.mapper.MountedMapper;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.component.IRequestablePage;
import org.wicketstuff.annotation.mount.MountPath;
import org.wicketstuff.annotation.scan.AnnotatedMountList;
import org.wicketstuff.config.MatchingResources;

public class AnnotatedMountScanner {
    public String getPatternForPackage(String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageName = packageName.replace('.', '/')).endsWith("/")) {
            packageName = packageName + '/';
        }
        return "classpath*:" + packageName + "**/*.class";
    }

    public List<Class<?>> getPackageMatches(String pattern) {
        return this.getPatternMatches(this.getPatternForPackage(pattern));
    }

    public List<Class<?>> getPatternMatches(String pattern) {
        MatchingResources resources = new MatchingResources(pattern);
        List<Class<?>> mounts = resources.getAnnotatedMatches(MountPath.class);
        for (Class<?> mount : mounts) {
            if (Page.class.isAssignableFrom(mount)) continue;
            throw new RuntimeException("@MountPath annotated class should subclass Page: " + mount);
        }
        return mounts;
    }

    public AnnotatedMountList scanPackage(String packageName) {
        return this.scanList(this.getPackageMatches(packageName));
    }

    public AnnotatedMountList scanPattern(String pattern) {
        return this.scanList(this.getPatternMatches(pattern));
    }

    protected AnnotatedMountList scanList(List<Class<?>> mounts) {
        AnnotatedMountList list = new AnnotatedMountList();
        Iterator<Class<?>> iterator = mounts.iterator();
        while (iterator.hasNext()) {
            Class<?> mount;
            Class<?> page = mount = iterator.next();
            this.scanClass(page, list);
        }
        return list;
    }

    public AnnotatedMountList scanClass(Class<? extends Page> pageClass) {
        AnnotatedMountList list = new AnnotatedMountList();
        this.scanClass(pageClass, list);
        return list;
    }

    private void scanClass(Class<? extends Page> pageClass, AnnotatedMountList list) {
        MountPath mountPath = pageClass.getAnnotation(MountPath.class);
        if (mountPath == null) {
            return;
        }
        for (String alt : mountPath.alt()) {
            list.add(this.getRequestMapper(alt, pageClass));
        }
        String path = mountPath.value();
        if ("".equals(path)) {
            path = this.getDefaultMountPath(pageClass);
        }
        list.add(this.getRequestMapper(path, pageClass));
    }

    public IRequestMapper getRequestMapper(String mountPath, Class<? extends IRequestablePage> pageClass) {
        if ("/".equals(mountPath)) {
            return new HomePageMapper(pageClass);
        }
        return new MountedMapper(mountPath, pageClass);
    }

    public String getDefaultMountPath(Class<? extends IRequestablePage> pageClass) {
        return pageClass.getSimpleName();
    }
}

