/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.dragdrop;

import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.wicketstuff.jwicket.CssCursor;
import org.wicketstuff.jwicket.CssPosition;
import org.wicketstuff.jwicket.JQueryAjaxBehavior;
import org.wicketstuff.jwicket.JQueryJavascriptResourceReference;
import org.wicketstuff.jwicket.JsMap;
import org.wicketstuff.jwicket.JsOption;
import org.wicketstuff.jwicket.SpecialKeys;
import org.wicketstuff.jwicket.ui.AbstractJqueryUiEmbeddedBehavior;
import org.wicketstuff.jwicket.ui.dragdrop.AbstractDragDropBehavior;
import org.wicketstuff.jwicket.ui.dragdrop.IDraggable;

public class DraggableBehavior
extends AbstractDragDropBehavior {
    private static final long serialVersionUID = 1L;
    public static final JQueryJavascriptResourceReference jQueryUiDraggableJs = new JQueryJavascriptResourceReference(DraggableBehavior.class, "jquery.ui.draggable.min.js");
    private JsMap options = new JsMap();
    private String name = null;
    private boolean onDragStopNotificationWanted = false;
    private boolean onDragNotificationWanted = false;
    private boolean onDragStartNotificationWanted = false;

    public DraggableBehavior() {
        super(AbstractJqueryUiEmbeddedBehavior.jQueryUiWidgetJs, AbstractJqueryUiEmbeddedBehavior.jQueryUiMouseJs, SpecialKeys.specialKeysJs, jQueryUiDraggableJs);
    }

    protected void respond(AjaxRequestTarget target) {
        Request request;
        Component component = this.getComponent();
        if (component != null && (request = component.getRequest()) != null) {
            AbstractDragDropBehavior.EventType dragEventType = AbstractDragDropBehavior.EventType.stringToType(request.getParameter("wicketDragDropEvent"));
            if (component instanceof IDraggable) {
                IDraggable draggableComponent = (IDraggable)component;
                if (dragEventType == AbstractDragDropBehavior.EventType.DRAG_START) {
                    draggableComponent.onDragStart(target, new SpecialKeys(request));
                } else if (dragEventType == AbstractDragDropBehavior.EventType.DRAG_END) {
                    draggableComponent.onDragStop(target, new SpecialKeys(request));
                } else if (dragEventType == AbstractDragDropBehavior.EventType.DRAG) {
                    draggableComponent.onDrag(target, new SpecialKeys(request));
                }
            }
            if (dragEventType == AbstractDragDropBehavior.EventType.DRAG_START) {
                this.onDragStart(target, new SpecialKeys(request));
            } else if (dragEventType == AbstractDragDropBehavior.EventType.DRAG_END) {
                this.onDragStop(target, new SpecialKeys(request));
            } else if (dragEventType == AbstractDragDropBehavior.EventType.DRAG) {
                this.onDrag(target, new SpecialKeys(request));
            }
        }
    }

    public DraggableBehavior setName(String value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DraggableBehavior setAddClasses(boolean value) {
        if (value) {
            this.options.remove((Object)"addClasses");
        } else {
            this.options.put((Object)"addClasses", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setAddClasses(AjaxRequestTarget target, boolean value) {
        this.setAddClasses(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','addClasses'," + value + ");");
        return this;
    }

    public DraggableBehavior setAxis(char value) {
        if (value != 'x' && value != 'y') {
            this.options.remove((Object)"axis");
        } else {
            this.options.put((Object)"axis", (Object)String.valueOf(value));
        }
        return this;
    }

    public DraggableBehavior setAxis(AjaxRequestTarget target, char value) {
        this.setAxis(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','axis','" + value + "');");
        return this;
    }

    public DraggableBehavior setCursor(CssCursor value) {
        if (value == null) {
            this.options.remove((Object)"cursor");
        } else {
            this.options.put((Object)"cursor", (Object)value.getName());
        }
        return this;
    }

    public DraggableBehavior setCursor(AjaxRequestTarget target, CssCursor value) {
        this.setCursor(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','cursor','" + value.getName() + "');");
        return this;
    }

    public DraggableBehavior setCursorAt(CssPosition position, int offset) {
        if (position == null) {
            this.options.remove((Object)"cursorAt");
        } else {
            this.options.put((Object)"cursorAt", (Object)new JsOption(position.getName(), offset));
        }
        return this;
    }

    public DraggableBehavior setCursorAt(AjaxRequestTarget target, CssPosition position, int offset) {
        this.setCursorAt(position, offset);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','cursorAt',{" + position.getName() + ":" + offset + "});");
        return this;
    }

    public DraggableBehavior setCursorAt(CssPosition position1, int offset1, CssPosition position2, int offset2) {
        if (position1 == null || position2 == null) {
            this.options.remove((Object)"cursorAt");
        } else {
            this.options.put("cursorAt", new JsOption[]{new JsOption(position1.getName(), offset1), new JsOption(position2.getName(), offset2)});
        }
        return this;
    }

    public DraggableBehavior setCursorAt(AjaxRequestTarget target, CssPosition position1, int offset1, CssPosition position2, int offset2) {
        this.setCursorAt(position1, offset1, position2, offset2);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','cursorAt',{" + position1.getName() + ":" + offset1 + "," + position2.getName() + ":" + offset2 + "});");
        return this;
    }

    public DraggableBehavior setDelay(int value) {
        if (value <= 0) {
            this.options.remove((Object)"delay");
        } else {
            this.options.put((Object)"delay", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setDelay(AjaxRequestTarget target, int value) {
        this.setDelay(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','delay'," + value + ");");
        return this;
    }

    public DraggableBehavior setDistance(int value) {
        if (value <= 1) {
            this.options.remove((Object)"distance");
        } else {
            this.options.put((Object)"distance", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setDistance(AjaxRequestTarget target, int value) {
        this.setDistance(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','distance'," + value + ");");
        return this;
    }

    public DraggableBehavior setGrid(int x, int y) {
        if (x <= 1 && y <= 1) {
            this.options.remove((Object)"grid");
        } else {
            this.options.put("grid", new Object[]{x, y});
        }
        return this;
    }

    public DraggableBehavior setGrid(AjaxRequestTarget target, int x, int y) {
        this.setGrid(x, y);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','grid',[" + x + "," + y + "]);");
        return this;
    }

    public DraggableBehavior setDistance(String value) {
        if (value == null) {
            this.options.remove((Object)"helper");
        } else {
            this.options.put((Object)"helper", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setDistance(AjaxRequestTarget target, String value) {
        this.setDistance(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','helper','" + value + "');");
        return this;
    }

    public DraggableBehavior setIframeFix(boolean value) {
        if (!value) {
            this.options.remove((Object)"iframeFix");
        } else {
            this.options.put((Object)"iframeFix", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setIframeFix(AjaxRequestTarget target, boolean value) {
        this.setIframeFix(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','iframeFix'," + value + ");");
        return this;
    }

    public DraggableBehavior setOpacity(double value) {
        if (value < 0.0) {
            this.options.remove((Object)"opacity");
        } else {
            this.options.put((Object)"opacity", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setOpacity(AjaxRequestTarget target, double value) {
        this.setOpacity(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','opacity'," + value + ");");
        return this;
    }

    public DraggableBehavior setRefreshPositions(boolean value) {
        if (!value) {
            this.options.remove((Object)"refreshPositions");
        } else {
            this.options.put((Object)"refreshPositions", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setRefreshPositions(AjaxRequestTarget target, boolean value) {
        this.setRefreshPositions(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','refreshPositions'," + value + ");");
        return this;
    }

    public DraggableBehavior setRevert(DragRevertMode value) {
        if (value == null) {
            this.options.remove((Object)"revert");
        } else if (value.getBooleanValue() != null) {
            this.options.put((Object)"revert", (Object)value.getBooleanValue());
        } else {
            this.options.put((Object)"revert", (Object)value.getValue());
        }
        return this;
    }

    public DraggableBehavior setRevert(AjaxRequestTarget target, DragRevertMode value) {
        this.setRevert(value);
        if (value.getBooleanValue() != null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','revert'," + (Object)((Object)value) + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','revert','" + (Object)((Object)value) + "');");
        }
        return this;
    }

    public DraggableBehavior setRevertDuration(int value) {
        if (value < 0) {
            this.options.remove((Object)"revertDuration");
        } else {
            this.options.put((Object)"revertDuration", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setRevertDuration(AjaxRequestTarget target, int value) {
        this.setRevertDuration(value);
        if (value >= 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','revertDuration'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','revertDuration',0);");
        }
        return this;
    }

    public DraggableBehavior setScroll(boolean value) {
        if (value) {
            this.options.remove((Object)"scroll");
        } else {
            this.options.put((Object)"scroll", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setScroll(AjaxRequestTarget target, boolean value) {
        this.setScroll(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','scroll'," + value + ");");
        return this;
    }

    public DraggableBehavior setScrollSensitivity(int value) {
        if (value == 20) {
            this.options.remove((Object)"scrollSensitivity");
        } else {
            this.options.put((Object)"scrollSensitivity", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setScrollSensitivity(AjaxRequestTarget target, int value) {
        this.setScrollSensitivity(value);
        if (value > 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','scrollSensitivity'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','scrollSensitivity',0);");
        }
        return this;
    }

    public DraggableBehavior setScrollSpeed(int value) {
        if (value == 20) {
            this.options.remove((Object)"scrollSpeed");
        } else {
            this.options.put((Object)"scrollSpeed", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setScrollSpeed(AjaxRequestTarget target, int value) {
        this.setScrollSpeed(value);
        if (value > 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','scrollSpeed'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','scrollSpeed',0);");
        }
        return this;
    }

    public DraggableBehavior setSnap(boolean value) {
        if (!value) {
            this.options.remove((Object)"snap");
        } else {
            this.options.put((Object)"snap", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setSnap(AjaxRequestTarget target, boolean value) {
        this.setSnap(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','snap'," + value + ");");
        return this;
    }

    public DraggableBehavior setHelper(String function) {
        if (function == null) {
            this.options.remove((Object)"helper");
        } else {
            this.options.put((Object)"helper", (Object)new JQueryAjaxBehavior.JsFunction(function));
        }
        return this;
    }

    public DraggableBehavior setHelper(AjaxRequestTarget target, String function) {
        this.setHelper(function);
        if (function != null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','helper'," + function + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','helper','original');");
        }
        return this;
    }

    public DraggableBehavior setHelper(DragHelperMode value) {
        if (value == null) {
            this.options.remove((Object)"helper");
        } else {
            this.options.put((Object)"helper", (Object)value.getValue());
        }
        return this;
    }

    public DraggableBehavior setHelper(AjaxRequestTarget target, DragHelperMode value) {
        this.setHelper(value);
        if (value != null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','helper','" + (Object)((Object)value) + "');");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','helper','original');");
        }
        return this;
    }

    public DraggableBehavior setSnapMode(DragSnapMode value) {
        if (value == null) {
            this.options.remove((Object)"snapMode");
        } else {
            this.options.put((Object)"snapMode", (Object)value.getValue());
        }
        return this;
    }

    public DraggableBehavior setSnapMode(AjaxRequestTarget target, DragSnapMode value) {
        this.setSnapMode(value);
        if (value != null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','snapMode','" + (Object)((Object)value) + "');");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','snapMode','both');");
        }
        return this;
    }

    public DraggableBehavior setSnapTolerance(int value) {
        if (value == 20) {
            this.options.remove((Object)"snapTolerance");
        } else {
            this.options.put((Object)"snapTolerance", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setSnapTolerance(AjaxRequestTarget target, int value) {
        this.setSnapTolerance(value);
        if (value != 20) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','snapTolerance'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','snapTolerance',0);");
        }
        return this;
    }

    public DraggableBehavior setZIndex(long value) {
        if (value <= 0L) {
            this.options.remove((Object)"zIndex");
        } else {
            this.options.put((Object)"zIndex", (Object)value);
        }
        return this;
    }

    public DraggableBehavior setZIndex(AjaxRequestTarget target, int value) {
        this.setZIndex(value);
        if (value > 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','zIndex'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('option','zIndex',false);");
        }
        return this;
    }

    public DraggableBehavior setWantOnDragStopNotification(boolean value) {
        this.onDragStopNotificationWanted = value;
        return this;
    }

    public DraggableBehavior setWantOnDragNotification(boolean value) {
        this.onDragNotificationWanted = value;
        return this;
    }

    public DraggableBehavior setWantOnDragStartNotification(boolean value) {
        this.onDragStartNotificationWanted = value;
        return this;
    }

    protected void onDragStart(AjaxRequestTarget target, SpecialKeys specialKeys) {
    }

    protected void onDrag(AjaxRequestTarget target, SpecialKeys specialKeys) {
    }

    protected void onDragStop(AjaxRequestTarget target, SpecialKeys specialKeys) {
    }

    public void disable(AjaxRequestTarget target) {
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('disable');");
    }

    public void enable(AjaxRequestTarget target) {
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').draggable('enable');");
    }

    protected JQueryAjaxBehavior.JsBuilder getJsBuilder() {
        if (this.onDragStopNotificationWanted) {
            this.options.put((Object)AbstractDragDropBehavior.EventType.DRAG_END.getEventName(), (Object)new JQueryAjaxBehavior.JsFunction("function() { wicketAjaxGet('" + this.getCallbackUrl(false) + "&" + "wicketDragDropEvent" + "=" + AbstractDragDropBehavior.EventType.DRAG_END + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + "); }"));
        } else {
            this.options.remove((Object)AbstractDragDropBehavior.EventType.DRAG_END.getEventName());
        }
        if (this.onDragNotificationWanted) {
            this.options.put((Object)AbstractDragDropBehavior.EventType.DRAG.getEventName(), (Object)new JQueryAjaxBehavior.JsFunction("function() { wicketAjaxGet('" + this.getCallbackUrl() + "&" + "wicketDragDropEvent" + "=" + AbstractDragDropBehavior.EventType.DRAG + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + "); }"));
        } else {
            this.options.remove((Object)AbstractDragDropBehavior.EventType.DRAG.getEventName());
        }
        if (this.onDragStartNotificationWanted) {
            this.options.put((Object)AbstractDragDropBehavior.EventType.DRAG_START.getEventName(), (Object)new JQueryAjaxBehavior.JsFunction("function() { wicketAjaxGet('" + this.getCallbackUrl() + "&" + "wicketDragDropEvent" + "=" + AbstractDragDropBehavior.EventType.DRAG_START + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + "); }"));
        } else {
            this.options.remove((Object)AbstractDragDropBehavior.EventType.DRAG_START.getEventName());
        }
        JQueryAjaxBehavior.JsBuilder builder = new JQueryAjaxBehavior.JsBuilder();
        builder.append((Object)("jQuery('#" + this.getComponent().getMarkupId() + "').draggable("));
        builder.append((Object)"{");
        builder.append((Object)this.options.toString(this.rawOptions));
        builder.append((Object)"}");
        builder.append((Object)");");
        if (this.name != null) {
            builder.append((Object)new JQueryAjaxBehavior.JsFunction("\njQuery(function(){jQuery('#" + this.getComponent().getMarkupId() + "').attr('" + "dragClass" + "', '" + this.name + "');});"));
        }
        return builder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DragSnapMode {
        INNER("inner"),
        OUTER("outer"),
        BOTH("both");

        private final String value;

        private DragSnapMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DragHelperMode {
        ORIGINAL("original"),
        CLONE("clone");

        private final String value;

        private DragHelperMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DragRevertMode {
        NEVER("false", false),
        ALWAYS("true", true),
        VALID("valid"),
        INVALID("invalid");

        private final String value;
        private final Boolean booleanValue;

        private DragRevertMode(String value, boolean booleanValue) {
            this.value = value;
            this.booleanValue = booleanValue;
        }

        private DragRevertMode(String value) {
            this.value = value;
            this.booleanValue = null;
        }

        public String getValue() {
            return this.value;
        }

        public Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public String toString() {
            return this.value;
        }
    }
}

