/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.UnresolvedExpressionException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.api.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.api.coordinates.RunCoordinates;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.proxy.ProxyBuilder;
import org.wickedsource.docxstamper.proxy.ProxyException;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.ParagraphWrapper;
import org.wickedsource.docxstamper.util.walk.BaseCoordinatesWalker;

public class CommentProcessorRegistry {
    private Logger logger = LoggerFactory.getLogger(CommentProcessorRegistry.class);
    private Map<ICommentProcessor, Class<?>> commentProcessorInterfaces = new HashMap();
    private List<ICommentProcessor> commentProcessors = new ArrayList<ICommentProcessor>();
    private ExpressionResolver expressionResolver = new ExpressionResolver();
    private ExpressionUtil expressionUtil = new ExpressionUtil();
    private PlaceholderReplacer placeholderReplacer;
    private boolean failOnInvalidExpression = true;

    public CommentProcessorRegistry(PlaceholderReplacer placeholderReplacer) {
        this.placeholderReplacer = placeholderReplacer;
    }

    public void setExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    public void registerCommentProcessor(Class<?> interfaceClass, ICommentProcessor commentProcessor) {
        this.commentProcessorInterfaces.put(commentProcessor, interfaceClass);
        this.commentProcessors.add(commentProcessor);
    }

    public <T> void runProcessors(final WordprocessingMLPackage document, final ProxyBuilder<T> proxyBuilder) {
        final Map<BigInteger, CommentWrapper> comments = CommentUtil.getComments(document);
        BaseCoordinatesWalker walker = new BaseCoordinatesWalker(document){

            @Override
            protected void onParagraph(ParagraphCoordinates paragraphCoordinates) {
                CommentProcessorRegistry.this.runProcessorsOnParagraphComment(document, comments, proxyBuilder, paragraphCoordinates);
                CommentProcessorRegistry.this.runProcessorsOnInlineContent(proxyBuilder, paragraphCoordinates);
            }

            @Override
            protected CommentWrapper onRun(RunCoordinates runCoordinates, ParagraphCoordinates paragraphCoordinates) {
                return CommentProcessorRegistry.this.runProcessorsOnRunComment(document, comments, proxyBuilder, runCoordinates, paragraphCoordinates);
            }
        };
        walker.walk();
        for (ICommentProcessor processor : this.commentProcessors) {
            processor.commitChanges(document);
        }
    }

    private <T> void runProcessorsOnInlineContent(ProxyBuilder<T> proxyBuilder, ParagraphCoordinates paragraphCoordinates) {
        ParagraphWrapper paragraph = new ParagraphWrapper(paragraphCoordinates.getParagraph());
        List<String> processorExpressions = this.expressionUtil.findProcessorExpressions(paragraph.getText());
        for (String processorExpression : processorExpressions) {
            String strippedExpression = this.expressionUtil.stripExpression(processorExpression);
            for (ICommentProcessor processor : this.commentProcessors) {
                Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
                proxyBuilder.withInterface(commentProcessorInterface, processor);
                processor.setCurrentParagraphCoordinates(paragraphCoordinates);
            }
            try {
                T contextRootProxy = proxyBuilder.build();
                this.expressionResolver.resolveExpression(strippedExpression, contextRootProxy);
                this.placeholderReplacer.replace(paragraph, processorExpression, null);
                this.logger.debug(String.format("Processor expression '%s' has been successfully processed by a comment processor.", processorExpression));
            }
            catch (SpelEvaluationException | SpelParseException e) {
                if (this.failOnInvalidExpression) {
                    throw new UnresolvedExpressionException(strippedExpression, e);
                }
                this.logger.warn(String.format("Skipping processor expression '%s' because it can not be resolved by any comment processor. Reason: %s. Set log level to TRACE to view Stacktrace.", processorExpression, e.getMessage()));
                this.logger.trace("Reason for skipping processor expression: ", e);
            }
            catch (ProxyException e) {
                throw new DocxStamperException("Could not create a proxy around context root object", e);
            }
        }
    }

    private <T> void runProcessorsOnParagraphComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, ProxyBuilder<T> proxyBuilder, ParagraphCoordinates paragraphCoordinates) {
        Comments.Comment comment = CommentUtil.getCommentFor((ContentAccessor)paragraphCoordinates.getParagraph(), document);
        if (comment == null) {
            return;
        }
        String commentString = CommentUtil.getCommentString(comment);
        for (ICommentProcessor processor : this.commentProcessors) {
            Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
            proxyBuilder.withInterface(commentProcessorInterface, processor);
            processor.setCurrentParagraphCoordinates(paragraphCoordinates);
        }
        CommentWrapper commentWrapper = comments.get(comment.getId());
        try {
            T contextRootProxy = proxyBuilder.build();
            this.expressionResolver.resolveExpression(commentString, contextRootProxy);
            CommentUtil.deleteComment(commentWrapper);
            this.logger.debug(String.format("Comment '%s' has been successfully processed by a comment processor.", commentString));
        }
        catch (SpelEvaluationException | SpelParseException e) {
            if (this.failOnInvalidExpression) {
                throw new UnresolvedExpressionException(commentString, e);
            }
            this.logger.warn(String.format("Skipping comment expression '%s' because it can not be resolved by any comment processor. Reason: %s. Set log level to TRACE to view Stacktrace.", commentString, e.getMessage()));
            this.logger.trace("Reason for skipping comment: ", e);
        }
        catch (ProxyException e) {
            throw new DocxStamperException("Could not create a proxy around context root object", e);
        }
    }

    private <T> CommentWrapper runProcessorsOnRunComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, ProxyBuilder<T> proxyBuilder, RunCoordinates runCoordinates, ParagraphCoordinates paragraphCoordinates) {
        Comments.Comment comment = CommentUtil.getCommentAround(runCoordinates.getRun(), document);
        if (comment == null) {
            return null;
        }
        String commentString = CommentUtil.getCommentString(comment);
        for (ICommentProcessor processor : this.commentProcessors) {
            Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
            proxyBuilder.withInterface(commentProcessorInterface, processor);
            processor.setCurrentParagraphCoordinates(paragraphCoordinates);
            processor.setCurrentRunCoordinates(runCoordinates);
        }
        try {
            T contextRootProxy = proxyBuilder.build();
            CommentWrapper commentWrapper = comments.get(comment.getId());
            try {
                this.expressionResolver.resolveExpression(commentString, contextRootProxy);
                this.logger.debug(String.format("Comment '%s' has been successfully processed by a comment processor.", commentString));
                return commentWrapper;
            }
            catch (SpelEvaluationException | SpelParseException e) {
                if (this.failOnInvalidExpression) {
                    throw new UnresolvedExpressionException(commentString, e);
                }
                this.logger.warn(String.format("Skipping comment expression '%s' because it can not be resolved by any comment processor. Reason: %s. Set log level to TRACE to view Stacktrace.", commentString, e.getMessage()));
                this.logger.trace("Reason for skipping comment: ", e);
            }
        }
        catch (ProxyException e) {
            throw new DocxStamperException("Could not create a proxy around context root object", e);
        }
        return null;
    }

    public boolean isFailOnInvalidExpression() {
        return this.failOnInvalidExpression;
    }

    public void setFailOnInvalidExpression(boolean failOnInvalidExpression) {
        this.failOnInvalidExpression = failOnInvalidExpression;
    }

    public void reset() {
        for (ICommentProcessor processor : this.commentProcessors) {
            processor.reset();
        }
    }
}

