/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.util.Medium;

public class KeyHelper {
    private KeyHelper() {
    }

    public static IdentityKeyPair generateIdentityKeyPair() {
        ECKeyPair keyPair = Curve.generateKeyPair();
        IdentityKey publicKey = new IdentityKey(keyPair.getPublicKey());
        return new IdentityKeyPair(publicKey, keyPair.getPrivateKey());
    }

    public static int generateRegistrationId(boolean extendedRange) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            if (extendedRange) {
                return secureRandom.nextInt(0x7FFFFFFE) + 1;
            }
            return secureRandom.nextInt(16380) + 1;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static int getRandomSequence(int max) {
        try {
            return SecureRandom.getInstance("SHA1PRNG").nextInt(max);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static List<PreKeyRecord> generatePreKeys(int start, int count) {
        LinkedList<PreKeyRecord> results = new LinkedList<PreKeyRecord>();
        --start;
        for (int i = 0; i < count; ++i) {
            results.add(new PreKeyRecord((start + i) % (Medium.MAX_VALUE - 1) + 1, Curve.generateKeyPair()));
        }
        return results;
    }

    public static SignedPreKeyRecord generateSignedPreKey(IdentityKeyPair identityKeyPair, int signedPreKeyId) throws InvalidKeyException {
        ECKeyPair keyPair = Curve.generateKeyPair();
        byte[] signature = Curve.calculateSignature(identityKeyPair.getPrivateKey(), keyPair.getPublicKey().serialize());
        return new SignedPreKeyRecord(signedPreKeyId, System.currentTimeMillis(), keyPair, signature);
    }

    public static ECKeyPair generateSenderSigningKey() {
        return Curve.generateKeyPair();
    }

    public static byte[] generateSenderKey() {
        try {
            byte[] key = new byte[32];
            SecureRandom.getInstance("SHA1PRNG").nextBytes(key);
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static int generateSenderKeyId() {
        try {
            return SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.MAX_VALUE);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

