/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state;

import java.io.IOException;
import java.util.List;
import org.signal.client.internal.Native;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.logging.Log;
import org.whispersystems.libsignal.state.StorageProtos;
import org.whispersystems.libsignal.util.Pair;

public class SessionState {
    private StorageProtos.SessionStructure sessionStructure;
    private static final int MAX_MESSAGE_KEYS = 2000;

    public static SessionState initializeAliceSession(IdentityKeyPair identityKey, ECKeyPair baseKey, IdentityKey theirIdentityKey, ECPublicKey theirSignedPreKey, ECPublicKey theirRatchetKey) {
        try {
            return new SessionState(Native.SessionState_InitializeAliceSession(identityKey.getPrivateKey().nativeHandle(), identityKey.getPublicKey().getPublicKey().nativeHandle(), baseKey.getPrivateKey().nativeHandle(), baseKey.getPublicKey().nativeHandle(), theirIdentityKey.getPublicKey().nativeHandle(), theirSignedPreKey.nativeHandle(), theirRatchetKey.nativeHandle()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SessionState initializeBobSession(IdentityKeyPair identityKey, ECKeyPair signedPreKey, ECKeyPair ephemeralKey, IdentityKey theirIdentityKey, ECPublicKey theirBaseKey) {
        try {
            return new SessionState(Native.SessionState_InitializeBobSession(identityKey.getPrivateKey().nativeHandle(), identityKey.getPublicKey().getPublicKey().nativeHandle(), signedPreKey.getPrivateKey().nativeHandle(), signedPreKey.getPublicKey().nativeHandle(), ephemeralKey.getPrivateKey().nativeHandle(), ephemeralKey.getPublicKey().nativeHandle(), theirIdentityKey.getPublicKey().nativeHandle(), theirBaseKey.nativeHandle()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SessionState(byte[] serialized) throws IOException {
        this.sessionStructure = StorageProtos.SessionStructure.parseFrom(serialized);
    }

    public SessionState() {
        this.sessionStructure = (StorageProtos.SessionStructure)StorageProtos.SessionStructure.newBuilder().build();
    }

    public SessionState(StorageProtos.SessionStructure sessionStructure) {
        this.sessionStructure = sessionStructure;
    }

    public SessionState(SessionState copy) {
        this.sessionStructure = (StorageProtos.SessionStructure)((StorageProtos.SessionStructure.Builder)copy.sessionStructure.toBuilder()).build();
    }

    public StorageProtos.SessionStructure getStructure() {
        return this.sessionStructure;
    }

    public byte[] getAliceBaseKey() {
        return this.sessionStructure.getAliceBaseKey().toByteArray();
    }

    public int getSessionVersion() {
        int sessionVersion = this.sessionStructure.getSessionVersion();
        if (sessionVersion == 0) {
            return 2;
        }
        return sessionVersion;
    }

    public IdentityKey getRemoteIdentityKey() {
        try {
            if (!this.sessionStructure.hasRemoteIdentityPublic()) {
                return null;
            }
            return new IdentityKey(this.sessionStructure.getRemoteIdentityPublic().toByteArray(), 0);
        }
        catch (InvalidKeyException e) {
            Log.w("SessionRecordV2", e);
            return null;
        }
    }

    public IdentityKey getLocalIdentityKey() {
        try {
            return new IdentityKey(this.sessionStructure.getLocalIdentityPublic().toByteArray(), 0);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getPreviousCounter() {
        return this.sessionStructure.getPreviousCounter();
    }

    public ECPublicKey getSenderRatchetKey() {
        try {
            return Curve.decodePoint(this.sessionStructure.getSenderChain().getSenderRatchetKey().toByteArray(), 0);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ECKeyPair getSenderRatchetKeyPair() {
        ECPublicKey publicKey = this.getSenderRatchetKey();
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getSenderChain().getSenderRatchetKeyPrivate().toByteArray());
        return new ECKeyPair(publicKey, privateKey);
    }

    public boolean hasSenderChain() {
        return this.sessionStructure.hasSenderChain();
    }

    private Pair<StorageProtos.SessionStructure.Chain, Integer> getReceiverChain(ECPublicKey senderEphemeral) {
        List<StorageProtos.SessionStructure.Chain> receiverChains = this.sessionStructure.getReceiverChainsList();
        int index = 0;
        for (StorageProtos.SessionStructure.Chain receiverChain : receiverChains) {
            try {
                ECPublicKey chainSenderRatchetKey = Curve.decodePoint(receiverChain.getSenderRatchetKey().toByteArray(), 0);
                if (chainSenderRatchetKey.equals(senderEphemeral)) {
                    return new Pair<StorageProtos.SessionStructure.Chain, Integer>(receiverChain, index);
                }
            }
            catch (InvalidKeyException e) {
                Log.w("SessionRecordV2", e);
            }
            ++index;
        }
        return null;
    }

    public byte[] getReceiverChainKeyValue(ECPublicKey senderEphemeral) {
        Pair<StorageProtos.SessionStructure.Chain, Integer> receiverChainAndIndex = this.getReceiverChain(senderEphemeral);
        StorageProtos.SessionStructure.Chain receiverChain = receiverChainAndIndex.first();
        if (receiverChain == null) {
            return null;
        }
        return receiverChain.getChainKey().getKey().toByteArray();
    }

    public byte[] getSenderChainKeyValue() {
        StorageProtos.SessionStructure.Chain.ChainKey chainKeyStructure = this.sessionStructure.getSenderChain().getChainKey();
        return chainKeyStructure.getKey().toByteArray();
    }

    public int getRemoteRegistrationId() {
        return this.sessionStructure.getRemoteRegistrationId();
    }

    public int getLocalRegistrationId() {
        return this.sessionStructure.getLocalRegistrationId();
    }

    public byte[] serialize() {
        return this.sessionStructure.toByteArray();
    }
}

