/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.metadata.InvalidMetadataMessageException;
import org.signal.libsignal.metadata.InvalidMetadataVersionException;
import org.signal.libsignal.metadata.ProtocolDuplicateMessageException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyIdException;
import org.signal.libsignal.metadata.ProtocolInvalidMessageException;
import org.signal.libsignal.metadata.ProtocolInvalidVersionException;
import org.signal.libsignal.metadata.ProtocolLegacyMessageException;
import org.signal.libsignal.metadata.ProtocolNoSessionException;
import org.signal.libsignal.metadata.ProtocolUntrustedIdentityException;
import org.signal.libsignal.metadata.SelfSendException;
import org.signal.libsignal.metadata.certificate.CertificateValidator;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessage;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.InvalidMacException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.InvalidVersionException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.kdf.HKDFv3;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.PreKeySignalMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import org.whispersystems.libsignal.util.ByteUtil;
import org.whispersystems.libsignal.util.guava.Optional;

public class SealedSessionCipher {
    private static final String TAG = SealedSessionCipher.class.getSimpleName();
    private final SignalProtocolStore signalProtocolStore;
    private final String localE164Address;
    private final String localUuidAddress;
    private final int localDeviceId;

    public SealedSessionCipher(SignalProtocolStore signalProtocolStore, UUID localUuid, String localE164Address, int localDeviceId) {
        this.signalProtocolStore = signalProtocolStore;
        this.localUuidAddress = localUuid != null ? localUuid.toString() : null;
        this.localE164Address = localE164Address;
        this.localDeviceId = localDeviceId;
    }

    public byte[] encrypt(SignalProtocolAddress destinationAddress, SenderCertificate senderCertificate, byte[] paddedPlaintext) throws org.whispersystems.libsignal.InvalidKeyException, UntrustedIdentityException {
        CiphertextMessage message = new SessionCipher(this.signalProtocolStore, destinationAddress).encrypt(paddedPlaintext);
        IdentityKeyPair ourIdentity = this.signalProtocolStore.getIdentityKeyPair();
        ECPublicKey theirIdentity = this.signalProtocolStore.getIdentity(destinationAddress).getPublicKey();
        ECKeyPair ephemeral = Curve.generateKeyPair();
        byte[] ephemeralSalt = ByteUtil.combine("UnidentifiedDelivery".getBytes(), theirIdentity.serialize(), ephemeral.getPublicKey().serialize());
        EphemeralKeys ephemeralKeys = this.calculateEphemeralKeys(theirIdentity, ephemeral.getPrivateKey(), ephemeralSalt);
        byte[] staticKeyCiphertext = this.encrypt(ephemeralKeys.cipherKey, ephemeralKeys.macKey, ourIdentity.getPublicKey().getPublicKey().serialize());
        byte[] staticSalt = ByteUtil.combine(ephemeralKeys.chainKey, staticKeyCiphertext);
        StaticKeys staticKeys = this.calculateStaticKeys(theirIdentity, ourIdentity.getPrivateKey(), staticSalt);
        UnidentifiedSenderMessageContent content = new UnidentifiedSenderMessageContent(message.getType(), senderCertificate, message.serialize());
        byte[] messageBytes = this.encrypt(staticKeys.cipherKey, staticKeys.macKey, content.getSerialized());
        return new UnidentifiedSenderMessage(ephemeral.getPublicKey(), staticKeyCiphertext, messageBytes).getSerialized();
    }

    public DecryptionResult decrypt(CertificateValidator validator, byte[] ciphertext, long timestamp) throws InvalidMetadataMessageException, InvalidMetadataVersionException, ProtocolInvalidMessageException, ProtocolInvalidKeyException, ProtocolNoSessionException, ProtocolLegacyMessageException, ProtocolInvalidVersionException, ProtocolDuplicateMessageException, ProtocolInvalidKeyIdException, ProtocolUntrustedIdentityException, SelfSendException {
        UnidentifiedSenderMessageContent content;
        try {
            boolean isLocalUuid;
            IdentityKeyPair ourIdentity = this.signalProtocolStore.getIdentityKeyPair();
            UnidentifiedSenderMessage wrapper = new UnidentifiedSenderMessage(ciphertext);
            byte[] ephemeralSalt = ByteUtil.combine("UnidentifiedDelivery".getBytes(), ourIdentity.getPublicKey().getPublicKey().serialize(), wrapper.getEphemeral().serialize());
            EphemeralKeys ephemeralKeys = this.calculateEphemeralKeys(wrapper.getEphemeral(), ourIdentity.getPrivateKey(), ephemeralSalt);
            byte[] staticKeyBytes = this.decrypt(ephemeralKeys.cipherKey, ephemeralKeys.macKey, wrapper.getEncryptedStatic());
            ECPublicKey staticKey = Curve.decodePoint(staticKeyBytes, 0);
            byte[] staticSalt = ByteUtil.combine(ephemeralKeys.chainKey, wrapper.getEncryptedStatic());
            StaticKeys staticKeys = this.calculateStaticKeys(staticKey, ourIdentity.getPrivateKey(), staticSalt);
            byte[] messageBytes = this.decrypt(staticKeys.cipherKey, staticKeys.macKey, wrapper.getEncryptedMessage());
            content = new UnidentifiedSenderMessageContent(messageBytes);
            validator.validate(content.getSenderCertificate(), timestamp);
            if (!MessageDigest.isEqual(content.getSenderCertificate().getKey().serialize(), staticKeyBytes)) {
                throw new org.whispersystems.libsignal.InvalidKeyException("Sender's certificate key does not match key used in message");
            }
            boolean isLocalE164 = this.localE164Address != null && this.localE164Address.equals(content.getSenderCertificate().getSenderE164().orNull());
            boolean bl = isLocalUuid = this.localUuidAddress != null && this.localUuidAddress.equals(content.getSenderCertificate().getSenderUuid().orNull());
            if ((isLocalE164 || isLocalUuid) && content.getSenderCertificate().getSenderDeviceId() == this.localDeviceId) {
                throw new SelfSendException();
            }
        }
        catch (InvalidCertificateException | org.whispersystems.libsignal.InvalidKeyException | InvalidMacException e) {
            throw new InvalidMetadataMessageException(e);
        }
        try {
            return new DecryptionResult(content.getSenderCertificate().getSenderUuid(), content.getSenderCertificate().getSenderE164(), content.getSenderCertificate().getSenderDeviceId(), this.decrypt(content));
        }
        catch (InvalidMessageException e) {
            throw new ProtocolInvalidMessageException(e, content.getSenderCertificate().getSender(), content.getSenderCertificate().getSenderDeviceId());
        }
        catch (org.whispersystems.libsignal.InvalidKeyException e) {
            throw new ProtocolInvalidKeyException(e, content.getSenderCertificate().getSender(), content.getSenderCertificate().getSenderDeviceId());
        }
        catch (NoSessionException e) {
            throw new ProtocolNoSessionException(e, content.getSenderCertificate().getSender(), content.getSenderCertificate().getSenderDeviceId());
        }
        catch (LegacyMessageException e) {
            throw new ProtocolLegacyMessageException(e, content.getSenderCertificate().getSender(), content.getSenderCertificate().getSenderDeviceId());
        }
        catch (InvalidVersionException e) {
            throw new ProtocolInvalidVersionException(e, content.getSenderCertificate().getSender(), content.getSenderCertificate().getSenderDeviceId());
        }
        catch (DuplicateMessageException e) {
            throw new ProtocolDuplicateMessageException(e, content.getSenderCertificate().getSender(), content.getSenderCertificate().getSenderDeviceId());
        }
        catch (InvalidKeyIdException e) {
            throw new ProtocolInvalidKeyIdException(e, content.getSenderCertificate().getSender(), content.getSenderCertificate().getSenderDeviceId());
        }
        catch (UntrustedIdentityException e) {
            throw new ProtocolUntrustedIdentityException(e, content.getSenderCertificate().getSender(), content.getSenderCertificate().getSenderDeviceId());
        }
    }

    public int getSessionVersion(SignalProtocolAddress remoteAddress) {
        return new SessionCipher(this.signalProtocolStore, remoteAddress).getSessionVersion();
    }

    public int getRemoteRegistrationId(SignalProtocolAddress remoteAddress) {
        return new SessionCipher(this.signalProtocolStore, remoteAddress).getRemoteRegistrationId();
    }

    private EphemeralKeys calculateEphemeralKeys(ECPublicKey ephemeralPublic, ECPrivateKey ephemeralPrivate, byte[] salt) throws org.whispersystems.libsignal.InvalidKeyException {
        try {
            byte[] ephemeralSecret = Curve.calculateAgreement(ephemeralPublic, ephemeralPrivate);
            byte[] ephemeralDerived = new HKDFv3().deriveSecrets(ephemeralSecret, salt, new byte[0], 96);
            byte[][] ephemeralDerivedParts = ByteUtil.split(ephemeralDerived, 32, 32, 32);
            return new EphemeralKeys(ephemeralDerivedParts[0], ephemeralDerivedParts[1], ephemeralDerivedParts[2]);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    private StaticKeys calculateStaticKeys(ECPublicKey staticPublic, ECPrivateKey staticPrivate, byte[] salt) throws org.whispersystems.libsignal.InvalidKeyException {
        try {
            byte[] staticSecret = Curve.calculateAgreement(staticPublic, staticPrivate);
            byte[] staticDerived = new HKDFv3().deriveSecrets(staticSecret, salt, new byte[0], 96);
            byte[][] staticDerivedParts = ByteUtil.split(staticDerived, 32, 32, 32);
            return new StaticKeys(staticDerivedParts[1], staticDerivedParts[2]);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] decrypt(UnidentifiedSenderMessageContent message) throws InvalidVersionException, InvalidMessageException, org.whispersystems.libsignal.InvalidKeyException, DuplicateMessageException, InvalidKeyIdException, UntrustedIdentityException, LegacyMessageException, NoSessionException {
        SignalProtocolAddress sender = SealedSessionCipher.getPreferredAddress(this.signalProtocolStore, message.getSenderCertificate());
        switch (message.getType()) {
            case 2: {
                return new SessionCipher(this.signalProtocolStore, sender).decrypt(new SignalMessage(message.getContent()));
            }
            case 3: {
                return new SessionCipher(this.signalProtocolStore, sender).decrypt(new PreKeySignalMessage(message.getContent()));
            }
        }
        throw new InvalidMessageException("Unknown type: " + message.getType());
    }

    private byte[] encrypt(SecretKeySpec cipherKey, SecretKeySpec macKey, byte[] plaintext) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(1, (Key)cipherKey, new IvParameterSpec(new byte[16]));
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(macKey);
            byte[] ciphertext = cipher.doFinal(plaintext);
            byte[] ourFullMac = mac.doFinal(ciphertext);
            byte[] ourMac = ByteUtil.trim(ourFullMac, 10);
            return ByteUtil.combine(ciphertext, ourMac);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] decrypt(SecretKeySpec cipherKey, SecretKeySpec macKey, byte[] ciphertext) throws InvalidMacException {
        try {
            if (ciphertext.length < 10) {
                throw new InvalidMacException("Ciphertext not long enough for MAC!");
            }
            byte[][] ciphertextParts = ByteUtil.split(ciphertext, ciphertext.length - 10, 10);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(macKey);
            byte[] digest = mac.doFinal(ciphertextParts[0]);
            byte[] ourMac = ByteUtil.trim(digest, 10);
            byte[] theirMac = ciphertextParts[1];
            if (!MessageDigest.isEqual(ourMac, theirMac)) {
                throw new InvalidMacException("Bad mac!");
            }
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(2, (Key)cipherKey, new IvParameterSpec(new byte[16]));
            return cipher.doFinal(ciphertextParts[0]);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static SignalProtocolAddress getPreferredAddress(SignalProtocolStore store, SenderCertificate certificate) {
        SignalProtocolAddress e164Address;
        SignalProtocolAddress uuidAddress = certificate.getSenderUuid().isPresent() ? new SignalProtocolAddress(certificate.getSenderUuid().get(), certificate.getSenderDeviceId()) : null;
        SignalProtocolAddress signalProtocolAddress = e164Address = certificate.getSenderE164().isPresent() ? new SignalProtocolAddress(certificate.getSenderE164().get(), certificate.getSenderDeviceId()) : null;
        if (uuidAddress != null && store.containsSession(uuidAddress)) {
            return uuidAddress;
        }
        if (e164Address != null && store.containsSession(e164Address)) {
            return e164Address;
        }
        return new SignalProtocolAddress(certificate.getSender(), certificate.getSenderDeviceId());
    }

    private static class StaticKeys {
        private final SecretKeySpec cipherKey;
        private final SecretKeySpec macKey;

        private StaticKeys(byte[] cipherKey, byte[] macKey) {
            this.cipherKey = new SecretKeySpec(cipherKey, "AES");
            this.macKey = new SecretKeySpec(macKey, "HmacSHA256");
        }
    }

    private static class EphemeralKeys {
        private final byte[] chainKey;
        private final SecretKeySpec cipherKey;
        private final SecretKeySpec macKey;

        private EphemeralKeys(byte[] chainKey, byte[] cipherKey, byte[] macKey) {
            this.chainKey = chainKey;
            this.cipherKey = new SecretKeySpec(cipherKey, "AES");
            this.macKey = new SecretKeySpec(macKey, "HmacSHA256");
        }
    }

    public static class DecryptionResult {
        private final Optional<String> senderUuid;
        private final Optional<String> senderE164;
        private final int deviceId;
        private final byte[] paddedMessage;

        private DecryptionResult(Optional<String> senderUuid, Optional<String> senderE164, int deviceId, byte[] paddedMessage) {
            this.senderUuid = senderUuid;
            this.senderE164 = senderE164;
            this.deviceId = deviceId;
            this.paddedMessage = paddedMessage;
        }

        public Optional<String> getSenderUuid() {
            return this.senderUuid;
        }

        public Optional<String> getSenderE164() {
            return this.senderE164;
        }

        public int getDeviceId() {
            return this.deviceId;
        }

        public byte[] getPaddedMessage() {
            return this.paddedMessage;
        }
    }
}

