/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.dropwizard.simpleauth;

import io.dropwizard.auth.Auth;
import java.security.Principal;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;
import org.whispersystems.dropwizard.simpleauth.AuthPrincipal;

@Singleton
public class AuthValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public AuthValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, new Parameter.Source[]{Parameter.Source.UNKNOWN});
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(final Parameter parameter) {
        if (parameter.getAnnotation(Auth.class) == null) {
            return null;
        }
        return new AbstractContainerRequestValueFactory(){

            public Object provide() {
                Principal principal = this.getContainerRequest().getSecurityContext().getUserPrincipal();
                if (principal == null) {
                    throw new IllegalStateException("Cannot inject a custom principal into unauthenticated request");
                }
                if (!(principal instanceof AuthPrincipal)) {
                    throw new IllegalArgumentException("Cannot inject a non-AuthPrincipal into request");
                }
                if (!parameter.getRawType().isAssignableFrom(((AuthPrincipal)principal).getAuthenticated().getClass())) {
                    throw new IllegalArgumentException("Authenticated principal is of the wrong type!");
                }
                return parameter.getRawType().cast(((AuthPrincipal)principal).getAuthenticated());
            }
        };
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(AuthValueFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(AuthInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Auth>>(){}).in(Singleton.class);
        }
    }

    @Singleton
    private static class AuthInjectionResolver
    extends ParamInjectionResolver<Auth> {
        public AuthInjectionResolver() {
            super(AuthValueFactoryProvider.class);
        }
    }
}

