/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.dropwizard.simpleauth;

import com.google.common.base.Optional;
import com.google.common.io.BaseEncoding;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.basic.BasicCredentials;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.dropwizard.simpleauth.AuthFilter;
import org.whispersystems.dropwizard.simpleauth.AuthSecurityContext;

@Priority(value=1000)
public class BasicCredentialAuthFilter<P>
extends AuthFilter<BasicCredentials, P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicCredentialAuthFilter.class);

    private BasicCredentialAuthFilter() {
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        block5: {
            String header = (String)requestContext.getHeaders().getFirst((Object)"Authorization");
            try {
                String decoded;
                int i;
                String method;
                int space;
                if (header == null || (space = header.indexOf(32)) <= 0 || !this.prefix.equalsIgnoreCase(method = header.substring(0, space)) || (i = (decoded = new String(BaseEncoding.base64().decode((CharSequence)header.substring(space + 1)), StandardCharsets.UTF_8)).indexOf(58)) <= 0) break block5;
                String username = decoded.substring(0, i);
                String password = decoded.substring(i + 1);
                BasicCredentials credentials = new BasicCredentials(username, password);
                try {
                    Optional principal = this.authenticator.authenticate(credentials);
                    if (principal.isPresent()) {
                        requestContext.setSecurityContext(new AuthSecurityContext<Object>(principal.get(), false));
                        return;
                    }
                }
                catch (AuthenticationException e) {
                    LOGGER.warn("Error authenticating credentials", (Throwable)e);
                    throw new InternalServerErrorException();
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Error decoding credentials", (Throwable)e);
            }
        }
        throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
    }

    public static class Builder<P>
    extends AuthFilter.AuthFilterBuilder<BasicCredentials, P, BasicCredentialAuthFilter<P>> {
        @Override
        protected BasicCredentialAuthFilter<P> newInstance() {
            return new BasicCredentialAuthFilter();
        }
    }
}

