"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const limitNumber_1 = __importDefault(require("./limitNumber"));
const multipleOf_1 = __importDefault(require("./multipleOf"));
const limitLength_1 = __importDefault(require("./limitLength"));
const pattern_1 = __importDefault(require("./pattern"));
const limitProperties_1 = __importDefault(require("./limitProperties"));
const required_1 = __importDefault(require("./required"));
const limitItems_1 = __importDefault(require("./limitItems"));
const uniqueItems_1 = __importDefault(require("./uniqueItems"));
const const_1 = __importDefault(require("./const"));
const enum_1 = __importDefault(require("./enum"));
const validation = [
    // number
    limitNumber_1.default,
    multipleOf_1.default,
    // string
    limitLength_1.default,
    pattern_1.default,
    // object
    limitProperties_1.default,
    required_1.default,
    // array
    limitItems_1.default,
    uniqueItems_1.default,
    // any
    { keyword: "nullable", schemaType: "boolean" },
    const_1.default,
    enum_1.default,
];
exports.default = validation;
//# sourceMappingURL=index.js.map