"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const error_classes_1 = require("../../compile/error_classes");
const subschema_1 = require("../../compile/subschema");
const code_1 = require("../code");
const codegen_1 = require("../../compile/codegen");
const names_1 = __importDefault(require("../../compile/names"));
const compile_1 = require("../../compile");
const def = {
    keyword: "$ref",
    schemaType: "string",
    code(cxt) {
        const { gen, schema, it } = cxt;
        const { allErrors, baseId, schemaEnv: env, opts, validateName, self } = it;
        const passCxt = opts.passContext ? names_1.default.this : codegen_1.nil;
        if (schema === "#" || schema === "#/")
            return callRootRef();
        const schOrFunc = compile_1.resolveRef.call(self, env.root, baseId, schema);
        if (schOrFunc === undefined)
            throw new error_classes_1.MissingRefError(baseId, schema);
        if (schOrFunc instanceof compile_1.SchemaEnv)
            return callValidate(schOrFunc);
        return inlineRefSchema(schOrFunc);
        function callRootRef() {
            if (env === env.root)
                return callRef(validateName, env.$async);
            const rootName = gen.scopeValue("root", { ref: env.root });
            return callRef(codegen_1._ `${rootName}.validate`, env.root.$async);
        }
        function callValidate(sch) {
            let v;
            if (sch.validate) {
                v = gen.scopeValue("validate", { ref: sch.validate });
            }
            else {
                const code = codegen_1._ `{validate: ${sch.validateName}}`;
                const wrapper = gen.scopeValue("wrapper", { ref: sch, code });
                v = codegen_1._ `${wrapper}.validate`;
            }
            callRef(v, sch.$async);
        }
        function callRef(v, $async) {
            if ($async)
                callAsyncRef(v);
            else
                callSyncRef(v);
        }
        function inlineRefSchema(sch) {
            const schName = gen.scopeValue("schema", { ref: sch });
            const valid = gen.name("valid");
            subschema_1.applySubschema(it, {
                schema: sch,
                strictSchema: true,
                dataTypes: [],
                schemaPath: codegen_1.nil,
                topSchemaRef: schName,
                errSchemaPath: schema,
            }, valid);
            cxt.ok(valid);
        }
        function callAsyncRef(v) {
            if (!env.$async)
                throw new Error("async schema referenced by sync schema");
            const valid = gen.let("valid");
            gen.try(() => {
                gen.code(codegen_1._ `await ${code_1.callValidateCode(cxt, v, passCxt)}`);
                if (!allErrors)
                    gen.assign(valid, true);
            }, (e) => {
                gen.if(codegen_1._ `!(${e} instanceof ${it.ValidationError})`, () => gen.throw(e));
                addErrorsFrom(e);
                if (!allErrors)
                    gen.assign(valid, false);
            });
            cxt.ok(valid);
        }
        function callSyncRef(v) {
            cxt.pass(code_1.callValidateCode(cxt, v, passCxt), () => addErrorsFrom(v));
        }
        function addErrorsFrom(source) {
            const errs = codegen_1._ `${source}.errors`;
            gen.assign(names_1.default.vErrors, codegen_1._ `${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`); // TODO tagged
            gen.assign(names_1.default.errors, codegen_1._ `${names_1.default.vErrors}.length`);
        }
    },
};
exports.default = def;
//# sourceMappingURL=ref.js.map