"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const subschema_1 = require("../../compile/subschema");
const util_1 = require("../../compile/util");
const def = {
    keyword: "contains",
    type: "array",
    schemaType: ["object", "boolean"],
    before: "uniqueItems",
    trackErrors: true,
    code(cxt) {
        const { gen, schema, data, it } = cxt;
        if (util_1.alwaysValidSchema(it, schema)) {
            cxt.fail(codegen_1._ `${data}.length === 0`);
            return;
        }
        const valid = gen.name("valid");
        gen.forRange("i", 0, codegen_1._ `${data}.length`, (i) => {
            subschema_1.applySubschema(it, {
                keyword: "contains",
                dataProp: i,
                dataPropType: subschema_1.Type.Num,
                compositeRule: true,
            }, valid);
            gen.if(valid, () => gen.break());
        });
        cxt.result(valid, () => cxt.reset());
    },
    error: {
        message: "should contain a valid item",
    },
};
exports.default = def;
//# sourceMappingURL=contains.js.map