/*
 Highstock JS v8.0.4 (2020-03-10)

 All technical indicators for Highstock

 (c) 2010-2019 Pawel Fus

 License: www.highcharts.com/license
*/
(function(h){"object"===typeof module&&module.exports?(h["default"]=h,module.exports=h):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(t){h(t);h.Highcharts=t;return h}):h("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(h){function t(e,g,l,k){e.hasOwnProperty(g)||(e[g]=k.apply(null,l))}h=h?h._modules:{};t(h,"mixins/indicator-required.js",[h["parts/Utilities.js"]],function(e){var g=e.error;return{isParentLoaded:function(l,
k,f,d,c){if(l)return d?d(l):!0;g(c||this.generateMessage(f,k));return!1},generateMessage:function(l,k){return'Error: "'+l+'" indicator type requires "'+k+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+l}}});t(h,"indicators/indicators.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/indicator-required.js"]],function(e,g,l){var k=g.addEvent,f=g.error,d=g.extend,c=g.isArray,a=g.pick,b=g.seriesType,u=g.splat,r=e.Series,n=e.seriesTypes,
q=e.seriesTypes.ohlc.prototype,m=l.generateMessage;k(e.Series,"init",function(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&d(this,{pointValKey:q.pointValKey,keys:q.keys,pointArrayMap:q.pointArrayMap,toYData:q.toYData})});k(r,"afterSetOptions",function(a){a=a.options;var c=a.dataGrouping;c&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(c.approximation="ohlc")});b("sma","line",{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:0,period:14}},
{processData:function(){var a=this.options.compareToMain,c=this.linkedParent;r.prototype.processData.apply(this,arguments);c&&c.compareValue&&a&&(this.compareValue=c.compareValue)},bindTo:{series:!0,eventName:"updatedData"},hasDerivedData:!0,useCommonDataGrouping:!0,nameComponents:["period"],nameSuffixes:[],calculateOn:"init",requiredIndicators:[],requireIndicators:function(){var a={allLoaded:!0};this.requiredIndicators.forEach(function(c){n[c]?n[c].prototype.requireIndicators():(a.allLoaded=!1,a.needed=
c)});return a},init:function(a,c){function d(){var a=b.points||[],c=(b.xData||[]).length,d=b.getValues(b.linkedParent,b.options.params)||{values:[],xData:[],yData:[]},f=[],p=!0;if(c&&!b.hasGroupedData&&b.visible&&b.points)if(b.cropped){if(b.xAxis){var n=b.xAxis.min;var r=b.xAxis.max}c=b.cropData(d.xData,d.yData,n,r);for(n=0;n<c.xData.length;n++)f.push([c.xData[n]].concat(u(c.yData[n])));c=d.xData.indexOf(b.xData[0]);n=d.xData.indexOf(b.xData[b.xData.length-1]);-1===c&&n===d.xData.length-2&&f[0][0]===
a[0].x&&f.shift();b.updateData(f)}else d.xData.length!==c-1&&d.xData.length!==c+1&&(p=!1,b.updateData(d.values));p&&(b.xData=d.xData,b.yData=d.yData,b.options.data=d.values);!1===b.bindTo.series&&(delete b.processedXData,b.isDirty=!0,b.redraw());b.isDirtyData=!1}var b=this,p=b.requireIndicators();if(!p.allLoaded)return f(m(b.type,p.needed));r.prototype.init.call(b,a,c);a.linkSeries();b.dataEventsToUnbind=[];if(!b.linkedParent)return f("Series "+b.options.linkedTo+" not found! Check `linkedTo`.",!1,
a);b.dataEventsToUnbind.push(k(b.bindTo.series?b.linkedParent:b.linkedParent.xAxis,b.bindTo.eventName,d));if("init"===b.calculateOn)d();else var n=k(b.chart,b.calculateOn,function(){d();n()});return b},getName:function(){var b=this.name,c=[];b||((this.nameComponents||[]).forEach(function(b,d){c.push(this.options.params[b]+a(this.nameSuffixes[d],""))},this),b=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+c.join(", ")+")":""));return b},getValues:function(a,b){var d=b.period,f=
a.xData;a=a.yData;var u=a.length,n=0,p=0,r=[],k=[],q=[],m=-1;if(!(f.length<d)){for(c(a[0])&&(m=b.index?b.index:0);n<d-1;)p+=0>m?a[n]:a[n][m],n++;for(b=n;b<u;b++){p+=0>m?a[b]:a[b][m];var l=[f[b],p/d];r.push(l);k.push(l[0]);q.push(l[1]);p-=0>m?a[b-n]:a[b-n][m]}return{values:r,xData:k,yData:q}}},destroy:function(){this.dataEventsToUnbind.forEach(function(a){a()});r.prototype.destroy.apply(this,arguments)}});""});t(h,"indicators/accumulation-distribution.src.js",[h["parts/Utilities.js"]],function(e){var g=
e.error;e=e.seriesType;e("ad","sma",{params:{volumeSeriesID:"volume"}},{nameComponents:!1,nameBase:"Accumulation/Distribution",getValues:function(l,k){var f=k.period,d=l.xData,c=l.yData,a=k.volumeSeriesID,b=l.chart.get(a);k=b&&b.yData;var u=c?c.length:0,r=[],n=[],q=[];if(!(d.length<=f&&u&&4!==c[0].length)){if(b){for(;f<u;f++){l=r.length;a=c[f][1];b=c[f][2];var m=c[f][3],p=k[f];a=[d[f],m===a&&m===b||a===b?0:(2*m-b-a)/(a-b)*p];0<l&&(a[1]+=r[l-1][1]);r.push(a);n.push(a[0]);q.push(a[1])}return{values:r,
xData:n,yData:q}}g("Series "+a+" not found! Check `volumeSeriesID`.",!0,l.chart)}}});""});t(h,"indicators/ao.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,g){var l=g.correctFloat,k=g.isArray;g=g.seriesType;g("ao","sma",{greaterBarColor:"#06B535",lowerBarColor:"#F21313",threshold:0,groupPadding:.2,pointPadding:.2,states:{hover:{halo:{size:0}}}},{nameBase:"AO",nameComponents:!1,markerAttribs:e.noop,getColumnMetrics:e.seriesTypes.column.prototype.getColumnMetrics,crispCol:e.seriesTypes.column.prototype.crispCol,
translate:e.seriesTypes.column.prototype.translate,drawPoints:e.seriesTypes.column.prototype.drawPoints,drawGraph:function(){var f=this.options,d=this.points,c=f.greaterBarColor;f=f.lowerBarColor;var a=d[0];if(!this.userOptions.color&&a)for(a.color=c,a=1;a<d.length;a++)d[a].color=d[a].y>d[a-1].y?c:d[a].y<d[a-1].y?f:d[a-1].color},getValues:function(f){var d=f.xData||[];f=f.yData||[];var c=f.length,a=[],b=[],u=[],r=0,n=0,q;if(!(34>=d.length)&&k(f[0])&&4===f[0].length){for(q=0;33>q;q++){var m=(f[q][1]+
f[q][2])/2;29<=q&&(r=l(r+m));n=l(n+m)}for(q=33;q<c;q++){m=(f[q][1]+f[q][2])/2;r=l(r+m);n=l(n+m);m=r/5;var p=n/34;m=l(m-p);a.push([d[q],m]);b.push(d[q]);u.push(m);m=q+1-5;p=q+1-34;r=l(r-(f[m][1]+f[m][2])/2);n=l(n-(f[p][1]+f[p][2])/2)}return{values:a,xData:b,yData:u}}}});""});t(h,"mixins/multipe-lines.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,g){var l=g.defined,k=g.error,f=g.merge,d=e.each,c=e.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],
getTranslatedLinesNames:function(a){var b=[];d(this.pointArrayMap,function(c){c!==a&&b.push("plot"+c.charAt(0).toUpperCase()+c.slice(1))});return b},toYData:function(a){var b=[];d(this.pointArrayMap,function(c){b.push(a[c])});return b},translate:function(){var a=this,b=a.pointArrayMap,f=[],r;f=a.getTranslatedLinesNames();c.prototype.translate.apply(a,arguments);d(a.points,function(c){d(b,function(b,d){r=c[b];null!==r&&(c[f[d]]=a.yAxis.toPixels(r,!0))})})},drawGraph:function(){var a=this,b=a.linesApiNames,
u=a.points,r=u.length,n=a.options,q=a.graph,m={options:{gapSize:n.gapSize}},p=[],g=a.getTranslatedLinesNames(a.pointValKey),w;d(g,function(a,b){for(p[b]=[];r--;)w=u[r],p[b].push({x:w.x,plotX:w.plotX,plotY:w[a],isNull:!l(w[a])});r=u.length});d(b,function(b,d){p[d]?(a.points=p[d],n[b]?a.options=f(n[b].styles,m):k('Error: "There is no '+b+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),a.graph=a["graph"+b],c.prototype.drawGraph.call(a),
a["graph"+b]=a.graph):k('Error: "'+b+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});a.points=u;a.options=n;a.graph=q;c.prototype.drawGraph.call(a)}}});t(h,"indicators/aroon.src.js",[h["parts/Utilities.js"],h["mixins/multipe-lines.js"]],function(e,g){function l(d,c){var a=d[0],b=0,f;for(f=1;f<d.length;f++)if("max"===c&&d[f]>=a||"min"===c&&d[f]<=a)a=d[f],b=f;return b}var k=e.merge,f=e.pick;e=e.seriesType;e("aroon","sma",{params:{period:25},
marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},k(g,{nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y",linesApiNames:["aroonDown"],getValues:function(d,c){c=c.period;var a=d.xData,b=(d=d.yData)?d.length:0,u=[],r=[],n=[],k;for(k=c-1;k<b;k++){var m=d.slice(k-c+1,k+2);var p=
l(m.map(function(a){return f(a[2],a)}),"min");m=l(m.map(function(a){return f(a[1],a)}),"max");m=m/c*100;p=p/c*100;a[k+1]&&(u.push([a[k+1],m,p]),r.push(a[k+1]),n.push([m,p]))}return{values:u,xData:r,yData:n}}}));""});t(h,"indicators/aroon-oscillator.src.js",[h["parts/Globals.js"],h["mixins/multipe-lines.js"],h["mixins/indicator-required.js"],h["parts/Utilities.js"]],function(e,g,l,k){var f=k.merge;k=k.seriesType;var d=e.seriesTypes.aroon;k("aroonoscillator","aroon",{params:{period:25},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}},
f(g,{nameBase:"Aroon Oscillator",pointArrayMap:["y"],pointValKey:"y",linesApiNames:[],init:function(){var c=arguments,a=this;l.isParentLoaded(d,"aroon",a.type,function(b){b.prototype.init.apply(a,c)})},getValues:function(c,a){var b=[],f=[],k=[];c=d.prototype.getValues.call(this,c,a);for(a=0;a<c.yData.length;a++){var n=c.yData[a][0];var q=c.yData[a][1];n-=q;b.push([c.xData[a],n]);f.push(c.xData[a]);k.push(n)}return{values:b,xData:f,yData:k}}}));""});t(h,"indicators/atr.src.js",[h["parts/Utilities.js"]],
function(e){function g(f,d){return Math.max(f[1]-f[2],d===k?0:Math.abs(f[1]-d[3]),d===k?0:Math.abs(f[2]-d[3]))}var l=e.isArray;e=e.seriesType;var k;e("atr","sma",{params:{period:14}},{getValues:function(f,d){d=d.period;var c=f.xData,a=(f=f.yData)?f.length:0,b=1,k=0,r=0,n=[],q=[],m=[],p;var e=[[c[0],f[0]]];if(!(c.length<=d)&&l(f[0])&&4===f[0].length){for(p=1;p<=a;p++)if(e.push([c[p],f[p]]),d<b){var w=d;var v=c[p-1],A=g(f[p-1],f[p-2]);w=[v,(k*(w-1)+A)/w];k=w[1];n.push(w);q.push(w[0]);m.push(w[1])}else d===
b?(k=r/(p-1),n.push([c[p-1],k]),q.push(c[p-1]),m.push(k)):r+=g(f[p-1],f[p-2]),b++;return{values:n,xData:q,yData:m}}}});""});t(h,"indicators/bollinger-bands.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/multipe-lines.js"]],function(e,g,l){var k=g.isArray,f=g.merge;g=g.seriesType;var d=e.seriesTypes.sma;g("bb","sma",{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
marker:{enabled:!1},dataGrouping:{approximation:"averages"}},f(l,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"],init:function(){d.prototype.init.apply(this,arguments);this.options=f({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(c,a){var b=a.period,f=a.standardDeviation,r=c.xData,n=(c=c.yData)?c.length:0,q=[],m=[],p=[],l;if(!(r.length<
b)){var w=k(c[0]);for(l=b;l<=n;l++){var v=r.slice(l-b,l);var g=c.slice(l-b,l);var e=d.prototype.getValues.call(this,{xData:v,yData:g},a);v=e.xData[0];e=e.yData[0];for(var h=0,x=g.length,y=0;y<x;y++){var E=(w?g[y][a.index]:g[y])-e;h+=E*E}E=Math.sqrt(h/(x-1));g=e+f*E;E=e-f*E;q.push([v,g,e,E]);m.push(v);p.push([g,e,E])}return{values:q,xData:m,yData:p}}}}));""});t(h,"indicators/cci.src.js",[h["parts/Utilities.js"]],function(e){function g(k){return k.reduce(function(f,d){return f+d},0)}var l=e.isArray;
e=e.seriesType;e("cci","sma",{params:{period:14}},{getValues:function(k,f){f=f.period;var d=k.xData,c=(k=k.yData)?k.length:0,a=[],b=1,u=[],r=[],n=[];if(!(d.length<=f)&&l(k[0])&&4===k[0].length){for(;b<f;){var q=k[b-1];a.push((q[1]+q[2]+q[3])/3);b++}for(b=f;b<=c;b++){q=k[b-1];q=(q[1]+q[2]+q[3])/3;var m=a.push(q);var p=a.slice(m-f);m=g(p)/f;var e,w=p.length,v=0;for(e=0;e<w;e++)v+=Math.abs(m-p[e]);p=v/f;q=(q-m)/(.015*p);u.push([d[b-1],q]);r.push(d[b-1]);n.push(q)}return{values:u,xData:r,yData:n}}}});
""});t(h,"indicators/cmf.src.js",[h["parts/Utilities.js"]],function(e){e=e.seriesType;e("cmf","sma",{params:{period:14,volumeSeriesID:"volume"}},{nameBase:"Chaikin Money Flow",isValid:function(){var g=this.chart,l=this.options,k=this.linkedParent;g=this.volumeSeries||(this.volumeSeries=g.get(l.params.volumeSeriesID));var f=k&&k.yData&&4===k.yData[0].length;return!!(k&&g&&k.xData&&k.xData.length>=l.params.period&&g.xData&&g.xData.length>=l.params.period&&f)},getValues:function(g,l){if(this.isValid())return this.getMoneyFlow(g.xData,
g.yData,this.volumeSeries.yData,l.period)},getMoneyFlow:function(g,l,k,f){function d(a,b){var c=a[1],d=a[2];a=a[3];return null!==b&&null!==c&&null!==d&&null!==a&&c!==d?(a-d-(c-a))/(c-d)*b:(p=m,null)}var c=l.length,a=[],b=0,u=0,r=[],n=[],q=[],m,p=-1;if(0<f&&f<=c){for(m=0;m<f;m++)a[m]=d(l[m],k[m]),b+=k[m],u+=a[m];r.push(g[m-1]);n.push(m-p>=f&&0!==b?u/b:null);for(q.push([r[0],n[0]]);m<c;m++){a[m]=d(l[m],k[m]);b-=k[m-f];b+=k[m];u-=a[m-f];u+=a[m];var e=[g[m],m-p>=f?u/b:null];r.push(e[0]);n.push(e[1]);
q.push([e[0],e[1]])}}return{values:q,xData:r,yData:n}}});""});t(h,"indicators/dpo.src.js",[h["parts/Utilities.js"]],function(e){function g(f,d,c,a,b){d=k(d[c][a],d[c]);return b?l(f-d):l(f+d)}var l=e.correctFloat,k=e.pick;e=e.seriesType;e("dpo","sma",{params:{period:21}},{nameBase:"DPO",getValues:function(f,d){var c=d.period;d=d.index;var a=c+Math.floor(c/2+1),b=f.xData||[];f=f.yData||[];var u=f.length,r=[],n=[],l=[],m=0,p,e;if(!(b.length<=a)){for(p=0;p<c-1;p++)m=g(m,f,p,d);for(e=0;e<=u-a;e++){var w=
e+c-1;p=e+a-1;m=g(m,f,w,d);w=k(f[p][d],f[p]);w-=m/c;m=g(m,f,e,d,!0);r.push([b[p],w]);n.push(b[p]);l.push(w)}return{values:r,xData:n,yData:l}}}});""});t(h,"indicators/ema.src.js",[h["parts/Utilities.js"]],function(e){var g=e.correctFloat,l=e.isArray;e=e.seriesType;e("ema","sma",{params:{index:3,period:9}},{accumulatePeriodPoints:function(k,f,d){for(var c=0,a=0,b;a<k;)b=0>f?d[a]:d[a][f],c+=b,a++;return c},calculateEma:function(k,f,d,c,a,b,u){k=k[d-1];f=0>b?f[d-1]:f[d-1][b];c="undefined"===typeof a?
u:g(f*c+a*(1-c));return[k,c]},getValues:function(k,f){var d=f.period,c=k.xData,a=(k=k.yData)?k.length:0,b=2/(d+1),u=[],r=[],n=[],q=-1;if(!(a<d)){l(k[0])&&(q=f.index?f.index:0);f=this.accumulatePeriodPoints(d,q,k);for(f/=d;d<a+1;d++){var m=this.calculateEma(c,k,d,b,m,q,f);u.push(m);r.push(m[0]);n.push(m[1]);m=m[1]}return{values:u,xData:r,yData:n}}}});""});t(h,"indicators/chaikin.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/indicator-required.js"]],function(e,g,l){var k=g.correctFloat,
f=g.error;g=g.seriesType;var d=e.seriesTypes.ema,c=e.seriesTypes.ad;g("chaikin","ema",{params:{volumeSeriesID:"volume",periods:[3,10]}},{nameBase:"Chaikin Osc",nameComponents:["periods"],init:function(){var a=arguments,b=this;l.isParentLoaded(d,"ema",b.type,function(c){c.prototype.init.apply(b,a)})},getValues:function(a,b){var u=b.periods,r=b.period,n=[],l=[],m=[],p;if(2!==u.length||u[1]<=u[0])f('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');else if(b=
c.prototype.getValues.call(this,a,{volumeSeriesID:b.volumeSeriesID,period:r}))if(a=d.prototype.getValues.call(this,b,{period:u[0]}),b=d.prototype.getValues.call(this,b,{period:u[1]}),a&&b){u=u[1]-u[0];for(p=0;p<b.yData.length;p++)r=k(a.yData[p+u]-b.yData[p]),n.push([b.xData[p],r]),l.push(b.xData[p]),m.push(r);return{values:n,xData:l,yData:m}}}});""});t(h,"indicators/dema.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/indicator-required.js"]],function(e,g,l){var k=g.correctFloat,
f=g.isArray;g=g.seriesType;var d=e.seriesTypes.ema;g("dema","ema",{},{init:function(){var c=arguments,a=this;l.isParentLoaded(d,"ema",a.type,function(b){b.prototype.init.apply(a,c)})},getEMA:function(c,a,b,f,k,n){return d.prototype.calculateEma(n||[],c,"undefined"===typeof k?1:k,this.chart.series[0].EMApercent,a,"undefined"===typeof f?-1:f,b)},getValues:function(c,a){var b=a.period,l=2*b,r=c.xData,n=c.yData,q=n?n.length:0,m=-1,p=[],g=[],w=[],e=0,A=[],h;c.EMApercent=2/(b+1);if(!(q<2*b-1)){f(n[0])&&
(m=a.index?a.index:0);c=d.prototype.accumulatePeriodPoints(b,m,n);a=c/b;c=0;for(h=b;h<q+2;h++){h<q+1&&(e=this.getEMA(n,z,a,m,h)[1],A.push(e));var z=e;if(h<l)c+=e;else{h===l&&(a=c/b);e=A[h-b-1];var x=this.getEMA([e],x,a)[1];var y=[r[h-2],k(2*e-x)];p.push(y);g.push(y[0]);w.push(y[1])}}return{values:p,xData:g,yData:w}}}});""});t(h,"indicators/tema.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/indicator-required.js"]],function(e,g,l){var k=g.correctFloat,f=g.isArray;g=g.seriesType;
var d=e.seriesTypes.ema;g("tema","ema",{},{init:function(){var c=arguments,a=this;l.isParentLoaded(d,"ema",a.type,function(b){b.prototype.init.apply(a,c)})},getEMA:function(c,a,b,f,k,n){return d.prototype.calculateEma(n||[],c,"undefined"===typeof k?1:k,this.chart.series[0].EMApercent,a,"undefined"===typeof f?-1:f,b)},getTemaPoint:function(c,a,b,d){return[c[d-3],k(3*b.level1-3*b.level2+b.level3)]},getValues:function(c,a){var b=a.period,k=2*b,l=3*b,n=c.xData,g=c.yData,m=g?g.length:0,p=-1,e=[],w=[],
v=[],A=[],h=[],z,x,y={};c.EMApercent=2/(b+1);if(!(m<3*b-2)){f(g[0])&&(p=a.index?a.index:0);c=d.prototype.accumulatePeriodPoints(b,p,g);a=c/b;c=0;for(z=b;z<m+3;z++){z<m+1&&(y.level1=this.getEMA(g,E,a,p,z)[1],A.push(y.level1));var E=y.level1;if(z<k)c+=y.level1;else{z===k&&(a=c/b,c=0);y.level1=A[z-b-1];y.level2=this.getEMA([y.level1],L,a)[1];h.push(y.level2);var L=y.level2;if(z<l)c+=y.level2;else{z===l&&(a=c/b);z===m+1&&(y.level1=A[z-b-1],y.level2=this.getEMA([y.level1],L,a)[1],h.push(y.level2));y.level1=
A[z-b-2];y.level2=h[z-2*b-1];y.level3=this.getEMA([y.level2],y.prevLevel3,a)[1];if(x=this.getTemaPoint(n,l,y,z))e.push(x),w.push(x[0]),v.push(x[1]);y.prevLevel3=y.level3}}}return{values:e,xData:w,yData:v}}}});""});t(h,"indicators/trix.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/indicator-required.js"]],function(e,g,l){var k=g.correctFloat;g=g.seriesType;var f=e.seriesTypes.tema;g("trix","tema",{},{init:function(){var d=arguments,c=this;l.isParentLoaded(f,"tema",c.type,function(a){a.prototype.init.apply(c,
d)})},getTemaPoint:function(d,c,a,b){if(b>c)var f=[d[b-3],0!==a.prevLevel3?k(a.level3-a.prevLevel3)/a.prevLevel3*100:null];return f}});""});t(h,"indicators/apo.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/indicator-required.js"]],function(e,g,l){var k=g.error;g=g.seriesType;var f=e.seriesTypes.ema;g("apo","ema",{params:{periods:[10,20]}},{nameBase:"APO",nameComponents:["periods"],init:function(){var d=arguments,c=this;l.isParentLoaded(f,"ema",c.type,function(a){a.prototype.init.apply(c,
d)})},getValues:function(d,c){var a=c.periods,b=c.index;c=[];var l=[],r=[],n;if(2!==a.length||a[1]<=a[0])k('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var g=f.prototype.getValues.call(this,d,{index:b,period:a[0]});d=f.prototype.getValues.call(this,d,{index:b,period:a[1]});if(g&&d){a=a[1]-a[0];for(n=0;n<d.yData.length;n++)b=g.yData[n+a]-d.yData[n],c.push([d.xData[n],b]),l.push(d.xData[n]),r.push(b);return{values:c,xData:l,yData:r}}}}});""});
t(h,"indicators/ichimoku-kinko-hyo.src.js",[h["parts/Globals.js"],h["parts/Color.js"],h["parts/Utilities.js"]],function(e,g,l){function k(a){return a.reduce(function(a,b){return Math.max(a,b[1])},-Infinity)}function f(a){return a.reduce(function(a,b){return Math.min(a,b[2])},Infinity)}function d(a){return{high:k(a),low:f(a)}}function c(a){var b,c,d,f,k;a.series.forEach(function(a){if(a.xData)for(f=a.xData,k=c=a.xIncrement?1:f.length-1;0<k;k--)if(d=f[k]-f[k-1],b===p||d<b)b=d});return b}function a(a,
b,c,d){if(a&&b&&c&&d){var f=b.plotX-a.plotX;b=b.plotY-a.plotY;var k=d.plotX-c.plotX;d=d.plotY-c.plotY;var n=a.plotX-c.plotX,p=a.plotY-c.plotY;c=(-b*n+f*p)/(-k*b+f*d);k=(k*p-d*n)/(-k*b+f*d);if(0<=c&&1>=c&&0<=k&&1>=k)return{plotX:a.plotX+k*f,plotY:a.plotY+k*b}}return!1}function b(a){var b=a.indicator;b.points=a.points;b.nextPoints=a.nextPoints;b.color=a.color;b.options=q(a.options.senkouSpan.styles,a.gap);b.graph=a.graph;b.fillGraph=!0;h.prototype.drawGraph.call(b)}var u=g.parse,r=l.defined,n=l.isArray,
q=l.merge,m=l.objectEach;g=l.seriesType;var p,h=e.seriesTypes.sma;e.approximations["ichimoku-averages"]=function(){var a=[],b;[].forEach.call(arguments,function(c,d){a.push(e.approximations.average(c));b=!b&&"undefined"===typeof a[d]});return b?void 0:a};g("ikh","sma",{params:{period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}},{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period",
"periodTenkan"],init:function(){h.prototype.init.apply(this,arguments);this.options=q({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:u(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:u(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:u(this.color).setOpacity(.2).get()}}},this.options)},toYData:function(a){return[a.tenkanSen,a.kijunSen,
a.chikouSpan,a.senkouSpanA,a.senkouSpanB]},translate:function(){var a=this;h.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){r(b[c])&&(b["plot"+c]=a.yAxis.toPixels(b[c],!0),b.plotY=b["plot"+c],b.tooltipPos=[b.plotX,b["plot"+c]],b.isNull=!1)})})},drawGraph:function(){var c=this,d=c.points,f=d.length,k=c.options,n=c.graph,p=c.color,l={options:{gapSize:k.gapSize}},g=c.pointArrayMap.length,e=[[],[],[],[],[],[]],u={tenkanLine:e[0],kijunLine:e[1],chikouLine:e[2],
senkouSpanA:e[3],senkouSpanB:e[4],senkouSpan:e[5]},B=[],D=c.options.senkouSpan,t=D.color||D.styles.fill,N=D.negativeColor,J=[[],[]],M=[[],[]],P=0,K,Q,O;for(c.ikhMap=u;f--;){var F=d[f];for(K=0;K<g;K++)D=c.pointArrayMap[K],r(F[D])&&e[K].push({plotX:F.plotX,plotY:F["plot"+D],isNull:!1});N&&f!==d.length-1&&(D=u.senkouSpanB.length-1,F=a(u.senkouSpanA[D-1],u.senkouSpanA[D],u.senkouSpanB[D-1],u.senkouSpanB[D]),K={plotX:F.plotX,plotY:F.plotY,isNull:!1,intersectPoint:!0},F&&(u.senkouSpanA.splice(D,0,K),u.senkouSpanB.splice(D,
0,K),B.push(D)))}m(u,function(a,b){k[b]&&"senkouSpan"!==b&&(c.points=e[P],c.options=q(k[b].styles,l),c.graph=c["graph"+b],c.fillGraph=!1,c.color=p,h.prototype.drawGraph.call(c),c["graph"+b]=c.graph);P++});c.graphCollection&&c.graphCollection.forEach(function(a){c[a].destroy();delete c[a]});c.graphCollection=[];if(N&&u.senkouSpanA[0]&&u.senkouSpanB[0]){B.unshift(0);B.push(u.senkouSpanA.length-1);for(g=0;g<B.length-1;g++){D=B[g];F=B[g+1];f=u.senkouSpanB.slice(D,F+1);D=u.senkouSpanA.slice(D,F+1);if(1<=
Math.floor(f.length/2))if(F=Math.floor(f.length/2),f[F].plotY===D[F].plotY){for(O=K=F=0;O<f.length;O++)F+=f[O].plotY,K+=D[O].plotY;F=F>K?0:1}else F=f[F].plotY>D[F].plotY?0:1;else F=f[0].plotY>D[0].plotY?0:1;J[F]=J[F].concat(f);M[F]=M[F].concat(D)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(a,d){J[d].length&&M[d].length&&(Q=0===d?t:N,b({indicator:c,points:J[d],nextPoints:M[d],color:Q,options:k,gap:l,graph:c[a]}),c[a]=c.graph,c.graphCollection.push(a))})}else b({indicator:c,
points:u.senkouSpanB,nextPoints:u.senkouSpanA,color:t,options:k,gap:l,graph:c.graphsenkouSpan}),c.graphsenkouSpan=c.graph;delete c.nextPoints;delete c.fillGraph;c.points=d;c.options=k;c.graph=n},getGraphPath:function(a){var b=[];a=a||this.points;if(this.fillGraph&&this.nextPoints){var c=h.prototype.getGraphPath.call(this,this.nextPoints);c[0]="L";var d=h.prototype.getGraphPath.call(this,a);c=c.slice(0,d.length);for(var f=c.length-1;0<f;f-=3)b.push(c[f-2],c[f-1],c[f]);d=d.concat(b)}else d=h.prototype.getGraphPath.apply(this,
arguments);return d},getValues:function(a,b){var f=b.period,k=b.periodTenkan;b=b.periodSenkouSpanB;var l=a.xData,g=a.yData,u=g&&g.length||0;a=c(a.xAxis);var r=[],e=[],m;if(!(l.length<=f)&&n(g[0])&&4===g[0].length){var q=l[0]-f*a;for(m=0;m<f;m++)e.push(q+m*a);for(m=0;m<u;m++){if(m>=k){var h=g.slice(m-k,m);h=d(h);h=(h.high+h.low)/2}if(m>=f){var B=g.slice(m-f,m);B=d(B);B=(B.high+B.low)/2;var v=(h+B)/2}if(m>=b){var w=g.slice(m-b,m);w=d(w);w=(w.high+w.low)/2}q=g[m][3];var t=l[m];r[m]===p&&(r[m]=[]);r[m+
f]===p&&(r[m+f]=[]);r[m+f][0]=h;r[m+f][1]=B;r[m+f][2]=p;r[m][2]=q;m<=f&&(r[m+f][3]=p,r[m+f][4]=p);r[m+2*f]===p&&(r[m+2*f]=[]);r[m+2*f][3]=v;r[m+2*f][4]=w;e.push(t)}for(m=1;m<=f;m++)e.push(t+m*a);return{values:r,xData:e,yData:r}}}});""});t(h,"indicators/keltner-channels.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/multipe-lines.js"]],function(e,g,l){var k=g.correctFloat,f=g.merge;g=g.seriesType;var d=e.seriesTypes.sma,c=e.seriesTypes.ema,a=e.seriesTypes.atr;g("keltnerchannels",
"sma",{params:{period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1},f(l,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",
nameBase:"Keltner Channels",nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],requiredIndicators:["ema","atr"],init:function(){d.prototype.init.apply(this,arguments);this.options=f({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(b,d){var f=d.period,n=d.periodATR,l=d.multiplierATR,m=b.yData;m=m?m.length:0;var p=[];d=c.prototype.getValues(b,{period:f,index:d.index});var g=a.prototype.getValues(b,
{period:n}),e=[],u=[],h;if(!(m<f)){for(h=f;h<=m;h++){var C=d.values[h-f];var z=g.values[h-n];var x=C[0];b=k(C[1]+l*z[1]);z=k(C[1]-l*z[1]);C=C[1];p.push([x,b,C,z]);e.push(x);u.push([b,C,z])}return{values:p,xData:e,yData:u}}}}));""});t(h,"indicators/macd.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,g){var l=g.correctFloat,k=g.defined,f=g.merge;g=g.seriesType;var d=e.seriesTypes.sma,c=e.seriesTypes.ema;g("macd","sma",{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},
signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0},{nameComponents:["longPeriod","shortPeriod","signalPeriod"],requiredIndicators:["ema"],
pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:e.noop,getColumnMetrics:e.seriesTypes.column.prototype.getColumnMetrics,crispCol:e.seriesTypes.column.prototype.crispCol,init:function(){d.prototype.init.apply(this,arguments);this.options&&(this.options=f({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),
startIndex:this.macdZones.zones.length},this.resetZones=!0)},toYData:function(a){return[a.y,a.signal,a.MACD]},translate:function(){var a=this,b=["plotSignal","plotMACD"];e.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(c){[c.signal,c.MACD].forEach(function(d,f){null!==d&&(c[b[f]]=a.yAxis.toPixels(d,!0))})})},destroy:function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();d.prototype.destroy.apply(this,
arguments)},drawPoints:e.seriesTypes.column.prototype.drawPoints,drawGraph:function(){for(var a=this,b=a.points,c=b.length,l=a.options,n=a.zones,g={options:{gapSize:l.gapSize}},m=[[],[]],p;c--;)p=b[c],k(p.plotMACD)&&m[0].push({plotX:p.plotX,plotY:p.plotMACD,isNull:!k(p.plotMACD)}),k(p.plotSignal)&&m[1].push({plotX:p.plotX,plotY:p.plotSignal,isNull:!k(p.plotMACD)});["macd","signal"].forEach(function(b,c){a.points=m[c];a.options=f(l[b+"Line"].styles,g);a.graph=a["graph"+b];a.currentLineZone=b+"Zones";
a.zones=a[a.currentLineZone].zones;d.prototype.drawGraph.call(a);a["graph"+b]=a.graph});a.points=b;a.options=l;a.zones=n;a.currentLineZone=null},getZonesGraphs:function(a){var b=d.prototype.getZonesGraphs.call(this,a),c=b;this.currentLineZone&&(c=b.splice(this[this.currentLineZone].startIndex+1),c.length?c.splice(0,0,a[0]):c=[a[0]]);return c},applyZones:function(){var a=this.zones;this.zones=this.signalZones.zones;d.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&
this.graphmacd.hide();this.zones=a},getValues:function(a,b){var d=0,f=[],n=[],g=[];if(!(a.xData.length<b.longPeriod+b.signalPeriod)){var m=c.prototype.getValues(a,{period:b.shortPeriod});var p=c.prototype.getValues(a,{period:b.longPeriod});m=m.values;p=p.values;for(a=1;a<=m.length;a++)k(p[a-1])&&k(p[a-1][1])&&k(m[a+b.shortPeriod+1])&&k(m[a+b.shortPeriod+1][0])&&f.push([m[a+b.shortPeriod+1][0],0,null,m[a+b.shortPeriod+1][1]-p[a-1][1]]);for(a=0;a<f.length;a++)n.push(f[a][0]),g.push([0,null,f[a][3]]);
b=c.prototype.getValues({xData:n,yData:g},{period:b.signalPeriod,index:2});b=b.values;for(a=0;a<f.length;a++)f[a][0]>=b[0][0]&&(f[a][2]=b[d][1],g[a]=[0,b[d][1],f[a][3]],null===f[a][3]?(f[a][1]=0,g[a][0]=0):(f[a][1]=l(f[a][3]-b[d][1]),g[a][0]=l(f[a][3]-b[d][1])),d++);return{values:f,xData:n,yData:g}}}});""});t(h,"indicators/mfi.src.js",[h["parts/Utilities.js"]],function(e){function g(d){return d.reduce(function(c,a){return c+a})}function l(d){return(d[1]+d[2]+d[3])/3}var k=e.error,f=e.isArray;e=e.seriesType;
e("mfi","sma",{params:{period:14,volumeSeriesID:"volume",decimals:4}},{nameBase:"Money Flow Index",getValues:function(d,c){var a=c.period,b=d.xData,e=d.yData,r=e?e.length:0,n=c.decimals,q=1,m=d.chart.get(c.volumeSeriesID),p=m&&m.yData,h=[],w=[],v=[],A=[],C=[];if(!m)k("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,d.chart);else if(!(b.length<=a)&&f(e[0])&&4===e[0].length&&p){for(d=l(e[q]);q<a+1;)c=d,d=l(e[q]),c=d>=c,m=d*p[q],A.push(c?m:0),C.push(c?0:m),q++;for(a=q-1;a<r;a++)a>
q-1&&(A.shift(),C.shift(),c=d,d=l(e[a]),c=d>c,m=d*p[a],A.push(c?m:0),C.push(c?0:m)),c=g(C),m=g(A),c=m/c,c=parseFloat((100-100/(1+c)).toFixed(n)),h.push([b[a],c]),w.push(b[a]),v.push(c);return{values:h,xData:w,yData:v}}}});""});t(h,"indicators/momentum.src.js",[h["parts/Utilities.js"]],function(e){function g(k,f,d,c,a){d=d[c-1][3]-d[c-a-1][3];f=f[c-1];k.shift();return[f,d]}var l=e.isArray;e=e.seriesType;e("momentum","sma",{params:{period:14}},{nameBase:"Momentum",getValues:function(k,f){f=f.period;
var d=k.xData,c=(k=k.yData)?k.length:0,a=d[0],b=[],e=[],r=[];if(!(d.length<=f)&&l(k[0])){var n=k[0][3];n=[[a,n]];for(a=f+1;a<c;a++){var q=g(n,d,k,a,f,void 0);b.push(q);e.push(q[0]);r.push(q[1])}q=g(n,d,k,a,f,void 0);b.push(q);e.push(q[0]);r.push(q[1]);return{values:b,xData:e,yData:r}}}});""});t(h,"indicators/natr.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,g){g=g.seriesType;var l=e.seriesTypes.atr;g("natr","sma",{tooltip:{valueSuffix:"%"}},{requiredIndicators:["atr"],getValues:function(k,
f){var d=l.prototype.getValues.apply(this,arguments),c=d.values.length,a=f.period-1,b=k.yData,g=0;if(d){for(;g<c;g++)d.yData[g]=d.values[g][1]/b[a][3]*100,d.values[g][1]=d.yData[g],a++;return d}}});""});t(h,"indicators/pivot-points.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,g){function l(c,a){var b=c.series.pointArrayMap,f=b.length;for(d.prototype.pointClass.prototype[a].call(c);f--;)a="dataLabel"+b[f],c[a]&&c[a].element&&c[a].destroy(),c[a]=null}var k=g.defined,f=g.isArray;
g=g.seriesType;var d=e.seriesTypes.sma;g("pivotpoints","sma",{params:{period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}},{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",toYData:function(c){return[c.P]},translate:function(){var c=this;d.prototype.translate.apply(c);c.points.forEach(function(a){c.pointArrayMap.forEach(function(b){k(a[b])&&
(a["plot"+b]=c.yAxis.toPixels(a[b],!0))})});c.plotEndPoint=c.xAxis.toPixels(c.endPoint,!0)},getGraphPath:function(c){for(var a=this,b=c.length,f=[[],[],[],[],[],[],[],[],[]],g=[],n=a.plotEndPoint,l=a.pointArrayMap.length,m,p,e;b--;){p=c[b];for(e=0;e<l;e++)m=a.pointArrayMap[e],k(p[m])&&f[e].push({plotX:p.plotX,plotY:p["plot"+m],isNull:!1},{plotX:n,plotY:p["plot"+m],isNull:!1},{plotX:n,plotY:null,isNull:!0});n=p.plotX}f.forEach(function(b){g=g.concat(d.prototype.getGraphPath.call(a,b))});return g},
drawDataLabels:function(){var c=this,a=c.pointArrayMap,b,f,k;if(c.options.dataLabels.enabled){var n=c.points.length;a.concat([!1]).forEach(function(g,l){for(k=n;k--;)f=c.points[k],g?(f.y=f[g],f.pivotLine=g,f.plotY=f["plot"+g],b=f["dataLabel"+g],l&&(f["dataLabel"+a[l-1]]=f.dataLabel),f.dataLabels||(f.dataLabels=[]),f.dataLabels[0]=f.dataLabel=b=b&&b.element?b:null):f["dataLabel"+a[l-1]]=f.dataLabel;d.prototype.drawDataLabels.apply(c,arguments)})}},getValues:function(c,a){var b=a.period,d=c.xData,k=
(c=c.yData)?c.length:0;a=this[a.algorithm+"Placement"];var g=[],l=[],m=[],e;if(!(d.length<b)&&f(c[0])&&4===c[0].length){for(e=b+1;e<=k+b;e+=b){var h=d.slice(e-b-1,e);var w=c.slice(e-b-1,e);var v=h.length;var A=h[v-1];w=this.getPivotAndHLC(w);w=a(w);w=g.push([A].concat(w));l.push(A);m.push(g[w-1].slice(1))}this.endPoint=h[0]+(A-h[0])/v*b;return{values:g,xData:l,yData:m}}},getPivotAndHLC:function(c){var a=-Infinity,b=Infinity,d=c[c.length-1][3];c.forEach(function(c){a=Math.max(a,c[1]);b=Math.min(b,
c[2])});return[(a+b+d)/3,a,b,d]},standardPlacement:function(c){var a=c[1]-c[2];return[null,null,c[0]+a,2*c[0]-c[2],c[0],2*c[0]-c[1],c[0]-a,null,null]},camarillaPlacement:function(c){var a=c[1]-c[2];return[c[3]+1.5*a,c[3]+1.25*a,c[3]+1.1666*a,c[3]+1.0833*a,c[0],c[3]-1.0833*a,c[3]-1.1666*a,c[3]-1.25*a,c[3]-1.5*a]},fibonacciPlacement:function(c){var a=c[1]-c[2];return[null,c[0]+a,c[0]+.618*a,c[0]+.382*a,c[0],c[0]-.382*a,c[0]-.618*a,c[0]-a,null]}},{destroyElements:function(){l(this,"destroyElements")},
destroy:function(){l(this,"destroyElements")}});""});t(h,"indicators/ppo.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/indicator-required.js"]],function(e,g,l){var k=g.correctFloat,f=g.error;g=g.seriesType;var d=e.seriesTypes.ema;g("ppo","ema",{params:{periods:[12,26]}},{nameBase:"PPO",nameComponents:["periods"],init:function(){var c=arguments,a=this;l.isParentLoaded(d,"ema",a.type,function(b){b.prototype.init.apply(a,c)})},getValues:function(c,a){var b=a.periods,g=a.index;a=[];
var l=[],n=[],e;if(2!==b.length||b[1]<=b[0])f('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');else{var m=d.prototype.getValues.call(this,c,{index:g,period:b[0]});c=d.prototype.getValues.call(this,c,{index:g,period:b[1]});if(m&&c){b=b[1]-b[0];for(e=0;e<c.yData.length;e++)g=k((m.yData[e+b]-c.yData[e])/c.yData[e]*100),a.push([c.xData[e],g]),l.push(c.xData[e]),n.push(g);return{values:a,xData:l,yData:n}}}}});""});t(h,"mixins/reduce-array.js",[h["parts/Globals.js"]],
function(e){var g=e.reduce;return{minInArray:function(e,k){return g(e,function(f,d){return Math.min(f,d[k])},Number.MAX_VALUE)},maxInArray:function(e,k){return g(e,function(f,d){return Math.max(f,d[k])},-Number.MAX_VALUE)},getArrayExtremes:function(e,k,f){return g(e,function(d,c){return[Math.min(d[0],c[k]),Math.max(d[1],c[f])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});t(h,"indicators/price-channel.src.js",[h["parts/Utilities.js"],h["mixins/reduce-array.js"],h["mixins/multipe-lines.js"]],function(e,
g,l){var k=e.merge;e=e.seriesType;var f=g.getArrayExtremes;e("pc","sma",{params:{period:20},lineWidth:1,topLine:{styles:{lineColor:"#90ed7d",lineWidth:1}},bottomLine:{styles:{lineColor:"#f45b5b",lineWidth:1}},dataGrouping:{approximation:"averages"}},k(l,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],getValues:function(d,c){c=c.period;var a=d.xData,b=(d=d.yData)?d.length:0,k=[],g=[],e=[],l;if(!(b<
c)){for(l=c;l<=b;l++){var m=a[l-1];var p=d.slice(l-c,l);var h=f(p,2,1);p=h[1];var w=h[0];h=(p+w)/2;k.push([m,p,h,w]);g.push(m);e.push([p,h,w])}return{values:k,xData:g,yData:e}}}}));""});t(h,"indicators/price-envelopes.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,g){var l=g.isArray,k=g.merge;g=g.seriesType;var f=e.seriesTypes.sma;g("priceenvelopes","sma",{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle",init:function(){f.prototype.init.apply(this,arguments);this.options=k({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},
toYData:function(d){return[d.top,d.middle,d.bottom]},translate:function(){var d=this,c=["plotTop","plotMiddle","plotBottom"];f.prototype.translate.apply(d);d.points.forEach(function(a){[a.top,a.middle,a.bottom].forEach(function(b,f){null!==b&&(a[c[f]]=d.yAxis.toPixels(b,!0))})})},drawGraph:function(){for(var d=this,c=d.points,a=c.length,b=d.options,g=d.graph,e={options:{gapSize:b.gapSize}},l=[[],[]],h;a--;)h=c[a],l[0].push({plotX:h.plotX,plotY:h.plotTop,isNull:h.isNull}),l[1].push({plotX:h.plotX,
plotY:h.plotBottom,isNull:h.isNull});["topLine","bottomLine"].forEach(function(a,c){d.points=l[c];d.options=k(b[a].styles,e);d.graph=d["graph"+a];f.prototype.drawGraph.call(d);d["graph"+a]=d.graph});d.points=c;d.options=b;d.graph=g;f.prototype.drawGraph.call(d)},getValues:function(d,c){var a=c.period,b=c.topBand,k=c.bottomBand,g=d.xData,e=(d=d.yData)?d.length:0,h=[],m=[],p=[],B;if(!(g.length<a)&&l(d[0])&&4===d[0].length){for(B=a;B<=e;B++){var w=g.slice(B-a,B);var v=d.slice(B-a,B);v=f.prototype.getValues.call(this,
{xData:w,yData:v},c);w=v.xData[0];v=v.yData[0];var A=v*(1+b);var C=v*(1-k);h.push([w,A,v,C]);m.push(w);p.push([A,v,C])}return{values:h,xData:m,yData:p}}}});""});t(h,"indicators/psar.src.js",[h["parts/Utilities.js"]],function(e){e=e.seriesType;e("psar","sma",{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}},{nameComponents:!1,getValues:function(g,e){var k=g.xData;g=g.yData;var f=g[0][1],
d=e.maxAccelerationFactor,c=e.increment,a=e.initialAccelerationFactor,b=g[0][2],l=e.decimals,h=e.index,n=[],q=[],m=[],p=1,B;if(!(h>=g.length)){for(B=0;B<h;B++)f=Math.max(g[B][1],f),b=Math.min(g[B][2],parseFloat(b.toFixed(l)));var w=g[B][1]>b?1:-1;e=e.initialAccelerationFactor;var v=e*(f-b);n.push([k[h],b]);q.push(k[h]);m.push(parseFloat(b.toFixed(l)));for(B=h+1;B<g.length;B++){h=g[B-1][2];var A=g[B-2][2];var C=g[B-1][1];var z=g[B-2][1];var x=g[B][1];var y=g[B][2];null!==A&&null!==z&&null!==h&&null!==
C&&null!==x&&null!==y&&(b=w===p?1===w?b+v<Math.min(A,h)?b+v:Math.min(A,h):b+v>Math.max(z,C)?b+v:Math.max(z,C):f,h=1===w?x>f?x:f:y<f?y:f,x=1===p&&y>b||-1===p&&x>b?1:-1,p=x,v=h,y=c,A=d,C=a,e=p===w?1===p&&v>f?e===A?A:parseFloat((e+y).toFixed(2)):-1===p&&v<f?e===A?A:parseFloat((e+y).toFixed(2)):e:C,f=h-b,v=e*f,n.push([k[B],parseFloat(b.toFixed(l))]),q.push(k[B]),m.push(parseFloat(b.toFixed(l))),p=w,w=x,f=h)}return{values:n,xData:q,yData:m}}}});""});t(h,"indicators/roc.src.js",[h["parts/Utilities.js"]],
function(e){var g=e.isArray;e=e.seriesType;e("roc","sma",{params:{index:3,period:9}},{nameBase:"Rate of Change",getValues:function(e,k){var f=k.period,d=e.xData,c=(e=e.yData)?e.length:0,a=[],b=[],l=[],h=-1;if(!(d.length<=f)){g(e[0])&&(h=k.index);for(k=f;k<c;k++){var n=0>h?(n=e[k-f])?(e[k]-n)/n*100:null:(n=e[k-f][h])?(e[k][h]-n)/n*100:null;n=[d[k],n];a.push(n);b.push(n[0]);l.push(n[1])}return{values:a,xData:b,yData:l}}}});""});t(h,"indicators/rsi.src.js",[h["parts/Utilities.js"]],function(e){var g=
e.isArray;e=e.seriesType;e("rsi","sma",{params:{period:14,decimals:4}},{getValues:function(e,k){var f=k.period,d=e.xData,c=(e=e.yData)?e.length:0;k=k.decimals;var a=1,b=[],l=[],h=[],n=0,q=0,m;if(!(d.length<f)&&g(e[0])&&4===e[0].length){for(;a<f;){var p=parseFloat((e[a][3]-e[a-1][3]).toFixed(k));0<p?n+=p:q+=Math.abs(p);a++}var B=parseFloat((n/(f-1)).toFixed(k));for(m=parseFloat((q/(f-1)).toFixed(k));a<c;a++)p=parseFloat((e[a][3]-e[a-1][3]).toFixed(k)),0<p?(n=p,q=0):(n=0,q=Math.abs(p)),B=parseFloat(((B*
(f-1)+n)/f).toFixed(k)),m=parseFloat(((m*(f-1)+q)/f).toFixed(k)),n=0===m?100:0===B?0:parseFloat((100-100/(1+B/m)).toFixed(k)),b.push([d[a],n]),l.push(d[a]),h.push(n);return{values:b,xData:l,yData:h}}}});""});t(h,"indicators/stochastic.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/reduce-array.js"],h["mixins/multipe-lines.js"]],function(e,g,l,k){var f=g.isArray,d=g.merge;g=g.seriesType;var c=e.seriesTypes.sma,a=l.getArrayExtremes;g("stochastic","sma",{params:{periods:[14,3]},marker:{enabled:!1},
tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},d(k,{nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"],init:function(){c.prototype.init.apply(this,arguments);this.options=d({smoothedLine:{styles:{lineColor:this.color}}},
this.options)},getValues:function(b,d){var e=d.periods[0];d=d.periods[1];var k=b.xData,g=(b=b.yData)?b.length:0,m=[],l=[],h=[],w=null,v;if(!(g<e)&&f(b[0])&&4===b[0].length){for(v=e-1;v<g;v++){var u=b.slice(v-e+1,v+1);var C=a(u,2,1);var z=C[0];u=b[v][3]-z;z=C[1]-z;u=u/z*100;l.push(k[v]);h.push([u,null]);v>=e-1+(d-1)&&(w=c.prototype.getValues.call(this,{xData:l.slice(-d),yData:h.slice(-d)},{period:d}),w=w.yData[0]);m.push([k[v],u,w]);h[h.length-1][1]=w}return{values:m,xData:l,yData:h}}}}));""});t(h,
"indicators/slow-stochastic.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/indicator-required.js"]],function(e,g,l){g=g.seriesType;var k=e.seriesTypes;g("slowstochastic","stochastic",{params:{periods:[14,3,3]}},{nameBase:"Slow Stochastic",init:function(){var f=arguments,d=this;l.isParentLoaded(e.seriesTypes.stochastic,"stochastic",d.type,function(c){c.prototype.init.apply(d,f)})},getValues:function(f,d){var c=d.periods,a=k.stochastic.prototype.getValues.call(this,f,d);f={values:[],
xData:[],yData:[]};d=0;if(a){f.xData=a.xData.slice(c[1]-1);a=a.yData.slice(c[1]-1);var b=k.sma.prototype.getValues.call(this,{xData:f.xData,yData:a},{index:1,period:c[2]});if(b){for(var e=f.xData.length;d<e;d++)f.yData[d]=[a[d][1],b.yData[d-c[2]+1]||null],f.values[d]=[f.xData[d],a[d][1],b.yData[d-c[2]+1]||null];return f}}}});""});t(h,"indicators/supertrend.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"]],function(e,g){function l(a,c,b){return{index:c,close:a.yData[c][b],x:a.xData[c]}}var k=
g.correctFloat,f=g.merge,d=g.seriesType,c=g.isArray,a=g.objectEach,b=e.seriesTypes.atr,h=e.seriesTypes.sma;d("supertrend","sma",{params:{multiplier:3,period:10},risingTrendColor:"#06B535",fallingTrendColor:"#F21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}},{nameBase:"Supertrend",nameComponents:["multiplier","period"],requiredIndicators:["atr"],init:function(){h.prototype.init.apply(this,arguments);var a=this.options;a.cropThreshold=this.linkedParent.options.cropThreshold-
(a.params.period-1)},drawGraph:function(){var c=this,b=c.options,d=c.linkedParent,e=d?d.points:[],k=c.points,g=c.graph,u=k.length,v=e.length-u;v=0<v?v:0;for(var A={options:{gapSize:b.gapSize}},C={top:[],bottom:[],intersect:[]},z={top:{styles:{lineWidth:b.lineWidth,lineColor:b.fallingTrendColor||b.color,dashStyle:b.dashStyle}},bottom:{styles:{lineWidth:b.lineWidth,lineColor:b.risingTrendColor||b.color,dashStyle:b.dashStyle}},intersect:b.changeTrendLine},x,y,E,t,G,H,D,I;u--;)x=k[u],y=k[u-1],E=e[u-1+
v],t=e[u-2+v],G=e[u+v],H=e[u+v+1],D=x.options.color,I={x:x.x,plotX:x.plotX,plotY:x.plotY,isNull:!1},!t&&E&&d.yData[E.index-1]&&(t=l(d,E.index-1,3)),!H&&G&&d.yData[G.index+1]&&(H=l(d,G.index+1,3)),!E&&t&&d.yData[t.index+1]?E=l(d,t.index+1,3):!E&&G&&d.yData[G.index-1]&&(E=l(d,G.index-1,3)),x&&E&&G&&t&&x.x!==E.x&&(x.x===G.x?(t=E,E=G):x.x===t.x?(E=t,t={close:d.yData[E.index-1][3],x:d.xData[E.index-1]}):H&&x.x===H.x&&(E=H,t=G)),y&&t&&E?(G={x:y.x,plotX:y.plotX,plotY:y.plotY,isNull:!1},x.y>=E.close&&y.y>=
t.close?(x.color=D||b.fallingTrendColor||b.color,C.top.push(I)):x.y<E.close&&y.y<t.close?(x.color=D||b.risingTrendColor||b.color,C.bottom.push(I)):(C.intersect.push(I),C.intersect.push(G),C.intersect.push(f(G,{isNull:!0})),x.y>=E.close&&y.y<t.close?(x.color=D||b.fallingTrendColor||b.color,y.color=D||b.risingTrendColor||b.color,C.top.push(I),C.top.push(f(G,{isNull:!0}))):x.y<E.close&&y.y>=t.close&&(x.color=D||b.risingTrendColor||b.color,y.color=D||b.fallingTrendColor||b.color,C.bottom.push(I),C.bottom.push(f(G,
{isNull:!0}))))):E&&(x.y>=E.close?(x.color=D||b.fallingTrendColor||b.color,C.top.push(I)):(x.color=D||b.risingTrendColor||b.color,C.bottom.push(I)));a(C,function(a,b){c.points=a;c.options=f(z[b].styles,A);c.graph=c["graph"+b+"Line"];h.prototype.drawGraph.call(c);c["graph"+b+"Line"]=c.graph});c.points=k;c.options=b;c.graph=g},getValues:function(a,d){var f=d.period;d=d.multiplier;var e=a.xData,g=a.yData,l=[],h=[],n=[],u=0===f?0:f-1,r=[],z=[],x;if(!(e.length<=f||!c(g[0])||4!==g[0].length||0>f)){a=b.prototype.getValues.call(this,
a,{period:f}).yData;for(x=0;x<a.length;x++){var y=g[u+x];var t=g[u+x-1]||[];var L=r[x-1];var G=z[x-1];var H=n[x-1];0===x&&(L=G=H=0);f=k((y[1]+y[2])/2+d*a[x]);var D=k((y[1]+y[2])/2-d*a[x]);r[x]=f<L||t[3]>L?f:L;z[x]=D>G||t[3]<G?D:G;if(H===L&&y[3]<r[x]||H===G&&y[3]<z[x])var I=r[x];else if(H===L&&y[3]>r[x]||H===G&&y[3]>z[x])I=z[x];l.push([e[u+x],I]);h.push(e[u+x]);n.push(I)}return{values:l,xData:h,yData:n}}}});""});t(h,"indicators/volume-by-price.src.js",[h["parts/Globals.js"],h["parts/Point.js"],h["parts/Utilities.js"]],
function(e,g,l){var k=l.addEvent,f=l.animObject,d=l.arrayMax,c=l.arrayMin,a=l.correctFloat,b=l.error,h=l.extend,r=l.isArray;l=l.seriesType;var n=Math.abs,q=e.noop,m=e.seriesTypes.column.prototype;l("vbp","sma",{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,
zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}},{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:q,drawGraph:q,getColumnMetrics:m.getColumnMetrics,crispCol:m.crispCol,init:function(a){e.seriesTypes.sma.prototype.init.apply(this,arguments);var b=this.options.params;var c=this.linkedParent;
b=a.get(b.volumeSeriesID);this.addCustomEvents(c,b);return this},addCustomEvents:function(a,b){function c(){d.chart.redraw();d.setData([]);d.zoneStarts=[];d.zoneLinesSVG&&(d.zoneLinesSVG.destroy(),delete d.zoneLinesSVG)}var d=this;d.dataEventsToUnbind.push(k(a,"remove",function(){c()}));b&&d.dataEventsToUnbind.push(k(b,"remove",function(){c()}));return d},animate:function(a){var b=this,c={};a||(c.translateX=b.yAxis.pos,b.group.animate(c,h(f(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,
c.pos)})}})))},drawPoints:function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),m.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));m.drawPoints.apply(this,arguments)},posNegVolume:function(a,b){var c=b?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,f=this.points.length,e=[],k=[],g=0,l;a?(this.posWidths=e,this.negWidths=k):(e=this.posWidths,k=this.negWidths);for(;g<f;g++){var h=this.points[g];h[c[0]+"Graphic"]=h.graphic;h.graphic=h[c[1]+
"Graphic"];if(a){var m=h.shapeArgs.width;var p=this.priceZones[g];(l=p.wholeVolumeData)?(e.push(m/l*p.positiveVolumeData),k.push(m/l*p.negativeVolumeData)):(e.push(0),k.push(0))}h.color=b?d.styles.positiveColor:d.styles.negativeColor;h.shapeArgs.width=b?this.posWidths[g]:this.negWidths[g];h.shapeArgs.x=b?h.shapeArgs.x:this.posWidths[g]}},translate:function(){var b=this,c=b.options,f=b.chart,e=b.yAxis,k=e.min,g=b.options.zoneLines,l=b.priceZones,h=0,r,u,q;m.translate.apply(b);var t=b.points;if(t.length){var H=
.5>c.pointPadding?c.pointPadding:.1;c=b.volumeDataArray;var D=d(c);var I=f.plotWidth/2;var N=f.plotTop;var J=n(e.toPixels(k)-e.toPixels(k+b.rangeStep));var M=n(e.toPixels(k)-e.toPixels(k+b.rangeStep));H&&(k=n(J*(1-2*H)),h=n((J-k)/2),J=n(k));t.forEach(function(c,d){u=c.barX=c.plotX=0;q=c.plotY=e.toPixels(l[d].start)-N-(e.reversed?J-M:J)-h;r=a(I*l[d].wholeVolumeData/D);c.pointWidth=r;c.shapeArgs=b.crispCol.apply(b,[u,q,r,J]);c.volumeNeg=l[d].negativeVolumeData;c.volumePos=l[d].positiveVolumeData;c.volumeAll=
l[d].wholeVolumeData});g.enabled&&b.drawZones(f,e,b.zoneStarts,g.styles)}},getValues:function(a,c){var d=a.processedXData,f=a.processedYData,e=this.chart,k=c.ranges,g=[],l=[],h=[],m;if(a.chart)if(m=e.get(c.volumeSeriesID))if((c=r(f[0]))&&4!==f[0].length)b("Type of "+a.name+" series is different than line, OHLC or candlestick.",!0,e);else return(this.priceZones=this.specifyZones(c,d,f,k,m)).forEach(function(a,b){g.push([a.x,a.end]);l.push(g[b][0]);h.push(g[b][1])}),{values:g,xData:l,yData:h};else b("Series "+
c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,e);else b("Base series not found! In case it has been removed, add a new one.",!0,e)},specifyZones:function(b,f,e,k,g){if(b){var l=e.length;for(var h=e[0][3],m=h,n=1,p;n<l;n++)p=e[n][3],p<h&&(h=p),p>m&&(m=p);l={min:h,max:m}}else l=!1;l=(h=l)?h.min:c(e);p=h?h.max:d(e);h=this.zoneStarts=[];m=[];var r=0;n=1;if(!l||!p)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];var u=this.rangeStep=a(p-l)/k;for(h.push(l);r<
k-1;r++)h.push(a(h[r]+u));h.push(p);for(k=h.length;n<k;n++)m.push({index:n-1,x:f[0],start:h[n-1],end:h[n]});return this.volumePerZone(b,m,g,f,e)},volumePerZone:function(a,b,c,d,f){var e=this,k=c.processedXData,g=c.processedYData,h=b.length-1,l=f.length;c=g.length;var m,p,r,u,q;n(l-c)&&(d[0]!==k[0]&&g.unshift(0),d[l-1]!==k[c-1]&&g.push(0));e.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(q=b.negativeVolumeData=0;q<l;q++)r=p=!1,u=a?f[q][3]:f[q],m=q?a?f[q-1][3]:
f[q-1]:u,u<=b.start&&0===b.index&&(p=!0),u>=b.end&&b.index===h&&(r=!0),(u>b.start||p)&&(u<b.end||r)&&(b.wholeVolumeData+=g[q],m>u?b.negativeVolumeData+=g[q]:b.positiveVolumeData+=g[q]);e.volumeDataArray.push(b.wholeVolumeData)});return b},drawZones:function(a,b,c,d){var f=a.renderer,e=this.zoneLinesSVG,k=[],g=a.plotWidth,h=a.plotTop,l;c.forEach(function(c){l=b.toPixels(c)-h;k=k.concat(a.renderer.crispLine(["M",0,l,"L",g,l],d.lineWidth))});e?e.animate({d:k}):e=this.zoneLinesSVG=f.path(k).attr({"stroke-width":d.lineWidth,
stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)}},{destroy:function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return g.prototype.destroy.apply(this,arguments)}});""});t(h,"indicators/vwap.src.js",[h["parts/Utilities.js"]],function(e){var g=e.error,l=e.isArray;e=e.seriesType;e("vwap","sma",{params:{period:30,volumeSeriesID:"volume"}},{getValues:function(e,f){var d=e.chart,c=e.xData;e=e.yData;var a=f.period,b=!0,k;if(k=d.get(f.volumeSeriesID))return l(e[0])||
(b=!1),this.calculateVWAPValues(b,c,e,k,a);g("Series "+f.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,d)},calculateVWAPValues:function(e,f,d,c,a){var b=c.yData,k=c.xData.length,g=f.length;c=[];var l=[],h=[],m=[],p=[],t;k=g<=k?g:k;for(t=g=0;g<k;g++){var w=e?(d[g][1]+d[g][2]+d[g][3])/3:d[g];w*=b[g];w=t?c[g-1]+w:w;var v=t?l[g-1]+b[g]:b[g];c.push(w);l.push(v);p.push([f[g],w/v]);h.push(p[g][0]);m.push(p[g][1]);t++;t===a&&(t=0)}return{values:p,xData:h,yData:m}}});""});t(h,"indicators/williams-r.src.js",
[h["parts/Utilities.js"],h["mixins/reduce-array.js"]],function(e,g){var l=e.isArray;e=e.seriesType;var k=g.getArrayExtremes;e("williamsr","sma",{params:{period:14}},{nameBase:"Williams %R",getValues:function(f,d){d=d.period;var c=f.xData,a=(f=f.yData)?f.length:0,b=[],e=[],g=[],h;if(!(c.length<d)&&l(f[0])&&4===f[0].length){for(h=d-1;h<a;h++){var q=f.slice(h-d+1,h+1);var m=k(q,2,1);q=m[0];m=m[1];var p=f[h][3];q=(m-p)/(m-q)*-100;c[h]&&(b.push([c[h],q]),e.push(c[h]),g.push(q))}return{values:b,xData:e,
yData:g}}}});""});t(h,"indicators/wma.src.js",[h["parts/Utilities.js"]],function(e){function g(f,d){d*=(d+1)/2;return f.reduce(function(c,a,b){return[null,c[1]+a[1]*(b+1)]})[1]/d}function h(f,d,c,a){c=g(f,f.length);d=d[a-1];f.shift();return[d,c]}var k=e.isArray;e=e.seriesType;e("wma","sma",{params:{index:3,period:9}},{getValues:function(f,d){var c=d.period,a=f.xData,b=(f=f.yData)?f.length:0,e=1,g=a[0],l=f[0],q=[],m=[],p=[],t=-1;if(!(a.length<c)){k(f[0])&&(t=d.index,l=f[0][t]);for(d=[[g,l]];e!==c;)d.push([a[e],
0>t?f[e]:f[e][t]]),e++;for(c=e;c<b;c++)e=h(d,a,f,c),q.push(e),m.push(e[0]),p.push(e[1]),d.push([a[c],0>t?f[c]:f[c][t]]);e=h(d,a,f,c);q.push(e);m.push(e[0]);p.push(e[1]);return{values:q,xData:m,yData:p}}}});""});t(h,"indicators/zigzag.src.js",[h["parts/Utilities.js"]],function(e){e=e.seriesType;e("zigzag","sma",{params:{lowIndex:2,highIndex:1,deviation:1}},{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag",getValues:function(e,h){var g=h.lowIndex,f=h.highIndex,d=h.deviation/100;h=
1+d;var c=1-d;d=e.xData;var a=e.yData;e=a?a.length:0;var b=[],l=[],r=[],n,q,m=!1,p=!1;if(!(!d||1>=d.length||e&&(void 0===a[0][g]||void 0===a[0][f]))){var t=a[0][g];var w=a[0][f];for(n=1;n<e;n++){if(a[n][g]<=w*c){b.push([d[0],w]);var v=[d[n],a[n][g]];m=q=!0}else a[n][f]>=t*h&&(b.push([d[0],t]),v=[d[n],a[n][f]],q=!1,m=!0);if(m){l.push(b[0][0]);r.push(b[0][1]);var A=n++;n=e}}for(n=A;n<e;n++)q?(a[n][g]<=v[1]&&(v=[d[n],a[n][g]]),a[n][f]>=v[1]*h&&(p=f)):(a[n][f]>=v[1]&&(v=[d[n],a[n][f]]),a[n][g]<=v[1]*
c&&(p=g)),!1!==p&&(b.push(v),l.push(v[0]),r.push(v[1]),v=[d[n],a[n][p]],q=!q,p=!1);g=b.length;0!==g&&b[g-1][0]<d[e-1]&&(b.push(v),l.push(v[0]),r.push(v[1]));return{values:b,xData:l,yData:r}}}});""});t(h,"indicators/regressions.src.js",[h["parts/Utilities.js"]],function(e){var g=e.isArray;e=e.seriesType;e("linearRegression","sma",{params:{xAxisUnit:void 0},tooltip:{valueDecimals:4}},{nameBase:"Linear Regression Indicator",getRegressionLineParameters:function(e,k){var f=this.options.params.index,d=
function(a,b){return g(a)?a[b]:a},c=e.reduce(function(a,b){return b+a},0),a=k.reduce(function(a,b){return d(b,f)+a},0);c/=e.length;a/=k.length;var b=0,h=0,l;for(l=0;l<e.length;l++){var n=e[l]-c;var q=d(k[l],f)-a;b+=n*q;h+=Math.pow(n,2)}e=h?b/h:0;return{slope:e,intercept:a-e*c}},getEndPointY:function(e,g){return e.slope*g+e.intercept},transformXData:function(e,g){var f=e[0];return e.map(function(d){return(d-f)/g})},findClosestDistance:function(e){var g,f;for(f=1;f<e.length-1;f++){var d=e[f]-e[f-1];
0<d&&("undefined"===typeof g||d<g)&&(g=d)}return g},getValues:function(e,g){var f=e.xData;e=e.yData;g=g.period;var d,c={xData:[],yData:[],values:[]},a=this.options.params.xAxisUnit||this.findClosestDistance(f);for(d=g-1;d<=f.length-1;d++){var b=d-g+1;var h=d+1;var k=f[d];var l=f.slice(b,h);b=e.slice(b,h);h=this.transformXData(l,a);l=this.getRegressionLineParameters(h,b);b=this.getEndPointY(l,h[h.length-1]);c.values.push({regressionLineParameters:l,x:k,y:b});c.xData.push(k);c.yData.push(b)}return c}});
e("linearRegressionSlope","linearRegression",{},{nameBase:"Linear Regression Slope Indicator",getEndPointY:function(e){return e.slope}});e("linearRegressionIntercept","linearRegression",{},{nameBase:"Linear Regression Intercept Indicator",getEndPointY:function(e){return e.intercept}});e("linearRegressionAngle","linearRegression",{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}},{nameBase:"Linear Regression Angle Indicator",slopeToAngle:function(e){return 180/
Math.PI*Math.atan(e)},getEndPointY:function(e){return this.slopeToAngle(e.slope)}});""});t(h,"indicators/acceleration-bands.src.js",[h["parts/Globals.js"],h["parts/Utilities.js"],h["mixins/multipe-lines.js"]],function(e,g,h){var k=g.correctFloat,f=g.merge;g=g.seriesType;var d=e.seriesTypes.sma;g("abands","sma",{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},f(h,{pointArrayMap:["top","middle",
"bottom"],pointValKey:"middle",nameBase:"Acceleration Bands",nameComponents:["period","factor"],linesApiNames:["topLine","bottomLine"],getValues:function(c,a){var b=a.period,f=a.factor;a=a.index;var e=c.xData,g=(c=c.yData)?c.length:0,h=[],l=[],p=[],t=[],w=[],v;if(!(g<b)){for(v=0;v<=g;v++){if(v<g){var A=c[v][2];var C=c[v][1];var z=f;A=k(C-A)/(k(C+A)/2)*1E3*z;h.push(c[v][1]*k(1+2*A));l.push(c[v][2]*k(1-2*A))}if(v>=b){A=e.slice(v-b,v);var x=c.slice(v-b,v);z=d.prototype.getValues.call(this,{xData:A,yData:h.slice(v-
b,v)},{period:b});C=d.prototype.getValues.call(this,{xData:A,yData:l.slice(v-b,v)},{period:b});x=d.prototype.getValues.call(this,{xData:A,yData:x},{period:b,index:a});A=x.xData[0];z=z.yData[0];C=C.yData[0];x=x.yData[0];p.push([A,z,x,C]);t.push(A);w.push([z,x,C])}}return{values:p,xData:t,yData:w}}}}));""});t(h,"indicators/trendline.src.js",[h["parts/Utilities.js"]],function(e){var g=e.isArray;e=e.seriesType;e("trendline","sma",{params:{index:3}},{nameBase:"Trendline",nameComponents:!1,getValues:function(e,
h){var f=e.xData,d=e.yData;e=[];var c=[],a=[],b=0,k=0,l=0,n=0,q=f.length,m=h.index;for(h=0;h<q;h++){var p=f[h];var t=g(d[h])?d[h][m]:d[h];b+=p;k+=t;l+=p*t;n+=p*p}d=(q*l-b*k)/(q*n-b*b);isNaN(d)&&(d=0);b=(k-d*b)/q;for(h=0;h<q;h++)p=f[h],t=d*p+b,e[h]=[p,t],c[h]=p,a[h]=t;return{xData:c,yData:a,values:e}}});""});t(h,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map