/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.LegacyTransaction;
import org.web3j.crypto.transaction.type.Transaction1559;
import org.web3j.utils.Base64String;
import org.web3j.utils.Restriction;

public class RawPrivateTransaction
extends RawTransaction {
    private final Base64String privateFrom;
    private final List<Base64String> privateFor;
    private final Base64String privacyGroupId;
    private final Restriction restriction;

    protected RawPrivateTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        super((ITransaction)new LegacyTransaction(nonce, gasPrice, gasLimit, to, BigInteger.ZERO, data));
        this.privateFrom = privateFrom;
        this.privateFor = privateFor;
        this.privacyGroupId = privacyGroupId;
        this.restriction = restriction;
    }

    protected RawPrivateTransaction(ITransaction transaction, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        super(transaction);
        this.privateFrom = privateFrom;
        this.privateFor = privateFor;
        this.privacyGroupId = privacyGroupId;
        this.restriction = restriction;
    }

    protected RawPrivateTransaction(RawTransaction rawTransaction, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        this(rawTransaction, privateFrom, null, privacyGroupId, restriction);
    }

    protected RawPrivateTransaction(RawTransaction rawTransaction, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        this(rawTransaction, privateFrom, privateFor, null, restriction);
    }

    private RawPrivateTransaction(RawTransaction rawTransaction, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        this(rawTransaction.getTransaction(), privateFrom, privateFor, privacyGroupId, restriction);
    }

    public static RawPrivateTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String init, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        return new RawPrivateTransaction((ITransaction)LegacyTransaction.createContractTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (BigInteger)BigInteger.ZERO, (String)init), privateFrom, privateFor, null, restriction);
    }

    public static RawPrivateTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String init, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction((ITransaction)LegacyTransaction.createContractTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (BigInteger)BigInteger.ZERO, (String)init), privateFrom, null, privacyGroupId, restriction);
    }

    public static RawPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        return new RawPrivateTransaction((ITransaction)LegacyTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (String)data), privateFrom, privateFor, null, restriction);
    }

    public static RawPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction((ITransaction)LegacyTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (String)data), privateFrom, null, privacyGroupId, restriction);
    }

    public static RawPrivateTransaction createTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        return new RawPrivateTransaction((ITransaction)Transaction1559.createTransaction((long)chainId, (BigInteger)nonce, (BigInteger)gasLimit, (String)to, (BigInteger)BigInteger.ZERO, (String)data, (BigInteger)maxPriorityFeePerGas, (BigInteger)maxFeePerGas), privateFrom, privateFor, null, restriction);
    }

    public static RawPrivateTransaction createTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction((ITransaction)Transaction1559.createTransaction((long)chainId, (BigInteger)nonce, (BigInteger)gasLimit, (String)to, (BigInteger)BigInteger.ZERO, (String)data, (BigInteger)maxPriorityFeePerGas, (BigInteger)maxFeePerGas), privateFrom, null, privacyGroupId, restriction);
    }

    public Base64String getPrivateFrom() {
        return this.privateFrom;
    }

    public Optional<List<Base64String>> getPrivateFor() {
        return Optional.ofNullable(this.privateFor);
    }

    public Optional<Base64String> getPrivacyGroupId() {
        return Optional.ofNullable(this.privacyGroupId);
    }

    public Restriction getRestriction() {
        return this.restriction;
    }
}

