/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.protocol.eea.crypto.PrivateTransactionEncoder;
import org.web3j.protocol.eea.crypto.RawPrivateTransaction;
import org.web3j.service.TxSignService;

public class PrivateTxSignServiceImpl
implements TxSignService {
    private final Credentials credentials;

    public PrivateTxSignServiceImpl(Credentials credentials) {
        this.credentials = credentials;
    }

    public byte[] sign(RawTransaction rawTransaction, long chainId) {
        if (!(rawTransaction instanceof RawPrivateTransaction)) {
            throw new RuntimeException("Can only sign RawPrivateTransaction");
        }
        byte[] signedMessage = chainId > -1L ? PrivateTransactionEncoder.signMessage((RawPrivateTransaction)rawTransaction, chainId, this.credentials) : PrivateTransactionEncoder.signMessage((RawPrivateTransaction)rawTransaction, this.credentials);
        return signedMessage;
    }

    public String getAddress() {
        return this.credentials.getAddress();
    }
}

