/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.eea.crypto.RawPrivateTransaction;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Base64String;

public class PrivateTransactionEncoder {
    public static byte[] signMessage(RawPrivateTransaction rawTransaction, Credentials credentials) {
        byte[] encodedTransaction = PrivateTransactionEncoder.encode(rawTransaction);
        Sign.SignatureData signatureData = Sign.signMessage((byte[])encodedTransaction, (ECKeyPair)credentials.getEcKeyPair());
        return PrivateTransactionEncoder.encode(rawTransaction, signatureData);
    }

    public static byte[] signMessage(RawPrivateTransaction rawTransaction, long chainId, Credentials credentials) {
        byte[] encodedTransaction = PrivateTransactionEncoder.encode(rawTransaction, chainId);
        Sign.SignatureData signatureData = Sign.signMessage((byte[])encodedTransaction, (ECKeyPair)credentials.getEcKeyPair());
        Sign.SignatureData eip155SignatureData = TransactionEncoder.createEip155SignatureData((Sign.SignatureData)signatureData, (long)chainId);
        return PrivateTransactionEncoder.encode(rawTransaction, eip155SignatureData);
    }

    public static byte[] encode(RawPrivateTransaction rawTransaction) {
        return PrivateTransactionEncoder.encode(rawTransaction, null);
    }

    public static byte[] encode(RawPrivateTransaction rawTransaction, long chainId) {
        Sign.SignatureData signatureData = new Sign.SignatureData(PrivateTransactionEncoder.longToBytes(chainId), new byte[0], new byte[0]);
        return PrivateTransactionEncoder.encode(rawTransaction, signatureData);
    }

    private static byte[] encode(RawPrivateTransaction rawTransaction, Sign.SignatureData signatureData) {
        List<RlpType> values = PrivateTransactionEncoder.asRlpValues(rawTransaction, signatureData);
        RlpList rlpList = new RlpList(values);
        return RlpEncoder.encode((RlpType)rlpList);
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static List<RlpType> asRlpValues(RawPrivateTransaction privateTransaction, Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>(TransactionEncoder.asRlpValues((RawTransaction)privateTransaction, (Sign.SignatureData)signatureData));
        result.add((RlpType)privateTransaction.getPrivateFrom().asRlp());
        privateTransaction.getPrivateFor().ifPresent(privateFor -> result.add((RlpType)Base64String.unwrapListToRlp(privateFor)));
        privateTransaction.getPrivacyGroupId().map(Base64String::asRlp).ifPresent(result::add);
        result.add((RlpType)RlpString.create((String)privateTransaction.getRestriction().getRestriction()));
        return result;
    }
}

