/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.crypto.TransactionDecoder;
import org.web3j.protocol.eea.crypto.RawPrivateTransaction;
import org.web3j.protocol.eea.crypto.SignedRawPrivateTransaction;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Base64String;
import org.web3j.utils.Numeric;
import org.web3j.utils.Restriction;

public class PrivateTransactionDecoder {
    public static RawPrivateTransaction decode(String hexTransaction) {
        byte[] transaction = Numeric.hexStringToByteArray((String)hexTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        RlpList temp = (RlpList)rlpList.getValues().get(0);
        List values = temp.getValues();
        RawTransaction rawTransaction = TransactionDecoder.decode((String)hexTransaction);
        if (values.size() == 9) {
            Base64String privateFrom = PrivateTransactionDecoder.extractBase64((RlpType)values.get(6));
            Restriction restriction = PrivateTransactionDecoder.extractRestriction((RlpType)values.get(8));
            if (values.get(7) instanceof RlpList) {
                return new RawPrivateTransaction(rawTransaction, privateFrom, PrivateTransactionDecoder.extractBase64List((RlpType)values.get(7)), restriction);
            }
            return new RawPrivateTransaction(rawTransaction, privateFrom, PrivateTransactionDecoder.extractBase64((RlpType)values.get(7)), restriction);
        }
        Base64String privateFrom = PrivateTransactionDecoder.extractBase64((RlpType)values.get(9));
        Restriction restriction = PrivateTransactionDecoder.extractRestriction((RlpType)values.get(11));
        if (values.get(10) instanceof RlpList) {
            return new SignedRawPrivateTransaction((SignedRawTransaction)rawTransaction, privateFrom, PrivateTransactionDecoder.extractBase64List((RlpType)values.get(10)), restriction);
        }
        return new SignedRawPrivateTransaction((SignedRawTransaction)rawTransaction, privateFrom, PrivateTransactionDecoder.extractBase64((RlpType)values.get(10)), restriction);
    }

    private static Restriction extractRestriction(RlpType value) {
        return Restriction.fromString(new String(((RlpString)value).getBytes(), StandardCharsets.UTF_8));
    }

    private static Base64String extractBase64(RlpType value) {
        return Base64String.wrap(((RlpString)value).getBytes());
    }

    private static List<Base64String> extractBase64List(RlpType values) {
        return ((RlpList)values).getValues().stream().map(PrivateTransactionDecoder::extractBase64).collect(Collectors.toList());
    }
}

