/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.protocol.eea.crypto.transaction.type.IPrivateTransaction;
import org.web3j.protocol.eea.crypto.transaction.type.LegacyPrivateTransaction;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Base64String;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;
import org.web3j.utils.Restriction;

public class PrivateTransaction1559
extends LegacyPrivateTransaction
implements IPrivateTransaction {
    private final TransactionType transactionType = TransactionType.EIP1559;
    private final long chainId;
    private final BigInteger maxPriorityFeePerGas;
    private final BigInteger maxFeePerGas;

    public PrivateTransaction1559(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        super(nonce, null, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction);
        this.chainId = chainId;
        this.maxPriorityFeePerGas = maxPriorityFeePerGas;
        this.maxFeePerGas = maxFeePerGas;
    }

    public static PrivateTransaction1559 createContractTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return new PrivateTransaction1559(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, null, data, privateFrom, privateFor, privacyGroupId, restriction);
    }

    public static PrivateTransaction1559 createContractTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String data, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return PrivateTransaction1559.createContractTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, data, privateFrom, null, privacyGroupId, restriction);
    }

    public static PrivateTransaction1559 createTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return new PrivateTransaction1559(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction);
    }

    public static PrivateTransaction1559 createTransaction(long chainId, BigInteger nonce, BigInteger gasLimit, String to, String data, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return PrivateTransaction1559.createTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, null, privacyGroupId, restriction);
    }

    public static PrivateTransaction1559 createTransaction(long chainId, BigInteger nonce, BigInteger gasLimit, String to, String data, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        return new PrivateTransaction1559(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, privateFor, null, restriction);
    }

    @Override
    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((long)this.getChainId()));
        result.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)this.getMaxPriorityFeePerGas()));
        result.add((RlpType)RlpString.create((BigInteger)this.getMaxFeePerGas()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        String to = this.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        if (signatureData != null) {
            result.add((RlpType)RlpString.create((long)Sign.getRecId((Sign.SignatureData)signatureData, (long)this.getChainId())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        result.add((RlpType)this.getPrivateFrom().asRlp());
        this.getPrivateFor().ifPresent(privateFor -> result.add((RlpType)Base64String.unwrapListToRlp(privateFor)));
        this.getPrivacyGroupId().map(Base64String::asRlp).ifPresent(result::add);
        result.add((RlpType)RlpString.create((String)this.getRestriction().getRestriction()));
        return result;
    }

    @Override
    public BigInteger getGasPrice() {
        throw new UnsupportedOperationException("not available for 1559 transaction");
    }

    public long getChainId() {
        return this.chainId;
    }

    public BigInteger getMaxPriorityFeePerGas() {
        return this.maxPriorityFeePerGas;
    }

    public BigInteger getMaxFeePerGas() {
        return this.maxFeePerGas;
    }

    @Override
    public TransactionType getType() {
        return this.transactionType;
    }
}

