/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.protocol.eea.crypto.transaction.type.IPrivateTransaction;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Base64String;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;
import org.web3j.utils.Restriction;

public class LegacyPrivateTransaction
implements IPrivateTransaction {
    private final TransactionType transactionType = TransactionType.LEGACY;
    private final BigInteger nonce;
    private final BigInteger gasPrice;
    private final BigInteger gasLimit;
    private final String to;
    private final String data;
    private final Base64String privateFrom;
    private final List<Base64String> privateFor;
    private final Base64String privacyGroupId;
    private final Restriction restriction;

    public LegacyPrivateTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.to = to;
        this.data = data;
        this.privateFrom = privateFrom;
        this.privateFor = privateFor;
        this.privacyGroupId = privacyGroupId;
        this.restriction = restriction;
    }

    public static LegacyPrivateTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return new LegacyPrivateTransaction(nonce, gasPrice, gasLimit, null, data, privateFrom, privateFor, privacyGroupId, restriction);
    }

    public static LegacyPrivateTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String data, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return LegacyPrivateTransaction.createContractTransaction(nonce, gasPrice, gasLimit, data, privateFrom, null, privacyGroupId, restriction);
    }

    public static LegacyPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return new LegacyPrivateTransaction(nonce, gasPrice, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction);
    }

    public static LegacyPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return LegacyPrivateTransaction.createTransaction(nonce, gasPrice, gasLimit, to, "", privateFrom, privateFor, privacyGroupId, restriction);
    }

    public static LegacyPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return LegacyPrivateTransaction.createTransaction(nonce, gasPrice, gasLimit, to, data, privateFrom, null, privacyGroupId, restriction);
    }

    public static LegacyPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        return LegacyPrivateTransaction.createTransaction(nonce, gasPrice, gasLimit, to, data, privateFrom, privateFor, null, restriction);
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasPrice()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        String to = this.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        if (signatureData != null) {
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getV())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        result.add((RlpType)this.getPrivateFrom().asRlp());
        this.getPrivateFor().ifPresent(privateFor -> result.add((RlpType)Base64String.unwrapListToRlp(privateFor)));
        this.getPrivacyGroupId().map(Base64String::asRlp).ifPresent(result::add);
        result.add((RlpType)RlpString.create((String)this.getRestriction().getRestriction()));
        return result;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public String getTo() {
        return this.to;
    }

    public BigInteger getValue() {
        return BigInteger.ZERO;
    }

    public String getData() {
        return this.data;
    }

    public TransactionType getType() {
        return this.transactionType;
    }

    @Override
    public Base64String getPrivateFrom() {
        return this.privateFrom;
    }

    @Override
    public Optional<List<Base64String>> getPrivateFor() {
        return Optional.ofNullable(this.privateFor);
    }

    @Override
    public Optional<Base64String> getPrivacyGroupId() {
        return Optional.ofNullable(this.privacyGroupId);
    }

    @Override
    public Restriction getRestriction() {
        return this.restriction;
    }
}

