/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.SignatureDataOperations;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.protocol.eea.crypto.PrivateTransactionEncoder;
import org.web3j.protocol.eea.crypto.RawPrivateTransaction;
import org.web3j.utils.Base64String;
import org.web3j.utils.Restriction;

public class SignedRawPrivateTransaction
extends RawPrivateTransaction
implements SignatureDataOperations {
    private final Sign.SignatureData signatureData;

    public SignedRawPrivateTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Sign.SignatureData signatureData, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        super(nonce, gasPrice, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction);
        this.signatureData = signatureData;
    }

    public SignedRawPrivateTransaction(SignedRawTransaction signedRawTransaction, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        this(signedRawTransaction.getNonce(), signedRawTransaction.getGasPrice(), signedRawTransaction.getGasLimit(), signedRawTransaction.getTo(), signedRawTransaction.getData(), signedRawTransaction.getSignatureData(), privateFrom, privateFor, null, restriction);
    }

    public SignedRawPrivateTransaction(SignedRawTransaction signedRawTransaction, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        this(signedRawTransaction.getNonce(), signedRawTransaction.getGasPrice(), signedRawTransaction.getGasLimit(), signedRawTransaction.getTo(), signedRawTransaction.getData(), signedRawTransaction.getSignatureData(), privateFrom, null, privacyGroupId, restriction);
    }

    public SignedRawPrivateTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Sign.SignatureData signatureData, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        super(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction);
        this.signatureData = signatureData;
    }

    public Sign.SignatureData getSignatureData() {
        return this.signatureData;
    }

    public byte[] getEncodedTransaction(Long chainId) {
        if (null == chainId) {
            return PrivateTransactionEncoder.encode(this);
        }
        return PrivateTransactionEncoder.encode((RawPrivateTransaction)this, chainId);
    }
}

