/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.protocol.eea.crypto.transaction.type.IPrivateTransaction;
import org.web3j.protocol.eea.crypto.transaction.type.LegacyPrivateTransaction;
import org.web3j.protocol.eea.crypto.transaction.type.PrivateTransaction1559;
import org.web3j.utils.Base64String;
import org.web3j.utils.Restriction;

public class RawPrivateTransaction
extends RawTransaction {
    private final IPrivateTransaction privateTransaction;

    protected RawPrivateTransaction(IPrivateTransaction privateTransaction) {
        super((ITransaction)privateTransaction);
        this.privateTransaction = privateTransaction;
    }

    protected RawPrivateTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        this(new LegacyPrivateTransaction(nonce, gasPrice, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction));
    }

    protected RawPrivateTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        this(new PrivateTransaction1559(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction));
    }

    public static RawPrivateTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction(LegacyPrivateTransaction.createContractTransaction(nonce, gasPrice, gasLimit, data, privateFrom, privateFor, privacyGroupId, restriction));
    }

    public static RawPrivateTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String data, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction(LegacyPrivateTransaction.createContractTransaction(nonce, gasPrice, gasLimit, data, privateFrom, privacyGroupId, restriction));
    }

    public static RawPrivateTransaction createContractTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction(PrivateTransaction1559.createContractTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, data, privateFrom, privateFor, privacyGroupId, restriction));
    }

    public static RawPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction(LegacyPrivateTransaction.createTransaction(nonce, gasPrice, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction));
    }

    public static RawPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction(LegacyPrivateTransaction.createTransaction(nonce, gasPrice, gasLimit, to, data, privateFrom, privacyGroupId, restriction));
    }

    public static RawPrivateTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        return new RawPrivateTransaction(LegacyPrivateTransaction.createTransaction(nonce, gasPrice, gasLimit, to, data, privateFrom, privateFor, restriction));
    }

    public static RawPrivateTransaction createTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction(PrivateTransaction1559.createTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, privateFor, privacyGroupId, restriction));
    }

    public static RawPrivateTransaction createTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Base64String privateFrom, Base64String privacyGroupId, Restriction restriction) {
        return new RawPrivateTransaction(PrivateTransaction1559.createTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, null, privacyGroupId, restriction));
    }

    public static RawPrivateTransaction createTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, Base64String privateFrom, List<Base64String> privateFor, Restriction restriction) {
        return new RawPrivateTransaction(PrivateTransaction1559.createTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, privateFor, null, restriction));
    }

    public Base64String getPrivateFrom() {
        return this.privateTransaction.getPrivateFrom();
    }

    public Optional<List<Base64String>> getPrivateFor() {
        return this.privateTransaction.getPrivateFor();
    }

    public Optional<Base64String> getPrivacyGroupId() {
        return this.privateTransaction.getPrivacyGroupId();
    }

    public Restriction getRestriction() {
        return this.privateTransaction.getRestriction();
    }

    public IPrivateTransaction getPrivateTransaction() {
        return this.privateTransaction;
    }
}

