/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.protocol.eea.crypto.PrivateTransactionEncoder;
import org.web3j.protocol.eea.crypto.RawPrivateTransaction;
import org.web3j.service.TxSignService;

public class PrivateTxSignServiceImpl
implements TxSignService {
    private final Credentials credentials;

    public PrivateTxSignServiceImpl(Credentials credentials) {
        this.credentials = credentials;
    }

    public byte[] sign(RawTransaction privateTransaction, long chainId) {
        if (!(privateTransaction instanceof RawPrivateTransaction)) {
            throw new RuntimeException("Can only sign LegacyPrivateTransaction");
        }
        byte[] signedMessage = chainId > -1L ? PrivateTransactionEncoder.signMessage((RawPrivateTransaction)privateTransaction, chainId, this.credentials) : PrivateTransactionEncoder.signMessage((RawPrivateTransaction)privateTransaction, this.credentials);
        return signedMessage;
    }

    public String getAddress() {
        return this.credentials.getAddress();
    }
}

