/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import java.nio.ByteBuffer;
import java.util.List;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.eea.crypto.RawPrivateTransaction;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpType;

public class PrivateTransactionEncoder {
    public static byte[] signMessage(RawPrivateTransaction privateTransaction, Credentials credentials) {
        byte[] encodedTransaction = PrivateTransactionEncoder.encode(privateTransaction);
        Sign.SignatureData signatureData = Sign.signMessage((byte[])encodedTransaction, (ECKeyPair)credentials.getEcKeyPair());
        return PrivateTransactionEncoder.encode(privateTransaction, signatureData);
    }

    public static byte[] signMessage(RawPrivateTransaction rawTransaction, long chainId, Credentials credentials) {
        byte[] encodedTransaction = PrivateTransactionEncoder.encode(rawTransaction, chainId);
        Sign.SignatureData signatureData = Sign.signMessage((byte[])encodedTransaction, (ECKeyPair)credentials.getEcKeyPair());
        Sign.SignatureData eip155SignatureData = TransactionEncoder.createEip155SignatureData((Sign.SignatureData)signatureData, (long)chainId);
        return PrivateTransactionEncoder.encode(rawTransaction, eip155SignatureData);
    }

    public static byte[] encode(RawPrivateTransaction rawTransaction) {
        return PrivateTransactionEncoder.encode(rawTransaction, null);
    }

    public static byte[] encode(RawPrivateTransaction rawTransaction, long chainId) {
        Sign.SignatureData signatureData = new Sign.SignatureData(PrivateTransactionEncoder.longToBytes(chainId), new byte[0], new byte[0]);
        return PrivateTransactionEncoder.encode(rawTransaction, signatureData);
    }

    private static byte[] encode(RawPrivateTransaction privateTransaction, Sign.SignatureData signatureData) {
        List values = privateTransaction.getPrivateTransaction().asRlpValues(signatureData);
        RlpList rlpList = new RlpList(values);
        byte[] encoded = RlpEncoder.encode((RlpType)rlpList);
        if (privateTransaction.getType().isEip1559()) {
            return ByteBuffer.allocate(encoded.length + 1).put(privateTransaction.getType().getRlpType()).put(encoded).array();
        }
        return encoded;
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }
}

