/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.eea.crypto;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.crypto.TransactionDecoder;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.protocol.eea.crypto.RawPrivateTransaction;
import org.web3j.protocol.eea.crypto.SignedRawPrivateTransaction;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Base64String;
import org.web3j.utils.Numeric;
import org.web3j.utils.Restriction;

public class PrivateTransactionDecoder {
    public static RawPrivateTransaction decode(String hexTransaction) {
        byte[] transaction = Numeric.hexStringToByteArray((String)hexTransaction);
        TransactionType transactionType = PrivateTransactionDecoder.getPrivateTransactionType(transaction);
        if (transactionType == TransactionType.EIP1559) {
            return PrivateTransactionDecoder.decodePrivateTransaction1559(transaction);
        }
        return PrivateTransactionDecoder.decodeLegacyPrivateTransaction(transaction);
    }

    private static TransactionType getPrivateTransactionType(byte[] transaction) {
        byte firstByte = transaction[0];
        if (firstByte == TransactionType.EIP1559.getRlpType()) {
            return TransactionType.EIP1559;
        }
        return TransactionType.LEGACY;
    }

    private static RawPrivateTransaction decodePrivateTransaction1559(byte[] transaction) {
        byte[] encodedTx = Arrays.copyOfRange(transaction, 1, transaction.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedTx);
        RlpList temp = (RlpList)rlpList.getValues().get(0);
        List values = temp.getValues();
        long chainId = ((RlpString)temp.getValues().get(0)).asPositiveBigInteger().longValue();
        BigInteger nonce = ((RlpString)temp.getValues().get(1)).asPositiveBigInteger();
        BigInteger maxPriorityFeePerGas = ((RlpString)temp.getValues().get(2)).asPositiveBigInteger();
        BigInteger maxFeePerGas = ((RlpString)temp.getValues().get(3)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)temp.getValues().get(4)).asPositiveBigInteger();
        String to = ((RlpString)temp.getValues().get(5)).asString();
        String data = ((RlpString)temp.getValues().get(7)).asString();
        if (values.size() == 11) {
            Base64String privateFrom = PrivateTransactionDecoder.extractBase64((RlpType)values.get(8));
            Restriction restriction = PrivateTransactionDecoder.extractRestriction((RlpType)values.get(10));
            if (values.get(9) instanceof RlpList) {
                List<Base64String> privateForList = PrivateTransactionDecoder.extractBase64List((RlpType)values.get(9));
                return RawPrivateTransaction.createTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, privateForList, null, restriction);
            }
            Base64String privacyGroupId = PrivateTransactionDecoder.extractBase64((RlpType)values.get(9));
            return RawPrivateTransaction.createTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, privateFrom, null, privacyGroupId, restriction);
        }
        Base64String privateFrom = PrivateTransactionDecoder.extractBase64((RlpType)values.get(11));
        Restriction restriction = PrivateTransactionDecoder.extractRestriction((RlpType)values.get(13));
        byte[] v = Sign.getVFromRecId((int)Numeric.toBigInt((byte[])((RlpString)values.get(8)).getBytes()).intValue());
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.get(9)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.get(10)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        if (values.get(12) instanceof RlpList) {
            List<Base64String> privateForList = PrivateTransactionDecoder.extractBase64List((RlpType)values.get(12));
            return new SignedRawPrivateTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, signatureData, privateFrom, privateForList, null, restriction);
        }
        Base64String privacyGroupId = PrivateTransactionDecoder.extractBase64((RlpType)values.get(12));
        return new SignedRawPrivateTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, signatureData, privateFrom, null, privacyGroupId, restriction);
    }

    private static RawPrivateTransaction decodeLegacyPrivateTransaction(byte[] transaction) {
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        RlpList temp = (RlpList)rlpList.getValues().get(0);
        List values = temp.getValues();
        RawTransaction rawTransaction = TransactionDecoder.decode((String)Numeric.toHexString((byte[])transaction));
        if (values.size() == 9) {
            Base64String privateFrom = PrivateTransactionDecoder.extractBase64((RlpType)values.get(6));
            Restriction restriction = PrivateTransactionDecoder.extractRestriction((RlpType)values.get(8));
            if (values.get(7) instanceof RlpList) {
                List<Base64String> privateForList = PrivateTransactionDecoder.extractBase64List((RlpType)values.get(7));
                return RawPrivateTransaction.createTransaction(rawTransaction.getNonce(), rawTransaction.getGasPrice(), rawTransaction.getGasLimit(), rawTransaction.getTo(), rawTransaction.getData(), privateFrom, privateForList, null, restriction);
            }
            Base64String privacyGroupId = PrivateTransactionDecoder.extractBase64((RlpType)values.get(7));
            return RawPrivateTransaction.createTransaction(rawTransaction.getNonce(), rawTransaction.getGasPrice(), rawTransaction.getGasLimit(), rawTransaction.getTo(), rawTransaction.getData(), privateFrom, null, privacyGroupId, restriction);
        }
        Base64String privateFrom = PrivateTransactionDecoder.extractBase64((RlpType)values.get(9));
        Restriction restriction = PrivateTransactionDecoder.extractRestriction((RlpType)values.get(11));
        if (values.get(10) instanceof RlpList) {
            return new SignedRawPrivateTransaction((SignedRawTransaction)rawTransaction, privateFrom, PrivateTransactionDecoder.extractBase64List((RlpType)values.get(10)), restriction);
        }
        return new SignedRawPrivateTransaction((SignedRawTransaction)rawTransaction, privateFrom, PrivateTransactionDecoder.extractBase64((RlpType)values.get(10)), restriction);
    }

    private static Restriction extractRestriction(RlpType value) {
        return Restriction.fromString(new String(((RlpString)value).getBytes(), StandardCharsets.UTF_8));
    }

    private static Base64String extractBase64(RlpType value) {
        return Base64String.wrap(((RlpString)value).getBytes());
    }

    private static List<Base64String> extractBase64List(RlpType values) {
        return ((RlpList)values).getValues().stream().map(PrivateTransactionDecoder::extractBase64).collect(Collectors.toList());
    }
}

