/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.math.BigInteger;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Uint;
import org.web3j.utils.Numeric;

public class Address
implements Type<String> {
    public static final String TYPE_NAME = "address";
    public static final int DEFAULT_LENGTH = 160;
    public static final Address DEFAULT = new Address(BigInteger.ZERO);
    private final Uint value;

    public Address(Uint value) {
        this.value = value;
    }

    public Address(BigInteger value) {
        this(160, value);
    }

    public Address(int bitSize, BigInteger value) {
        this(new Uint(bitSize, value));
    }

    public Address(String hexValue) {
        this(160, hexValue);
    }

    public Address(int bitSize, String hexValue) {
        this(bitSize, Numeric.toBigInt(hexValue));
    }

    public Uint toUint() {
        return this.value;
    }

    @Override
    public String getTypeAsString() {
        return TYPE_NAME;
    }

    public String toString() {
        return Numeric.toHexStringWithPrefixZeroPadded(this.value.getValue(), this.value.getBitSize() >> 2);
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.value != null ? this.value.value.equals(address.value.value) : address.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

