/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.SecureRandomUtils;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class Keys {
    static final int PRIVATE_KEY_SIZE = 32;
    static final int PUBLIC_KEY_SIZE = 64;
    public static final int ADDRESS_SIZE = 160;
    public static final int ADDRESS_LENGTH_IN_HEX = 40;
    static final int PUBLIC_KEY_LENGTH_IN_HEX = 128;
    public static final int PRIVATE_KEY_LENGTH_IN_HEX = 64;
    private static final BouncyCastleProvider BC_PROVIDER = new BouncyCastleProvider();

    private Keys() {
    }

    static KeyPair createSecp256k1KeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return Keys.createSecp256k1KeyPair(SecureRandomUtils.secureRandom());
    }

    static KeyPair createSecp256k1KeyPair(SecureRandom random) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", (Provider)BC_PROVIDER);
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256k1");
        if (random != null) {
            keyPairGenerator.initialize(ecGenParameterSpec, random);
        } else {
            keyPairGenerator.initialize(ecGenParameterSpec);
        }
        return keyPairGenerator.generateKeyPair();
    }

    public static ECKeyPair createEcKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return Keys.createEcKeyPair(SecureRandomUtils.secureRandom());
    }

    public static ECKeyPair createEcKeyPair(SecureRandom random) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = Keys.createSecp256k1KeyPair(random);
        return ECKeyPair.create(keyPair);
    }

    public static String getAddress(ECKeyPair ecKeyPair) {
        return Keys.getAddress(ecKeyPair.getPublicKey());
    }

    public static String getAddress(BigInteger publicKey) {
        return Keys.getAddress(Numeric.toHexStringWithPrefixZeroPadded((BigInteger)publicKey, (int)128));
    }

    public static String getAddress(String publicKey) {
        Object publicKeyNoPrefix = Numeric.cleanHexPrefix((String)publicKey);
        if (((String)publicKeyNoPrefix).length() < 128) {
            publicKeyNoPrefix = Strings.zeros((int)(128 - ((String)publicKeyNoPrefix).length())) + (String)publicKeyNoPrefix;
        }
        String hash = Hash.sha3((String)publicKeyNoPrefix);
        return hash.substring(hash.length() - 40);
    }

    public static byte[] getAddress(byte[] publicKey) {
        byte[] hash = Hash.sha3((byte[])publicKey);
        return Arrays.copyOfRange(hash, hash.length - 20, hash.length);
    }

    public static String toChecksumAddress(String address) {
        String lowercaseAddress = Numeric.cleanHexPrefix((String)address).toLowerCase();
        String addressHash = Numeric.cleanHexPrefix((String)Hash.sha3String((String)lowercaseAddress));
        StringBuilder result = new StringBuilder(lowercaseAddress.length() + 2);
        result.append("0x");
        for (int i = 0; i < lowercaseAddress.length(); ++i) {
            if (Integer.parseInt(String.valueOf(addressHash.charAt(i)), 16) >= 8) {
                result.append(String.valueOf(lowercaseAddress.charAt(i)).toUpperCase());
                continue;
            }
            result.append(lowercaseAddress.charAt(i));
        }
        return result.toString();
    }

    public static byte[] serialize(ECKeyPair ecKeyPair) {
        byte[] privateKey = Numeric.toBytesPadded((BigInteger)ecKeyPair.getPrivateKey(), (int)32);
        byte[] publicKey = Numeric.toBytesPadded((BigInteger)ecKeyPair.getPublicKey(), (int)64);
        byte[] result = Arrays.copyOf(privateKey, 96);
        System.arraycopy(publicKey, 0, result, 32, 64);
        return result;
    }

    public static ECKeyPair deserialize(byte[] input) {
        if (input.length != 96) {
            throw new RuntimeException("Invalid input key size");
        }
        BigInteger privateKey = Numeric.toBigInt((byte[])input, (int)0, (int)32);
        BigInteger publicKey = Numeric.toBigInt((byte[])input, (int)32, (int)64);
        return new ECKeyPair(privateKey, publicKey);
    }
}

