/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.web3j.abi.TypeEncoder;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Pair;
import org.web3j.crypto.StructuredData;
import org.web3j.utils.Numeric;

public class StructuredDataEncoder {
    public static ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    public final StructuredData.EIP712Message jsonMessageObject;
    final String arrayTypeRegex = "^([a-zA-Z_$][a-zA-Z_$0-9]*)((\\[([1-9]\\d*)?\\])+)$";
    final Pattern arrayTypePattern = Pattern.compile("^([a-zA-Z_$][a-zA-Z_$0-9]*)((\\[([1-9]\\d*)?\\])+)$");
    final String bytesTypeRegex = "^bytes[0-9][0-9]?$";
    final Pattern bytesTypePattern = Pattern.compile("^bytes[0-9][0-9]?$");
    final String arrayDimensionRegex = "\\[([1-9]\\d*)?\\]";
    final Pattern arrayDimensionPattern = Pattern.compile("\\[([1-9]\\d*)?\\]");
    final String typeRegex = "^[a-zA-Z_$][a-zA-Z_$0-9]*(\\[([1-9]\\d*)*\\])*$";
    final Pattern typePattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*(\\[([1-9]\\d*)*\\])*$");
    final String identifierRegex = "^[a-zA-Z_$][a-zA-Z_$0-9]*$";
    final Pattern identifierPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");

    public StructuredDataEncoder(StructuredData.EIP712Message jsonMessageObject) {
        this.validateStructuredData(jsonMessageObject);
        this.jsonMessageObject = jsonMessageObject;
    }

    public StructuredDataEncoder(String jsonMessageInString) throws IOException, RuntimeException {
        this.jsonMessageObject = this.parseJSONMessage(jsonMessageInString);
    }

    public Set<String> getDependencies(String primaryType) {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        HashSet<String> deps = new HashSet<String>();
        if (!types.containsKey(primaryType)) {
            return deps;
        }
        ArrayList<String> remainingTypes = new ArrayList<String>();
        remainingTypes.add(primaryType);
        while (remainingTypes.size() > 0) {
            String structName = (String)remainingTypes.get(remainingTypes.size() - 1);
            remainingTypes.remove(remainingTypes.size() - 1);
            deps.add(structName);
            for (StructuredData.Entry entry : types.get(structName)) {
                String declarationFieldTypeName = entry.getType();
                String baseDeclarationTypeName = this.arrayTypePattern.matcher(declarationFieldTypeName).find() ? declarationFieldTypeName.substring(0, declarationFieldTypeName.indexOf(91)) : declarationFieldTypeName;
                if (!types.containsKey(baseDeclarationTypeName) || deps.contains(baseDeclarationTypeName)) continue;
                remainingTypes.add(baseDeclarationTypeName);
            }
        }
        return deps;
    }

    public String encodeStruct(String structName) {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        StringBuilder structRepresentation = new StringBuilder(structName + "(");
        for (StructuredData.Entry entry : types.get(structName)) {
            structRepresentation.append(String.format("%s %s,", entry.getType(), entry.getName()));
        }
        structRepresentation = new StringBuilder(structRepresentation.substring(0, structRepresentation.length() - 1));
        structRepresentation.append(")");
        return structRepresentation.toString();
    }

    public String encodeType(String primaryType) {
        Set<String> deps = this.getDependencies(primaryType);
        deps.remove(primaryType);
        ArrayList<String> depsAsList = new ArrayList<String>(deps);
        Collections.sort(depsAsList);
        depsAsList.add(0, primaryType);
        StringBuilder result = new StringBuilder();
        for (String structName : depsAsList) {
            result.append(this.encodeStruct(structName));
        }
        return result.toString();
    }

    public byte[] typeHash(String primaryType) {
        return Numeric.hexStringToByteArray((String)Hash.sha3String((String)this.encodeType(primaryType)));
    }

    public List<Integer> getArrayDimensionsFromDeclaration(String declaration) {
        Matcher arrayTypeMatcher = this.arrayTypePattern.matcher(declaration);
        arrayTypeMatcher.find();
        Matcher dimensionTypeMatcher = this.arrayDimensionPattern.matcher(declaration);
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        while (dimensionTypeMatcher.find()) {
            String currentDimension = dimensionTypeMatcher.group(1);
            if (currentDimension == null) {
                dimensions.add(Integer.parseInt("-1"));
                continue;
            }
            dimensions.add(Integer.parseInt(currentDimension));
        }
        return dimensions;
    }

    public List<Pair> getDepthsAndDimensions(Object data, int depth) {
        if (!(data instanceof List)) {
            return new ArrayList<Pair>();
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        List dataAsArray = (List)data;
        list.add(new Pair((Object)depth, (Object)dataAsArray.size()));
        for (Object subdimensionalData : dataAsArray) {
            list.addAll(this.getDepthsAndDimensions(subdimensionalData, depth + 1));
        }
        return list;
    }

    public List<Integer> getArrayDimensionsFromData(Object data) throws RuntimeException {
        List<Pair> depthsAndDimensions = this.getDepthsAndDimensions(data, 0);
        Map<Object, List<Pair>> groupedByDepth = depthsAndDimensions.stream().collect(Collectors.groupingBy(Pair::getFirst));
        HashMap depthDimensionsMap = new HashMap();
        for (Map.Entry<Object, List<Pair>> entry : groupedByDepth.entrySet()) {
            ArrayList<Integer> pureDimensions = new ArrayList<Integer>();
            for (Pair depthDimensionPair : entry.getValue()) {
                pureDimensions.add((Integer)depthDimensionPair.getSecond());
            }
            depthDimensionsMap.put((Integer)entry.getKey(), pureDimensions);
        }
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        for (Map.Entry entry : depthDimensionsMap.entrySet()) {
            TreeSet setOfDimensionsInParticularDepth = new TreeSet((Collection)entry.getValue());
            if (setOfDimensionsInParticularDepth.size() != 1) {
                throw new RuntimeException(String.format("Depth %d of array data has more than one dimensions", entry.getKey()));
            }
            dimensions.add((Integer)setOfDimensionsInParticularDepth.stream().findFirst().get());
        }
        return dimensions;
    }

    public List<Object> flattenMultidimensionalArray(final Object data) {
        if (!(data instanceof List)) {
            return new ArrayList<Object>(){
                {
                    this.add(data);
                }
            };
        }
        ArrayList<Object> flattenedArray = new ArrayList<Object>();
        for (Object arrayItem : (List)data) {
            flattenedArray.addAll(this.flattenMultidimensionalArray(arrayItem));
        }
        return flattenedArray;
    }

    private byte[] convertToEncodedItem(String baseType, Object data) {
        byte[] hashBytes;
        try {
            if (baseType.toLowerCase().startsWith("uint") || baseType.toLowerCase().startsWith("int")) {
                BigInteger value = this.convertToBigInt(data);
                if (value.signum() >= 0) {
                    hashBytes = Numeric.toBytesPadded((BigInteger)this.convertToBigInt(data), (int)32);
                } else {
                    int signPadding = -1;
                    byte[] rawValue = this.convertToBigInt(data).toByteArray();
                    hashBytes = new byte[32];
                    for (int i = 0; i < hashBytes.length; ++i) {
                        hashBytes[i] = signPadding;
                    }
                    System.arraycopy(rawValue, 0, hashBytes, 32 - rawValue.length, rawValue.length);
                }
            } else if (baseType.equals("string")) {
                hashBytes = Numeric.hexStringToByteArray((String)Hash.sha3String((String)((String)data)));
            } else if (baseType.equals("bytes")) {
                hashBytes = Hash.sha3((byte[])Numeric.hexStringToByteArray((String)((String)data)));
            } else {
                byte[] b = StructuredDataEncoder.convertArgToBytes((String)data);
                BigInteger bi = new BigInteger(1, b);
                hashBytes = Numeric.toBytesPadded((BigInteger)bi, (int)32);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            hashBytes = new byte[]{};
        }
        return hashBytes;
    }

    private List<Object> getArrayItems(StructuredData.Entry field, Object value) {
        List<Integer> expectedDimensions = this.getArrayDimensionsFromDeclaration(field.getType());
        List<Integer> dataDimensions = this.getArrayDimensionsFromData(value);
        String format = String.format("Array Data %s has dimensions %s, but expected dimensions are %s", value.toString(), dataDimensions.toString(), expectedDimensions.toString());
        if (expectedDimensions.size() != dataDimensions.size()) {
            throw new RuntimeException(format);
        }
        for (int i = 0; i < expectedDimensions.size(); ++i) {
            if (expectedDimensions.get(i) == -1 || expectedDimensions.get(i).equals(dataDimensions.get(i))) continue;
            throw new RuntimeException(format);
        }
        return this.flattenMultidimensionalArray(value);
    }

    public byte[] encodeData(String primaryType, HashMap<String, Object> data) throws RuntimeException {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        ArrayList<String> encTypes = new ArrayList<String>();
        ArrayList<Object> encValues = new ArrayList<Object>();
        encTypes.add("bytes32");
        encValues.add(this.typeHash(primaryType));
        for (StructuredData.Entry field : types.get(primaryType)) {
            byte[] hashedValue;
            Object value = data.get(field.getName());
            if (value == null) continue;
            if (field.getType().equals("string")) {
                encTypes.add("bytes32");
                hashedValue = Numeric.hexStringToByteArray((String)Hash.sha3String((String)((String)value)));
                encValues.add(hashedValue);
                continue;
            }
            if (field.getType().equals("bytes")) {
                encTypes.add("bytes32");
                encValues.add(Hash.sha3((byte[])Numeric.hexStringToByteArray((String)((String)value))));
                continue;
            }
            if (types.containsKey(field.getType())) {
                hashedValue = Hash.sha3((byte[])this.encodeData(field.getType(), (HashMap)value));
                encTypes.add("bytes32");
                encValues.add(hashedValue);
                continue;
            }
            if (this.bytesTypePattern.matcher(field.getType()).find()) {
                encTypes.add(field.getType());
                encValues.add(Numeric.hexStringToByteArray((String)((String)value)));
                continue;
            }
            if (this.arrayTypePattern.matcher(field.getType()).find()) {
                String baseTypeName = field.getType().substring(0, field.getType().indexOf(91));
                List<Object> arrayItems = this.getArrayItems(field, value);
                ByteArrayOutputStream concatenatedArrayEncodingBuffer = new ByteArrayOutputStream();
                for (Object arrayItem : arrayItems) {
                    byte[] arrayItemEncoding = types.containsKey(baseTypeName) ? Hash.sha3((byte[])this.encodeData(baseTypeName, (HashMap)arrayItem)) : this.convertToEncodedItem(baseTypeName, arrayItem);
                    concatenatedArrayEncodingBuffer.write(arrayItemEncoding, 0, arrayItemEncoding.length);
                }
                byte[] concatenatedArrayEncodings = concatenatedArrayEncodingBuffer.toByteArray();
                byte[] hashedValue2 = Hash.sha3((byte[])concatenatedArrayEncodings);
                encTypes.add("bytes32");
                encValues.add(hashedValue2);
                continue;
            }
            if (field.getType().startsWith("uint") || field.getType().startsWith("int")) {
                encTypes.add(field.getType());
                try {
                    encValues.add(this.convertToBigInt(value));
                }
                catch (NullPointerException | NumberFormatException e) {
                    encValues.add(value);
                }
                continue;
            }
            encTypes.add(field.getType());
            encValues.add(value);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < encTypes.size(); ++i) {
            Constructor<?>[] constructors;
            Class typeClazz = AbiTypes.getType((String)((String)encTypes.get(i)));
            boolean atleastOneConstructorExistsForGivenParametersType = false;
            for (Constructor<?> constructor : constructors = typeClazz.getConstructors()) {
                try {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    byte[] temp = Numeric.hexStringToByteArray((String)TypeEncoder.encode((Type)((Type)typeClazz.getDeclaredConstructor(parameterTypes).newInstance(encValues.get(i)))));
                    baos.write(temp, 0, temp.length);
                    atleastOneConstructorExistsForGivenParametersType = true;
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                }
            }
            if (atleastOneConstructorExistsForGivenParametersType) continue;
            throw new RuntimeException(String.format("Received an invalid argument for which no constructor exists for the ABI Class %s", typeClazz.getSimpleName()));
        }
        return baos.toByteArray();
    }

    private BigInteger convertToBigInt(Object value) throws NumberFormatException, NullPointerException {
        if (value.toString().startsWith("0x")) {
            return Numeric.toBigInt((String)value.toString());
        }
        return new BigInteger(value.toString());
    }

    public byte[] hashMessage(String primaryType, HashMap<String, Object> data) throws RuntimeException {
        return Hash.sha3((byte[])this.encodeData(primaryType, data));
    }

    public byte[] hashDomain() throws RuntimeException {
        HashMap data = (HashMap)mapper.convertValue((Object)this.jsonMessageObject.getDomain(), HashMap.class);
        return Hash.sha3((byte[])this.encodeData("EIP712Domain", data));
    }

    public void validateStructuredData(StructuredData.EIP712Message jsonMessageObject) throws RuntimeException {
        for (String structName : jsonMessageObject.getTypes().keySet()) {
            List<StructuredData.Entry> fields = jsonMessageObject.getTypes().get(structName);
            for (StructuredData.Entry entry : fields) {
                if (!this.identifierPattern.matcher(entry.getName()).find()) {
                    throw new RuntimeException(String.format("Invalid Identifier %s in %s", entry.getName(), structName));
                }
                if (this.typePattern.matcher(entry.getType()).find()) continue;
                throw new RuntimeException(String.format("Invalid Type %s in %s", entry.getType(), structName));
            }
        }
    }

    public StructuredData.EIP712Message parseJSONMessage(String jsonMessageInString) throws IOException, RuntimeException {
        StructuredData.EIP712Message tempJSONMessageObject = (StructuredData.EIP712Message)mapper.readValue(jsonMessageInString, StructuredData.EIP712Message.class);
        this.validateStructuredData(tempJSONMessageObject);
        return tempJSONMessageObject;
    }

    public byte[] getStructuredData() throws RuntimeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String messagePrefix = "\u0019\u0001";
        byte[] prefix = "\u0019\u0001".getBytes();
        baos.write(prefix, 0, prefix.length);
        byte[] domainHash = this.hashDomain();
        baos.write(domainHash, 0, domainHash.length);
        byte[] dataHash = this.hashMessage(this.jsonMessageObject.getPrimaryType(), (HashMap)this.jsonMessageObject.getMessage());
        baos.write(dataHash, 0, dataHash.length);
        return baos.toByteArray();
    }

    public byte[] hashStructuredData() throws RuntimeException {
        return Hash.sha3((byte[])this.getStructuredData());
    }

    private static byte[] convertArgToBytes(String inputValue) throws Exception {
        String hexValue = inputValue;
        if (!Numeric.containsHexPrefix((String)inputValue)) {
            BigInteger value;
            try {
                value = new BigInteger(inputValue);
            }
            catch (NumberFormatException e) {
                value = new BigInteger(inputValue, 16);
            }
            hexValue = Numeric.toHexStringNoPrefix((byte[])value.toByteArray());
            if (hexValue.length() > 64 && hexValue.startsWith("00")) {
                hexValue = hexValue.substring(2);
            }
        }
        return Numeric.hexStringToByteArray((String)hexValue);
    }
}

