/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen;

import com.squareup.javapoet.MethodSpec;
import com.squareup.kotlinpoet.FunSpec;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.web3j.codegen.unit.gen.java.MethodParser;
import org.web3j.codegen.unit.gen.kotlin.FunParser;
import org.web3j.protocol.Web3j;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class MethodFilter {
    public static List<Method> extractValidMethods(Class contract) {
        return Arrays.stream(contract.getDeclaredMethods()).filter(m -> !m.isSynthetic() && MethodFilter.parametersAreMatching(m) && !m.getName().toLowerCase().contains("event") && !m.getName().equals("load") && !m.getName().equals("kill") && !m.getName().equals("linkLibraries")).collect(Collectors.toList());
    }

    private static boolean parametersAreMatching(Method method) {
        if (method.getName().equals("deploy") || method.getName().equals("load")) {
            return Arrays.asList(method.getParameterTypes()).contains(Web3j.class) && Arrays.asList(method.getParameterTypes()).contains(TransactionManager.class) && Arrays.asList(method.getParameterTypes()).contains(ContractGasProvider.class);
        }
        return true;
    }

    public static List<MethodSpec> generateMethodSpecsForEachTest(Class theContract) {
        ArrayList<MethodSpec> listOfMethodSpecs = new ArrayList<MethodSpec>();
        HashMap methodNameCountMap = new HashMap();
        MethodFilter.extractValidMethods(theContract).forEach(method -> {
            String uniqueName = MethodFilter.getUniqueName(method, methodNameCountMap);
            if (!Modifier.isPrivate(method.getModifiers())) {
                listOfMethodSpecs.add(new MethodParser((Method)method, theContract, uniqueName).getMethodSpec());
            }
        });
        return listOfMethodSpecs;
    }

    public static List<FunSpec> generateFunctionSpecsForEachTest(Class theContract) {
        ArrayList<FunSpec> listOfFunSpecs = new ArrayList<FunSpec>();
        HashMap functionNameCountMap = new HashMap();
        MethodFilter.extractValidMethods(theContract).forEach(method -> {
            String uniqueName = MethodFilter.getUniqueName(method, functionNameCountMap);
            if (!Modifier.isPrivate(method.getModifiers())) {
                listOfFunSpecs.add(new FunParser((Method)method, theContract, uniqueName).getFunSpec());
            }
        });
        return listOfFunSpecs;
    }

    private static String getUniqueName(Method method, Map<String, Integer> nameCountMap) {
        String baseName = method.getName();
        int count = nameCountMap.getOrDefault(baseName, 0);
        nameCountMap.put(baseName, count + 1);
        return count > 0 ? baseName + count : baseName;
    }
}

