/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.web3j.codegen.Console;
import org.web3j.codegen.FunctionWrapperGenerator;
import org.web3j.codegen.SolidityFunctionWrapper;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.methods.response.AbiDefinition;
import org.web3j.utils.Collection;
import org.web3j.utils.Strings;
import picocli.CommandLine;

public class TruffleJsonFunctionWrapperGenerator
extends FunctionWrapperGenerator {
    public static final String COMMAND_TRUFFLE = "truffle";
    public static final String COMMAND_GENERATE = "generate";
    public static final String COMMAND_PREFIX = "truffle generate";
    private final String jsonFileLocation;
    private final boolean generateBothCallAndSend;

    public TruffleJsonFunctionWrapperGenerator(String jsonFileLocation, String destinationDirLocation, String basePackageName, boolean useJavaNativeTypes, boolean generateBothCallAndSend) {
        super(new File(destinationDirLocation), basePackageName, useJavaNativeTypes);
        this.jsonFileLocation = jsonFileLocation;
        this.generateBothCallAndSend = generateBothCallAndSend;
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals(COMMAND_TRUFFLE)) {
            args = Collection.tail((String[])args);
        }
        if (args.length > 0 && args[0].equals(COMMAND_GENERATE)) {
            args = Collection.tail((String[])args);
        }
        CommandLine cmd = new CommandLine((Object)new PicocliRunner());
        cmd.parseWithHandlers((CommandLine.IParseResultHandler2)((CommandLine.AbstractParseResultHandler)new CommandLine.RunLast().useOut(System.out)).useAnsi(CommandLine.Help.Ansi.AUTO), (CommandLine.IExceptionHandler2)RethrowExceptionHandler.HANDLER, args);
    }

    static Contract loadContractDefinition(File jsonFile) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (Contract)objectMapper.readValue(jsonFile, Contract.class);
    }

    @Override
    public void generate() throws IOException, ClassNotFoundException {
        File truffleJsonFile = new File(this.jsonFileLocation);
        if (!truffleJsonFile.exists() || !truffleJsonFile.canRead()) {
            Console.exitError("Invalid input json file specified: " + this.jsonFileLocation);
        }
        String fileName = truffleJsonFile.getName();
        String contractName = TruffleJsonFunctionWrapperGenerator.getFileNameNoExtension(fileName);
        Contract c = TruffleJsonFunctionWrapperGenerator.loadContractDefinition(truffleJsonFile);
        if (c == null) {
            Console.exitError("Unable to parse input json file");
        } else {
            String className = Strings.capitaliseFirstLetter((String)contractName);
            System.out.printf("Generating " + this.basePackageName + "." + className + " ... ", new Object[0]);
            Map<String, String> addresses = c.networks != null && !c.networks.isEmpty() ? c.networks.entrySet().stream().filter(e -> e.getValue() != null && ((NetworkInfo)e.getValue()).getAddress() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> ((NetworkInfo)e.getValue()).getAddress())) : Collections.EMPTY_MAP;
            new SolidityFunctionWrapper(this.useJavaNativeTypes, 160, this.generateBothCallAndSend).generateJavaFiles(contractName, c.getBytecode(), c.getAbi(), this.destinationDirLocation.toString(), this.basePackageName, addresses);
            System.out.println("File written to " + this.destinationDirLocation.toString() + "\n");
        }
    }

    @CommandLine.Command(name="truffle generate", mixinStandardHelpOptions=true, version={"4.0"}, sortOptions=false)
    private static class PicocliRunner
    implements Callable<Void> {
        @CommandLine.Option(names={"-jt", "--javaTypes"}, description={"use native Java types."}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
        boolean useJavaNativeTypes;
        @CommandLine.Option(names={"-st", "--solidityTypes"}, description={"use solidity types."})
        boolean useSolidityTypes;
        @CommandLine.Parameters(index="0")
        String jsonFileLocation;
        @CommandLine.Option(names={"-o", "--outputDir"}, description={"destination base directory."}, required=true)
        private String destinationDirLocation;
        @CommandLine.Option(names={"-B", "--generateBoth"}, description={"generate both call and send functions."}, required=false)
        private boolean generateBothCallAndSend;
        @CommandLine.Option(names={"-p", "--package"}, description={"base package name."}, required=true)
        private String basePackageName;

        private PicocliRunner() {
        }

        @Override
        public Void call() throws Exception {
            this.useJavaNativeTypes = !this.useSolidityTypes;
            new TruffleJsonFunctionWrapperGenerator(this.jsonFileLocation, this.destinationDirLocation, this.basePackageName, this.useJavaNativeTypes, this.generateBothCallAndSend).generate();
            return null;
        }
    }

    public static class RethrowExceptionHandler
    implements CommandLine.IExceptionHandler2<List<Object>> {
        public static final RethrowExceptionHandler HANDLER = new RethrowExceptionHandler();

        public List<Object> handleParseException(CommandLine.ParameterException ex, String[] args) {
            throw ex;
        }

        public List<Object> handleExecutionException(CommandLine.ExecutionException ex, CommandLine.ParseResult parseResult) {
            throw ex;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"contractName", "abi", "bytecode", "deployedBytecode", "sourceMap", "deployedSourceMap", "source", "sourcePath", "ast", "compiler", "networks", "schemaVersion", "updatedAt"})
    public static class Contract {
        @JsonProperty(value="contractName")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="^[a-zA-Z_][a-zA-Z0-9_]*$")
        public String contractName;
        @JsonProperty(value="abi", required=true)
        public List<AbiDefinition> abi;
        @JsonProperty(value="bytecode")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="^0x0$|^0x([a-fA-F0-9]{2}|__.{38})+$")
        public String bytecode;
        @JsonProperty(value="deployedBytecode")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="^0x0$|^0x([a-fA-F0-9]{2}|__.{38})+$")
        public String deployedBytecode;
        @JsonProperty(value="sourceMap")
        public String sourceMap;
        @JsonProperty(value="deployedSourceMap")
        public String deployedSourceMap;
        @JsonProperty(value="source")
        public String source;
        @JsonProperty(value="sourcePath")
        public String sourcePath;
        @JsonProperty(value="ast")
        public JsonNode ast;
        @JsonProperty(value="compiler")
        public Compiler compiler;
        @JsonProperty(value="networks")
        public Map<String, NetworkInfo> networks;
        @JsonProperty(value="schemaVersion")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="[0-9]+\\.[0-9]+\\.[0-9]+")
        public String schemaVersion;
        @JsonProperty(value="updatedAt")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="GMT")
        public Date updatedAt;

        public Contract() {
        }

        public Contract(String contractName, List<AbiDefinition> abi, String bytecode, String deployedBytecode, String sourceMap, String deployedSourceMap, String source, String sourcePath, JsonNode ast, Compiler compiler, Map<String, NetworkInfo> networks, String schemaVersion, Date updatedAt) {
            this.contractName = contractName;
            this.abi = abi;
            this.bytecode = bytecode;
            this.deployedBytecode = deployedBytecode;
            this.sourceMap = sourceMap;
            this.deployedSourceMap = deployedSourceMap;
            this.source = source;
            this.sourcePath = sourcePath;
            this.ast = ast;
            this.compiler = compiler;
            this.networks = networks;
            this.schemaVersion = schemaVersion;
            this.updatedAt = updatedAt;
        }

        public String getContractName() {
            return this.contractName;
        }

        public List<AbiDefinition> getAbi() {
            return this.abi;
        }

        public String getBytecode() {
            return this.bytecode;
        }

        public NetworkInfo getNetwork(String networkId) {
            return this.networks == null ? null : this.networks.get(networkId);
        }

        public String getAddress(String networkId) {
            NetworkInfo network = this.getNetwork(networkId);
            return network == null ? null : network.getAddress();
        }

        public String getAddress(Network network) {
            return this.getAddress(Long.toString(network.id));
        }

        static enum Network {
            olympic(0L),
            mainnet(1L),
            morden(2L),
            ropsten(3L),
            rinkeby(4L),
            kovan(42L);

            public final long id;

            private Network(long id) {
                this.id = id;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"events", "links", "address"})
    public static class NetworkInfo {
        @JsonProperty(value="events")
        public Map<String, JsonNode> events;
        @JsonProperty(value="links")
        public Map<String, JsonNode> links;
        @JsonProperty(value="address")
        public String address;

        public NetworkInfo() {
        }

        public NetworkInfo(Map<String, JsonNode> events, Map<String, JsonNode> links, String address) {
            this.events = events;
            this.links = links;
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"name", "version"})
    public static class Compiler {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="version")
        public String version;
        @JsonIgnore
        private Map<String, JsonNode> additionalProperties = new HashMap<String, JsonNode>();

        public Compiler() {
        }

        public Compiler(String name, String version) {
            this.name = name;
            this.version = version;
        }

        @JsonAnyGetter
        public Map<String, JsonNode> getAdditionalProperties() {
            return this.additionalProperties;
        }

        @JsonAnySetter
        public void setAdditionalProperty(String name, JsonNode value) {
            this.additionalProperties.put(name, value);
        }

        public Compiler withAdditionalProperty(String name, JsonNode value) {
            this.additionalProperties.put(name, value);
            return this;
        }
    }
}

