/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.aion.crypto;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.jetbrains.annotations.NotNull;
import org.web3j.aion.AionConstants;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0012\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003R\u001b\u0010\u0012\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0004\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0002\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/web3j/aion/crypto/Ed25519KeyPair;", "", "publicKey", "", "privateKey", "([B[B)V", "([B)V", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;Ljava/math/BigInteger;)V", "", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "privateKeyParameters", "Lorg/bouncycastle/crypto/params/Ed25519PrivateKeyParameters;", "(Lorg/bouncycastle/crypto/params/Ed25519PrivateKeyParameters;)V", "publicKeyParameters", "Lorg/bouncycastle/crypto/params/Ed25519PublicKeyParameters;", "(Lorg/bouncycastle/crypto/params/Ed25519PublicKeyParameters;Lorg/bouncycastle/crypto/params/Ed25519PrivateKeyParameters;)V", "address", "getAddress", "()Ljava/lang/String;", "address$delegate", "Lkotlin/Lazy;", "getPrivateKey", "()[B", "privateKey$delegate", "getPublicKey", "publicKey$delegate", "sign", "transactionHash", "verify", "", "data", "signature", "web3j-aion-common"})
public final class Ed25519KeyPair {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy publicKey$delegate;
    @NotNull
    private final Lazy privateKey$delegate;
    @NotNull
    private final Lazy address$delegate;
    private final Ed25519PublicKeyParameters publicKeyParameters;
    private final Ed25519PrivateKeyParameters privateKeyParameters;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Ed25519KeyPair.class), "publicKey", "getPublicKey()[B")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Ed25519KeyPair.class), "privateKey", "getPrivateKey()[B")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Ed25519KeyPair.class), "address", "getAddress()Ljava/lang/String;"))};
    }

    @NotNull
    public final byte[] getPublicKey() {
        Lazy lazy = this.publicKey$delegate;
        Ed25519KeyPair ed25519KeyPair = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (byte[])lazy.getValue();
    }

    @NotNull
    public final byte[] getPrivateKey() {
        Lazy lazy = this.privateKey$delegate;
        Ed25519KeyPair ed25519KeyPair = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (byte[])lazy.getValue();
    }

    @NotNull
    public final String getAddress() {
        Lazy lazy = this.address$delegate;
        Ed25519KeyPair ed25519KeyPair = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final byte[] sign(@NotNull byte[] transactionHash) {
        Intrinsics.checkParameterIsNotNull((Object)transactionHash, (String)"transactionHash");
        Ed25519Signer ed25519Signer = new Ed25519Signer();
        boolean bl = false;
        boolean bl2 = false;
        Ed25519Signer $this$with = ed25519Signer;
        boolean bl3 = false;
        $this$with.init(true, (CipherParameters)this.privateKeyParameters);
        $this$with.update(transactionHash, 0, transactionHash.length);
        byte[] byArray = $this$with.generateSignature();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"generateSignature()");
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"with(Ed25519Signer()) {\n\u2026rateSignature()\n        }");
        return byArray;
    }

    public final boolean verify(@NotNull byte[] data, @NotNull byte[] signature) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Ed25519Signer ed25519Signer = new Ed25519Signer();
        boolean bl = false;
        boolean bl2 = false;
        Ed25519Signer $this$with = ed25519Signer;
        boolean bl3 = false;
        $this$with.init(false, (CipherParameters)this.publicKeyParameters);
        $this$with.update(data, 0, data.length);
        return $this$with.verifySignature(signature);
    }

    private Ed25519KeyPair(Ed25519PublicKeyParameters publicKeyParameters, Ed25519PrivateKeyParameters privateKeyParameters) {
        this.publicKeyParameters = publicKeyParameters;
        this.privateKeyParameters = privateKeyParameters;
        this.publicKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ Ed25519KeyPair this$0;

            public final byte[] invoke() {
                return Ed25519KeyPair.access$getPublicKeyParameters$p(this.this$0).getEncoded();
            }
            {
                this.this$0 = ed25519KeyPair;
                super(0);
            }
        }));
        this.privateKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ Ed25519KeyPair this$0;

            public final byte[] invoke() {
                return Ed25519KeyPair.access$getPrivateKeyParameters$p(this.this$0).getEncoded();
            }
            {
                this.this$0 = ed25519KeyPair;
                super(0);
            }
        }));
        this.address$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Ed25519KeyPair this$0;

            public final String invoke() {
                byte[] byArray = Hash.blake2b256((byte[])this.this$0.getPublicKey());
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Hash.blake2b256(publicKey)");
                int n = 1;
                List pkHash = ArraysKt.slice((byte[])byArray, (IntRange)new IntRange(n, 31));
                return Numeric.toHexString((byte[])ArraysKt.plus((byte[])AionConstants.INSTANCE.getADDRESS_ID(), (Collection)pkHash));
            }
            {
                this.this$0 = ed25519KeyPair;
                super(0);
            }
        }));
    }

    public Ed25519KeyPair(@NotNull byte[] publicKey2, @NotNull byte[] privateKey2) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey2, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)privateKey2, (String)"privateKey");
        this(new Ed25519PublicKeyParameters(publicKey2, 0), new Ed25519PrivateKeyParameters(privateKey2, 0));
    }

    public Ed25519KeyPair(@NotNull byte[] privateKey2) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey2, (String)"privateKey");
        this(new Ed25519PrivateKeyParameters(privateKey2, 0));
    }

    public Ed25519KeyPair(@NotNull BigInteger publicKey2, @NotNull BigInteger privateKey2) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey2, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)privateKey2, (String)"privateKey");
        byte[] byArray = publicKey2.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"publicKey.toByteArray()");
        byte[] byArray2 = privateKey2.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"privateKey.toByteArray()");
        this(byArray, byArray2);
    }

    public Ed25519KeyPair(@NotNull String privateKey2) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey2, (String)"privateKey");
        byte[] byArray = Numeric.hexStringToByteArray((String)privateKey2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Numeric.hexStringToByteArray(privateKey)");
        this(byArray);
    }

    public Ed25519KeyPair(@NotNull String publicKey2, @NotNull String privateKey2) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey2, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)privateKey2, (String)"privateKey");
        byte[] byArray = Numeric.hexStringToByteArray((String)publicKey2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Numeric.hexStringToByteArray(publicKey)");
        byte[] byArray2 = Numeric.hexStringToByteArray((String)privateKey2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Numeric.hexStringToByteArray(privateKey)");
        this(byArray, byArray2);
    }

    private Ed25519KeyPair(Ed25519PrivateKeyParameters privateKeyParameters) {
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = privateKeyParameters.generatePublicKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)ed25519PublicKeyParameters, (String)"privateKeyParameters.generatePublicKey()");
        this(ed25519PublicKeyParameters, privateKeyParameters);
    }

    public static final /* synthetic */ Ed25519PublicKeyParameters access$getPublicKeyParameters$p(Ed25519KeyPair $this) {
        return $this.publicKeyParameters;
    }

    public static final /* synthetic */ Ed25519PrivateKeyParameters access$getPrivateKeyParameters$p(Ed25519KeyPair $this) {
        return $this.privateKeyParameters;
    }
}

