/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.reflect.ParameterizedType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Type;

public abstract class TypeReference<T extends Type>
implements Comparable<TypeReference<T>> {
    protected static Pattern ARRAY_SUFFIX = Pattern.compile("\\[(\\d*)]");
    private final java.lang.reflect.Type type;
    private final boolean indexed;

    protected TypeReference() {
        this(false);
    }

    protected TypeReference(boolean indexed) {
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.indexed = indexed;
    }

    TypeReference getSubTypeReference() {
        return null;
    }

    @Override
    public int compareTo(TypeReference<T> o) {
        return 0;
    }

    public java.lang.reflect.Type getType() {
        return this.type;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public Class<T> getClassType() throws ClassNotFoundException {
        java.lang.reflect.Type clsType = this.getType();
        if (this.getType() instanceof ParameterizedType) {
            return (Class)((ParameterizedType)clsType).getRawType();
        }
        return Class.forName(clsType.getTypeName());
    }

    public static <T extends Type> TypeReference<T> create(Class<T> cls) {
        return TypeReference.create(cls, false);
    }

    public static <T extends Type> TypeReference<T> create(final Class<T> cls, boolean indexed) {
        return new TypeReference<T>(indexed){

            @Override
            public java.lang.reflect.Type getType() {
                return cls;
            }
        };
    }

    protected static Class<? extends Type> getAtomicTypeClass(String solidityType, boolean primitives) throws ClassNotFoundException {
        if (ARRAY_SUFFIX.matcher(solidityType).find()) {
            throw new ClassNotFoundException("getAtomicTypeClass does not work with array types. See makeTypeReference()");
        }
        return AbiTypes.getType(solidityType, primitives);
    }

    public static TypeReference makeTypeReference(String solidityType) throws ClassNotFoundException {
        return TypeReference.makeTypeReference(solidityType, false, false);
    }

    public static TypeReference makeTypeReference(String solidityType, final boolean indexed, boolean primitives) throws ClassNotFoundException {
        Matcher nextSquareBrackets = ARRAY_SUFFIX.matcher(solidityType);
        if (!nextSquareBrackets.find()) {
            Class<Type> typeClass = TypeReference.getAtomicTypeClass(solidityType, primitives);
            return TypeReference.create(typeClass, indexed);
        }
        int lastReadStringPosition = nextSquareBrackets.start();
        Class<Type> baseClass = TypeReference.getAtomicTypeClass(solidityType.substring(0, lastReadStringPosition), primitives);
        TypeReference<Array> arrayWrappedType = TypeReference.create(baseClass, indexed);
        int len = solidityType.length();
        while (lastReadStringPosition < len) {
            String arraySize = nextSquareBrackets.group(1);
            final TypeReference<DynamicArray> baseTr = arrayWrappedType;
            if (arraySize == null || arraySize.equals("")) {
                arrayWrappedType = new TypeReference<DynamicArray>(indexed){

                    @Override
                    TypeReference getSubTypeReference() {
                        return baseTr;
                    }

                    @Override
                    public java.lang.reflect.Type getType() {
                        return new ParameterizedType(){

                            @Override
                            public java.lang.reflect.Type[] getActualTypeArguments() {
                                return new java.lang.reflect.Type[]{baseTr.getType()};
                            }

                            @Override
                            public java.lang.reflect.Type getRawType() {
                                return DynamicArray.class;
                            }

                            @Override
                            public java.lang.reflect.Type getOwnerType() {
                                return Class.class;
                            }
                        };
                    }
                };
            } else {
                int arraySizeInt = Integer.parseInt(arraySize);
                final Class arrayclass = arraySizeInt <= 32 ? Class.forName("org.web3j.abi.datatypes.generated.StaticArray" + arraySize) : StaticArray.class;
                arrayWrappedType = new StaticArrayTypeReference<StaticArray>(arraySizeInt){

                    @Override
                    TypeReference getSubTypeReference() {
                        return baseTr;
                    }

                    @Override
                    public boolean isIndexed() {
                        return indexed;
                    }

                    @Override
                    public java.lang.reflect.Type getType() {
                        return new ParameterizedType(){

                            @Override
                            public java.lang.reflect.Type[] getActualTypeArguments() {
                                return new java.lang.reflect.Type[]{baseTr.getType()};
                            }

                            @Override
                            public java.lang.reflect.Type getRawType() {
                                return arrayclass;
                            }

                            @Override
                            public java.lang.reflect.Type getOwnerType() {
                                return Class.class;
                            }
                        };
                    }
                };
            }
            lastReadStringPosition = nextSquareBrackets.end();
            nextSquareBrackets = ARRAY_SUFFIX.matcher(solidityType);
            if (nextSquareBrackets.find(lastReadStringPosition) || lastReadStringPosition == len) continue;
            throw new ClassNotFoundException("Unable to make TypeReference from " + solidityType);
        }
        return arrayWrappedType;
    }

    public static abstract class StaticArrayTypeReference<T extends Type>
    extends TypeReference<T> {
        private final int size;

        protected StaticArrayTypeReference(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

