/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.List;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Type;

public class StaticArray<T extends Type>
extends Array<T> {
    public static int MAX_SIZE_OF_STATIC_ARRAY = 32;
    private Integer expectedSize;

    @SafeVarargs
    public StaticArray(T ... values) {
        super(values[0].getTypeAsString() + "[" + values.length + "]", values);
        this.isValid();
    }

    @SafeVarargs
    public StaticArray(int expectedSize, T ... values) {
        super(values[0].getTypeAsString() + "[" + values.length + "]", values);
        this.expectedSize = expectedSize;
        this.isValid();
    }

    public StaticArray(List<T> values) {
        super(((Type)values.get(0)).getTypeAsString() + "[" + values.size() + "]", values);
        this.isValid();
    }

    public StaticArray(int expectedSize, List<T> values) {
        super(((Type)values.get(0)).getTypeAsString() + "[" + values.size() + "]", values);
        this.expectedSize = expectedSize;
        this.isValid();
    }

    private void isValid() {
        MAX_SIZE_OF_STATIC_ARRAY = 32;
        if (this.expectedSize == null && this.value.size() > MAX_SIZE_OF_STATIC_ARRAY) {
            throw new UnsupportedOperationException("Static arrays with a length greater than 32 are not supported.");
        }
        if (this.expectedSize != null && this.value.size() != this.expectedSize.intValue()) {
            throw new UnsupportedOperationException("Expected array of type [" + this.getClass().getSimpleName() + "] to have [" + this.expectedSize + "] elements.");
        }
    }
}

