/*
 * Decompiled with CFR 0.152.
 */
package org.wcdevs.blog.cdk;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.wcdevs.blog.cdk.ApplicationEnvironment;
import org.wcdevs.blog.cdk.Util;
import software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetConfiguration;
import software.amazon.awscdk.services.ec2.SubnetType;
import software.amazon.awscdk.services.ec2.Vpc;
import software.amazon.awscdk.services.ecs.Cluster;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRule;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRuleProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction;
import software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCertificate;
import software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition;
import software.amazon.awscdk.services.elasticloadbalancingv2.RedirectOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.awscdk.services.ssm.StringParameter;
import software.constructs.Construct;
import software.constructs.IConstruct;

public final class Network
extends Construct {
    private static final String CLUSTER_NAME = "EcsCluster";
    private static final String PARAM_VPC_ID = "vpcId";
    private static final String PARAM_HTTP_LISTENER_ARN = "httpListenerArn";
    private static final String PARAM_HTTPS_LISTENER_ARN = "httpsListenerArn";
    private static final String PARAM_LOAD_BALANCER_SECURITY_GROUP_ID = "lBSecGroupId";
    private static final String PARAM_LOAD_BALANCER_ARN = "lBArn";
    private static final String PARAM_LOAD_BALANCER_DNS_NAME = "lBDnsName";
    private static final String PARAM_LOAD_BALANCER_CANONICAL_HOSTED_ZONE_ID = "lBCanHostZoneId";
    private static final String PARAM_CLUSTER_NAME = "clusterName";
    private static final String PARAM_AVAILABILITY_ZONES = "availabilityZn";
    private static final String PARAM_ISOLATED_SUBNETS = "isolatedSubNet";
    private static final String PARAM_PUBLIC_SUBNETS = "publicSubNet";
    private static final String PARAM_SSL_CERTIFICATE_ARN = "sslCertificateArn";
    private static final String CONSTRUCT_NAME = "Network";
    private ApplicationEnvironment applicationEnvironment;
    private IVpc vpc;
    private ICluster ecsCluster;
    private ISecurityGroup loadBalancerSecurityGroup;
    private IApplicationLoadBalancer loadBalancer;
    private IApplicationListener httpListener;
    private IApplicationListener httpsListener;
    public static final String ALL_IP_RANGES_CIDR = "0.0.0.0/0";
    public static final String ALL_IP_PROTOCOLS = "-1";
    public static final int DEFAULT_NUMBER_OF_ISOLATED_SUBNETS_PER_AZ = 1;
    public static final int DEFAULT_NUMBER_OF_PUBLIC_SUBNETS_PER_AZ = 1;
    public static final int DEFAULT_NUMBER_OF_AZ = 2;
    public static final String NULL_ARN_VALUE = "null";
    public static final String DEFAULT_APPLICATION_NAME = "default";

    private Network(Construct scope, String id) {
        super(scope, id);
    }

    public static ApplicationEnvironment defaultNetworkApplicationEnvironment(String environment) {
        return new ApplicationEnvironment(DEFAULT_APPLICATION_NAME, environment);
    }

    public static Network newInstance(Construct scope, String id, ApplicationEnvironment applicationEnvironment, InputParameters inputParameters) {
        Construct validScope = Objects.requireNonNull(scope);
        String validId = Objects.requireNonNull(id);
        ApplicationEnvironment validAppEnv = Objects.requireNonNull(applicationEnvironment);
        String envName = validAppEnv.getEnvironmentName();
        String appName = validAppEnv.getApplicationName();
        InputParameters validInParams = Objects.requireNonNull(inputParameters);
        Network network = new Network(validScope, Util.string(envName, appName, validId));
        network.setApplicationEnvironment(validAppEnv);
        IVpc vpc = Network.vpcFrom(network, validAppEnv, validInParams.getNatGatewayNumber(), validInParams.getNumberOfIsolatedSubnetsPerAZ(), validInParams.getNumberOfPublicSubnetsPerAZ(), validInParams.getMaxAZs());
        network.setVpc(vpc);
        ICluster cluster = Network.clusterFrom(network, vpc, validAppEnv.prefixed(CLUSTER_NAME));
        network.setEcsCluster(cluster);
        LoadBalancerInfo loadBalancerInfo = Network.createLoadBalancer(network, validAppEnv, vpc, validInParams);
        network.setLoadBalancerSecurityGroup(loadBalancerInfo.getSecurityGroup());
        network.setLoadBalancer(loadBalancerInfo.getApplicationLoadBalancer());
        network.setHttpListener(loadBalancerInfo.getHttpListener());
        loadBalancerInfo.getHttpsListener().ifPresent(network::setHttpsListener);
        Network.saveNetworkInfoToParameterStore(network, inputParameters);
        applicationEnvironment.tag((IConstruct)network);
        return network;
    }

    private static ICluster clusterFrom(Construct scope, IVpc vpc, String clusterName) {
        return Cluster.Builder.create((Construct)scope, (String)"cluster").vpc(vpc).clusterName(clusterName).build();
    }

    private static IVpc vpcFrom(Construct scope, ApplicationEnvironment applicationEnvironment, int natGatewayNumber, int numberOfIsolatedSubnetsPerAZ, int numberOfPublicSubnetsPerAZ, int maxAZs) {
        if (numberOfIsolatedSubnetsPerAZ < 1 || numberOfPublicSubnetsPerAZ < 1 || maxAZs < 1) {
            throw new IllegalArgumentException("Number of private/public subnets and AZs must be >= 1");
        }
        String isolatedSubnetsNamePrefix = applicationEnvironment.prefixed(PARAM_ISOLATED_SUBNETS);
        Stream<SubnetConfiguration> isolatedSubnets = Network.subnetsStreamFrom(numberOfIsolatedSubnetsPerAZ, isolatedSubnetsNamePrefix, SubnetType.PRIVATE_ISOLATED);
        String publicSubnetsNamePrefix = applicationEnvironment.prefixed(PARAM_PUBLIC_SUBNETS);
        Stream<SubnetConfiguration> publicSubnets = Network.subnetsStreamFrom(numberOfPublicSubnetsPerAZ, publicSubnetsNamePrefix, SubnetType.PUBLIC);
        List<SubnetConfiguration> subnetConfig = Stream.concat(isolatedSubnets, publicSubnets).toList();
        return Vpc.Builder.create((Construct)scope, (String)"vpc").natGateways((Number)natGatewayNumber).maxAzs((Number)maxAZs).subnetConfiguration(subnetConfig).build();
    }

    private static Stream<SubnetConfiguration> subnetsStreamFrom(int numberOfIsolatedSubnets, String subnetsNamePrefix, SubnetType subnetType) {
        return IntStream.range(0, numberOfIsolatedSubnets).mapToObj(i -> Network.subnetFrom(subnetsNamePrefix + i, subnetType));
    }

    private static SubnetConfiguration subnetFrom(String name, SubnetType subnetType) {
        return SubnetConfiguration.builder().subnetType(subnetType).name(name).build();
    }

    private static LoadBalancerInfo createLoadBalancer(Construct scope, ApplicationEnvironment applicationEnvironment, IVpc vpc, InputParameters inParams) {
        String securityGroupName = applicationEnvironment.prefixed("lBSecGroup");
        String description = "Public access to the load balancer.";
        SecurityGroup loadBalancerSecurityGroup = SecurityGroup.Builder.create((Construct)scope, (String)securityGroupName).securityGroupName(securityGroupName).description(description).vpc(vpc).build();
        Network.cfnSecurityGroupIngressFrom(scope, loadBalancerSecurityGroup.getSecurityGroupId());
        String loadbalancerName = applicationEnvironment.prefixed("loadbalancer");
        ApplicationLoadBalancer loadBalancer = ApplicationLoadBalancer.Builder.create((Construct)scope, (String)"loadbalancer").loadBalancerName(loadbalancerName).vpc(vpc).internetFacing(Boolean.valueOf(true)).securityGroup((ISecurityGroup)loadBalancerSecurityGroup).build();
        String targetGroupName = applicationEnvironment.prefixed("noop-tGroup");
        List<ApplicationTargetGroup> targetGroup = Collections.singletonList(ApplicationTargetGroup.Builder.create((Construct)scope, (String)targetGroupName).vpc(vpc).port((Number)inParams.getListeningInternalHttpPort()).protocol(ApplicationProtocol.HTTP).targetGroupName(targetGroupName).targetType(TargetType.IP).build());
        BaseApplicationListenerProps httpListenerProps = BaseApplicationListenerProps.builder().port((Number)inParams.getListeningExternalHttpPort()).protocol(ApplicationProtocol.HTTP).open(Boolean.valueOf(true)).build();
        AddApplicationTargetGroupsProps appTargetGroupProps = AddApplicationTargetGroupsProps.builder().targetGroups(targetGroup).build();
        ApplicationListener httpListener = loadBalancer.addListener("httpListener", httpListenerProps);
        httpListener.addTargetGroups("httpTargetGroup", appTargetGroupProps);
        ApplicationListener httpsListener = null;
        if (Network.isArnNotNull(inParams.getSslCertificateArn())) {
            ListenerCertificate certificate = ListenerCertificate.fromArn((String)inParams.getSslCertificateArn());
            BaseApplicationListenerProps httpsListenerProps = BaseApplicationListenerProps.builder().port((Number)inParams.getListeningHttpsPort()).protocol(ApplicationProtocol.HTTPS).certificates(Collections.singletonList(certificate)).open(Boolean.valueOf(true)).build();
            httpsListener = loadBalancer.addListener("httpsListener", httpsListenerProps);
            AddApplicationTargetGroupsProps appsTargetGroupProps = AddApplicationTargetGroupsProps.builder().targetGroups(targetGroup).build();
            httpsListener.addTargetGroups("httpsTargetGroup", appsTargetGroupProps);
            ListenerAction redirection = ListenerAction.redirect((RedirectOptions)RedirectOptions.builder().port(inParams.getListeningHttpsPortString()).build());
            List<ListenerCondition> conditions = List.of(ListenerCondition.pathPatterns(List.of("*")));
            ApplicationListenerRuleProps appListenerRuleProps = ApplicationListenerRuleProps.builder().listener((IApplicationListener)httpListener).priority((Number)1).conditions(conditions).action(redirection).build();
            new ApplicationListenerRule(scope, "HttpListenerRule", appListenerRuleProps);
        }
        return new LoadBalancerInfo((ISecurityGroup)loadBalancerSecurityGroup, (IApplicationLoadBalancer)loadBalancer, (IApplicationListener)httpListener, (IApplicationListener)httpsListener);
    }

    private static CfnSecurityGroupIngress cfnSecurityGroupIngressFrom(Construct scope, String lBSecyGroupId) {
        return CfnSecurityGroupIngress.Builder.create((Construct)scope, (String)"ingressToLoadbalancer").groupId(lBSecyGroupId).cidrIp(ALL_IP_RANGES_CIDR).ipProtocol(ALL_IP_PROTOCOLS).build();
    }

    private static void saveNetworkInfoToParameterStore(Network network, InputParameters inParams) {
        Network.createStringParameter(network, PARAM_VPC_ID, network.getVpc().getVpcId());
        Network.createStringParameter(network, PARAM_CLUSTER_NAME, network.getEcsCluster().getClusterName());
        Network.createStringParameter(network, PARAM_LOAD_BALANCER_SECURITY_GROUP_ID, network.getLoadBalancerSecurityGroup().getSecurityGroupId());
        Network.createStringParameter(network, PARAM_LOAD_BALANCER_ARN, network.getLoadBalancer().getLoadBalancerArn());
        Network.createStringParameter(network, PARAM_LOAD_BALANCER_DNS_NAME, network.getLoadBalancer().getLoadBalancerDnsName());
        Network.createStringParameter(network, PARAM_LOAD_BALANCER_CANONICAL_HOSTED_ZONE_ID, network.getLoadBalancer().getLoadBalancerCanonicalHostedZoneId());
        Network.createStringParameter(network, PARAM_HTTP_LISTENER_ARN, network.getHttpListener().getListenerArn());
        String httpsListenerArn = network.getHttpsListener() != null ? network.getHttpsListener().getListenerArn() : NULL_ARN_VALUE;
        Network.createStringParameter(network, PARAM_HTTPS_LISTENER_ARN, httpsListenerArn);
        Network.createStringParameter(network, PARAM_SSL_CERTIFICATE_ARN, inParams.getSslCertificateArn());
        Network.createStringListParameter(network, PARAM_AVAILABILITY_ZONES, network.getVpc().getAvailabilityZones(), Function.identity());
        Network.createStringListParameter(network, PARAM_ISOLATED_SUBNETS, network.getVpc().getIsolatedSubnets(), ISubnet::getSubnetId);
        Network.createStringListParameter(network, PARAM_PUBLIC_SUBNETS, network.getVpc().getPublicSubnets(), ISubnet::getSubnetId);
    }

    private static void createStringParameter(Network network, String id, String stringValue) {
        if (Objects.nonNull((Object)network) && Objects.nonNull(id)) {
            String valueToStore = Objects.nonNull(stringValue) ? stringValue : NULL_ARN_VALUE;
            String paramName = Network.parameterName(network.getEnvironmentName(), network.getApplicationName(), id);
            StringParameter.Builder.create((Construct)network, (String)id).parameterName(paramName).stringValue(valueToStore).build();
        }
    }

    private String getEnvironmentName() {
        return this.getApplicationEnvironment().getEnvironmentName();
    }

    private String getApplicationName() {
        return this.getApplicationEnvironment().getApplicationName();
    }

    private static <T> void createStringListParameter(Network network, String id, List<? extends T> values, Function<T, String> mapper) {
        for (int i = 0; i < values.size(); ++i) {
            Network.createStringParameter(network, Network.idForParameterListItem(id, i), mapper.apply(values.get(i)));
        }
    }

    private static String idForParameterListItem(String id, int elementIndex) {
        return Util.joinedString("-", id, elementIndex);
    }

    private static String parameterName(String envName, String appName, String parameterName) {
        return Util.joinedString("-", envName, appName, CONSTRUCT_NAME, parameterName);
    }

    public static String getParameter(Construct scope, ApplicationEnvironment applicationEnvironment, String id) {
        if (Objects.nonNull(applicationEnvironment) && Objects.nonNull(scope) && Objects.nonNull(id)) {
            String environmentName = applicationEnvironment.getEnvironmentName();
            String applicationName = applicationEnvironment.getApplicationName();
            if (Objects.nonNull(environmentName) && Objects.nonNull(applicationName)) {
                String parameterName = Network.parameterName(environmentName, applicationName, id);
                return StringParameter.fromStringParameterName((Construct)scope, (String)id, (String)parameterName).getStringValue();
            }
        }
        return null;
    }

    public static String getVPCId(Construct scope, ApplicationEnvironment applicationEnvironment) {
        return Network.getParameter(scope, applicationEnvironment, PARAM_VPC_ID);
    }

    public static String getClusterName(Construct scope, ApplicationEnvironment applicationEnvironment) {
        return Network.getParameter(scope, applicationEnvironment, PARAM_CLUSTER_NAME);
    }

    public static String getLoadBalancerSecurityGroupId(Construct scope, ApplicationEnvironment appEnvironment) {
        return Network.getParameter(scope, appEnvironment, PARAM_LOAD_BALANCER_SECURITY_GROUP_ID);
    }

    public static String getLoadBalancerArn(Construct scope, ApplicationEnvironment applicationEnvironment) {
        return Network.getParameter(scope, applicationEnvironment, PARAM_LOAD_BALANCER_ARN);
    }

    public static String getLoadBalancerDnsName(Construct scope, ApplicationEnvironment applicationEnvironment) {
        return Network.getParameter(scope, applicationEnvironment, PARAM_LOAD_BALANCER_DNS_NAME);
    }

    public static String getLoadBalancerCanonicalHostedZoneId(Construct scope, ApplicationEnvironment appEnvironment) {
        return Network.getParameter(scope, appEnvironment, PARAM_LOAD_BALANCER_CANONICAL_HOSTED_ZONE_ID);
    }

    public static String getHttpListenerArn(Construct scope, ApplicationEnvironment applicationEnvironment) {
        return Network.getParameter(scope, applicationEnvironment, PARAM_HTTP_LISTENER_ARN);
    }

    public static String getHttpsListenerArn(Construct scope, ApplicationEnvironment applicationEnvironment) {
        return Network.getParameter(scope, applicationEnvironment, PARAM_HTTPS_LISTENER_ARN);
    }

    public static String getSslCertificateArn(Construct scope, ApplicationEnvironment applicationEnvironment) {
        return Network.getParameter(scope, applicationEnvironment, PARAM_SSL_CERTIFICATE_ARN);
    }

    public static List<String> getParameterList(Construct scope, ApplicationEnvironment applicationEnvironment, String id, int totalElements) {
        return IntStream.range(0, totalElements).mapToObj(i -> Network.getParameter(scope, applicationEnvironment, Network.idForParameterListItem(id, i))).filter(Objects::nonNull).toList();
    }

    public static List<String> getAvailabilityZones(Construct scope, ApplicationEnvironment applicationEnvironment, int totalAvailabilityZones) {
        return Network.getParameterList(scope, applicationEnvironment, PARAM_AVAILABILITY_ZONES, totalAvailabilityZones);
    }

    public static List<String> getIsolatedSubnets(Construct scope, ApplicationEnvironment applicationEnvironment, int totalIsolatedSubnets) {
        return Network.getParameterList(scope, applicationEnvironment, PARAM_ISOLATED_SUBNETS, totalIsolatedSubnets);
    }

    public static List<String> getPublicSubnets(Construct networkScope, ApplicationEnvironment applicationEnvironment, int totalPublicSubnets) {
        return Network.getParameterList(networkScope, applicationEnvironment, PARAM_PUBLIC_SUBNETS, totalPublicSubnets);
    }

    public static OutputParameters outputParametersFrom(Construct scope, ApplicationEnvironment appEnvironment) {
        return Network.outputParametersFrom(scope, appEnvironment, 1, 1, 2);
    }

    public static OutputParameters outputParametersFrom(Construct networkScope, ApplicationEnvironment appEnvironment, int numberOfIsolatedSubnetsPerAz, int numberOfPublicSubnetsPerAz, int totalAvailabilityZones) {
        Construct scope = Objects.requireNonNull(networkScope);
        if (numberOfIsolatedSubnetsPerAz < 1 || numberOfPublicSubnetsPerAz < 1 || totalAvailabilityZones < 1) {
            throw new IllegalArgumentException("The number of isolated and public subnets and the total availability zones must be greater than 0");
        }
        int totalIsolatedSubnets = numberOfIsolatedSubnetsPerAz * totalAvailabilityZones;
        int totalPublicSubnets = numberOfPublicSubnetsPerAz * totalAvailabilityZones;
        return new OutputParameters(Network.getVPCId(scope, appEnvironment), Network.getHttpListenerArn(scope, appEnvironment), Network.getHttpsListenerArn(scope, appEnvironment), Network.getSslCertificateArn(scope, appEnvironment), Network.getLoadBalancerSecurityGroupId(scope, appEnvironment), Network.getClusterName(scope, appEnvironment), Network.getIsolatedSubnets(scope, appEnvironment, totalIsolatedSubnets), Network.getPublicSubnets(scope, appEnvironment, totalPublicSubnets), Network.getAvailabilityZones(scope, appEnvironment, totalAvailabilityZones), Network.getLoadBalancerArn(scope, appEnvironment), Network.getLoadBalancerDnsName(scope, appEnvironment), Network.getLoadBalancerCanonicalHostedZoneId(scope, appEnvironment));
    }

    public static boolean isArnNotNull(String arn) {
        return Objects.nonNull(arn) && !arn.isEmpty() && !arn.isBlank() && !NULL_ARN_VALUE.equalsIgnoreCase(arn);
    }

    private void setApplicationEnvironment(ApplicationEnvironment applicationEnvironment) {
        this.applicationEnvironment = applicationEnvironment;
    }

    private void setVpc(IVpc vpc) {
        this.vpc = vpc;
    }

    private void setEcsCluster(ICluster ecsCluster) {
        this.ecsCluster = ecsCluster;
    }

    private void setLoadBalancerSecurityGroup(ISecurityGroup loadBalancerSecurityGroup) {
        this.loadBalancerSecurityGroup = loadBalancerSecurityGroup;
    }

    private void setLoadBalancer(IApplicationLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    private void setHttpListener(IApplicationListener httpListener) {
        this.httpListener = httpListener;
    }

    private void setHttpsListener(IApplicationListener httpsListener) {
        this.httpsListener = httpsListener;
    }

    ApplicationEnvironment getApplicationEnvironment() {
        return this.applicationEnvironment;
    }

    IVpc getVpc() {
        return this.vpc;
    }

    ICluster getEcsCluster() {
        return this.ecsCluster;
    }

    ISecurityGroup getLoadBalancerSecurityGroup() {
        return this.loadBalancerSecurityGroup;
    }

    IApplicationLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    IApplicationListener getHttpListener() {
        return this.httpListener;
    }

    IApplicationListener getHttpsListener() {
        return this.httpsListener;
    }

    public static final class InputParameters {
        private String sslCertificateArn;
        private int natGatewayNumber;
        private int numberOfIsolatedSubnetsPerAZ;
        private int numberOfPublicSubnetsPerAZ;
        private int maxAZs;
        private int listeningInternalHttpPort;
        private int listeningExternalHttpPort;
        private int listeningHttpsPort;

        String getListeningHttpsPortString() {
            return String.valueOf(this.listeningHttpsPort);
        }

        private static int $default$numberOfIsolatedSubnetsPerAZ() {
            return 1;
        }

        private static int $default$numberOfPublicSubnetsPerAZ() {
            return 1;
        }

        private static int $default$maxAZs() {
            return 2;
        }

        private static int $default$listeningInternalHttpPort() {
            return 8080;
        }

        private static int $default$listeningExternalHttpPort() {
            return 80;
        }

        private static int $default$listeningHttpsPort() {
            return 443;
        }

        InputParameters(String sslCertificateArn, int natGatewayNumber, int numberOfIsolatedSubnetsPerAZ, int numberOfPublicSubnetsPerAZ, int maxAZs, int listeningInternalHttpPort, int listeningExternalHttpPort, int listeningHttpsPort) {
            this.sslCertificateArn = sslCertificateArn;
            this.natGatewayNumber = natGatewayNumber;
            this.numberOfIsolatedSubnetsPerAZ = numberOfIsolatedSubnetsPerAZ;
            this.numberOfPublicSubnetsPerAZ = numberOfPublicSubnetsPerAZ;
            this.maxAZs = maxAZs;
            this.listeningInternalHttpPort = listeningInternalHttpPort;
            this.listeningExternalHttpPort = listeningExternalHttpPort;
            this.listeningHttpsPort = listeningHttpsPort;
        }

        public static InputParametersBuilder builder() {
            return new InputParametersBuilder();
        }

        String getSslCertificateArn() {
            return this.sslCertificateArn;
        }

        int getNatGatewayNumber() {
            return this.natGatewayNumber;
        }

        int getNumberOfIsolatedSubnetsPerAZ() {
            return this.numberOfIsolatedSubnetsPerAZ;
        }

        int getNumberOfPublicSubnetsPerAZ() {
            return this.numberOfPublicSubnetsPerAZ;
        }

        int getMaxAZs() {
            return this.maxAZs;
        }

        int getListeningInternalHttpPort() {
            return this.listeningInternalHttpPort;
        }

        int getListeningExternalHttpPort() {
            return this.listeningExternalHttpPort;
        }

        int getListeningHttpsPort() {
            return this.listeningHttpsPort;
        }

        public static class InputParametersBuilder {
            private String sslCertificateArn;
            private int natGatewayNumber;
            private boolean numberOfIsolatedSubnetsPerAZ$set;
            private int numberOfIsolatedSubnetsPerAZ$value;
            private boolean numberOfPublicSubnetsPerAZ$set;
            private int numberOfPublicSubnetsPerAZ$value;
            private boolean maxAZs$set;
            private int maxAZs$value;
            private boolean listeningInternalHttpPort$set;
            private int listeningInternalHttpPort$value;
            private boolean listeningExternalHttpPort$set;
            private int listeningExternalHttpPort$value;
            private boolean listeningHttpsPort$set;
            private int listeningHttpsPort$value;

            InputParametersBuilder() {
            }

            public InputParametersBuilder sslCertificateArn(String sslCertificateArn) {
                this.sslCertificateArn = sslCertificateArn;
                return this;
            }

            public InputParametersBuilder natGatewayNumber(int natGatewayNumber) {
                this.natGatewayNumber = natGatewayNumber;
                return this;
            }

            public InputParametersBuilder numberOfIsolatedSubnetsPerAZ(int numberOfIsolatedSubnetsPerAZ) {
                this.numberOfIsolatedSubnetsPerAZ$value = numberOfIsolatedSubnetsPerAZ;
                this.numberOfIsolatedSubnetsPerAZ$set = true;
                return this;
            }

            public InputParametersBuilder numberOfPublicSubnetsPerAZ(int numberOfPublicSubnetsPerAZ) {
                this.numberOfPublicSubnetsPerAZ$value = numberOfPublicSubnetsPerAZ;
                this.numberOfPublicSubnetsPerAZ$set = true;
                return this;
            }

            public InputParametersBuilder maxAZs(int maxAZs) {
                this.maxAZs$value = maxAZs;
                this.maxAZs$set = true;
                return this;
            }

            public InputParametersBuilder listeningInternalHttpPort(int listeningInternalHttpPort) {
                this.listeningInternalHttpPort$value = listeningInternalHttpPort;
                this.listeningInternalHttpPort$set = true;
                return this;
            }

            public InputParametersBuilder listeningExternalHttpPort(int listeningExternalHttpPort) {
                this.listeningExternalHttpPort$value = listeningExternalHttpPort;
                this.listeningExternalHttpPort$set = true;
                return this;
            }

            public InputParametersBuilder listeningHttpsPort(int listeningHttpsPort) {
                this.listeningHttpsPort$value = listeningHttpsPort;
                this.listeningHttpsPort$set = true;
                return this;
            }

            public InputParameters build() {
                int numberOfIsolatedSubnetsPerAZ$value = this.numberOfIsolatedSubnetsPerAZ$value;
                if (!this.numberOfIsolatedSubnetsPerAZ$set) {
                    numberOfIsolatedSubnetsPerAZ$value = InputParameters.$default$numberOfIsolatedSubnetsPerAZ();
                }
                int numberOfPublicSubnetsPerAZ$value = this.numberOfPublicSubnetsPerAZ$value;
                if (!this.numberOfPublicSubnetsPerAZ$set) {
                    numberOfPublicSubnetsPerAZ$value = InputParameters.$default$numberOfPublicSubnetsPerAZ();
                }
                int maxAZs$value = this.maxAZs$value;
                if (!this.maxAZs$set) {
                    maxAZs$value = InputParameters.$default$maxAZs();
                }
                int listeningInternalHttpPort$value = this.listeningInternalHttpPort$value;
                if (!this.listeningInternalHttpPort$set) {
                    listeningInternalHttpPort$value = InputParameters.$default$listeningInternalHttpPort();
                }
                int listeningExternalHttpPort$value = this.listeningExternalHttpPort$value;
                if (!this.listeningExternalHttpPort$set) {
                    listeningExternalHttpPort$value = InputParameters.$default$listeningExternalHttpPort();
                }
                int listeningHttpsPort$value = this.listeningHttpsPort$value;
                if (!this.listeningHttpsPort$set) {
                    listeningHttpsPort$value = InputParameters.$default$listeningHttpsPort();
                }
                return new InputParameters(this.sslCertificateArn, this.natGatewayNumber, numberOfIsolatedSubnetsPerAZ$value, numberOfPublicSubnetsPerAZ$value, maxAZs$value, listeningInternalHttpPort$value, listeningExternalHttpPort$value, listeningHttpsPort$value);
            }

            public String toString() {
                return "Network.InputParameters.InputParametersBuilder(sslCertificateArn=" + this.sslCertificateArn + ", natGatewayNumber=" + this.natGatewayNumber + ", numberOfIsolatedSubnetsPerAZ$value=" + this.numberOfIsolatedSubnetsPerAZ$value + ", numberOfPublicSubnetsPerAZ$value=" + this.numberOfPublicSubnetsPerAZ$value + ", maxAZs$value=" + this.maxAZs$value + ", listeningInternalHttpPort$value=" + this.listeningInternalHttpPort$value + ", listeningExternalHttpPort$value=" + this.listeningExternalHttpPort$value + ", listeningHttpsPort$value=" + this.listeningHttpsPort$value + ")";
            }
        }
    }

    private static final class LoadBalancerInfo {
        private final ISecurityGroup securityGroup;
        private final IApplicationLoadBalancer applicationLoadBalancer;
        private final IApplicationListener httpListener;
        private final IApplicationListener httpsListener;

        private Optional<IApplicationListener> getHttpsListener() {
            return Optional.ofNullable(this.httpsListener);
        }

        public LoadBalancerInfo(ISecurityGroup securityGroup, IApplicationLoadBalancer applicationLoadBalancer, IApplicationListener httpListener, IApplicationListener httpsListener) {
            this.securityGroup = securityGroup;
            this.applicationLoadBalancer = applicationLoadBalancer;
            this.httpListener = httpListener;
            this.httpsListener = httpsListener;
        }

        ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        IApplicationLoadBalancer getApplicationLoadBalancer() {
            return this.applicationLoadBalancer;
        }

        IApplicationListener getHttpListener() {
            return this.httpListener;
        }
    }

    public static final class OutputParameters {
        private final String vpcId;
        private final String httpListenerArn;
        private final String httpsListenerArn;
        private final String sslCertificateArn;
        private final String loadbalancerSecurityGroupId;
        private final String ecsClusterName;
        private final List<String> isolatedSubnets;
        private final List<String> publicSubnets;
        private final List<String> availabilityZones;
        private final String loadBalancerArn;
        private final String loadBalancerDnsName;
        private final String loadBalancerCanonicalHostedZoneId;

        public Optional<String> getHttpsListenerArn() {
            return Optional.ofNullable(this.httpsListenerArn);
        }

        OutputParameters(String vpcId, String httpListenerArn, String httpsListenerArn, String sslCertificateArn, String loadbalancerSecurityGroupId, String ecsClusterName, List<String> isolatedSubnets, List<String> publicSubnets, List<String> availabilityZones, String loadBalancerArn, String loadBalancerDnsName, String loadBalancerCanonicalHostedZoneId) {
            this.vpcId = vpcId;
            this.httpListenerArn = httpListenerArn;
            this.httpsListenerArn = httpsListenerArn;
            this.sslCertificateArn = sslCertificateArn;
            this.loadbalancerSecurityGroupId = loadbalancerSecurityGroupId;
            this.ecsClusterName = ecsClusterName;
            this.isolatedSubnets = isolatedSubnets;
            this.publicSubnets = publicSubnets;
            this.availabilityZones = availabilityZones;
            this.loadBalancerArn = loadBalancerArn;
            this.loadBalancerDnsName = loadBalancerDnsName;
            this.loadBalancerCanonicalHostedZoneId = loadBalancerCanonicalHostedZoneId;
        }

        String getVpcId() {
            return this.vpcId;
        }

        String getHttpListenerArn() {
            return this.httpListenerArn;
        }

        String getSslCertificateArn() {
            return this.sslCertificateArn;
        }

        String getLoadbalancerSecurityGroupId() {
            return this.loadbalancerSecurityGroupId;
        }

        String getEcsClusterName() {
            return this.ecsClusterName;
        }

        List<String> getIsolatedSubnets() {
            return this.isolatedSubnets;
        }

        List<String> getPublicSubnets() {
            return this.publicSubnets;
        }

        List<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        String getLoadBalancerDnsName() {
            return this.loadBalancerDnsName;
        }

        String getLoadBalancerCanonicalHostedZoneId() {
            return this.loadBalancerCanonicalHostedZoneId;
        }
    }
}

