/*
 * Decompiled with CFR 0.152.
 */
package org.wcdevs.blog.cdk;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wcdevs.blog.cdk.ApplicationEnvironment;
import org.wcdevs.blog.cdk.Network;
import software.amazon.awscdk.CfnCondition;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.Fn;
import software.amazon.awscdk.ICfnConditionExpression;
import software.amazon.awscdk.ICfnRuleConditionExpression;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.ec2.CfnSecurityGroup;
import software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress;
import software.amazon.awscdk.services.ecr.IRepository;
import software.amazon.awscdk.services.ecr.Repository;
import software.amazon.awscdk.services.ecs.CfnService;
import software.amazon.awscdk.services.ecs.CfnTaskDefinition;
import software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule;
import software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.iam.ServicePrincipal;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.LogGroup;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.constructs.Construct;

public final class ElasticContainerService
extends Construct {
    private static final String ECS_TASKS_AMAZONAWS_PRINCIPAL = "ecs-tasks.amazonaws.com";
    private static final String NETWORK_MODE_AWS_VPC = "awsvpc";
    private static final String LUNCH_TYPE_FARGATE = "FARGATE";
    private static final String TARGET_TYPE_IP = "ip";
    private static final String TARGET_TYPE_INSTANCE = "instance";
    private static final String TARGET_TYPE_LAMBDA = "lambda";
    private static final String TARGET_TYPE_ALB = "alb";
    public static final String LOG_DRIVER_AWS_LOGS = "awslogs";
    public static final String LOG_DRIVER_SPLUNK = "splunk";
    public static final String LOG_DRIVER_AWS_FIRE_LENS = "awsfirelens";
    private static final String ASSIGN_PUBLIC_IP_ENABLED = "ENABLED";
    private static final String STICKY_SESSIONS_ENABLED = "stickiness.enabled";
    private static final String STICKY_SESSIONS_TYPE = "stickiness.type";
    private static final String STICKY_SESSIONS_LB_COOKIE_DURATION = "stickiness.lb_cookie.duration_seconds";
    private static final String STICKY_SESSIONS_TYPE_LB_COOKIE = "lb_cookie";
    private static final String STRING_TRUE = "true";
    private static final String LISTENER_RULE_ACTION_TYPE_FORWARD = "forward";
    private static final String LISTENER_RULE_ACTION_TYPE_FIXED_RESPONSE = "fixed-response";
    private static final String LISTENER_RULE_ACTION_TYPE_REDIRECT = "redirect";
    private static final String LISTENER_RULE_CONDITION_PATH_PATTERN = "path-pattern";
    private static final String LISTENER_RULE_CONDITION_HTTP_REQ_METHOD = "http-request-method";
    private static final String LISTENER_RULE_CONDITION_HOST_HEADER = "host-header";
    private static final String LISTENER_RULE_CONDITION_SOURCE_IP = "source-ip";
    private static final int HTTP_LISTENER_RULE_FORWARD_PATH_PRIORITY = 3;
    private static final int HTTPS_LISTENER_RULE_FORWARD_PATH_PRIORITY = 5;

    private ElasticContainerService(Construct scope, String id) {
        super(scope, id);
    }

    public static ElasticContainerService newInstance(Construct scope, String id, Environment awsEnvironment, ApplicationEnvironment applicationEnvironment, InputParameters inputParameters, Network.OutputParameters networkOutputParams) {
        InputParameters inParameters = Objects.requireNonNull(inputParameters);
        Network.OutputParameters netOutputParams = Objects.requireNonNull(networkOutputParams);
        ApplicationEnvironment appEnv = Objects.requireNonNull(applicationEnvironment);
        ElasticContainerService eCService = new ElasticContainerService(Objects.requireNonNull(scope), Objects.requireNonNull(id));
        CfnTargetGroup targetGroup = ElasticContainerService.targetGroup(eCService, inParameters, netOutputParams);
        ServiceListenerRules serviceHttpListenerRules = ElasticContainerService.httpListenerRules(eCService, targetGroup, netOutputParams);
        LogGroup logGroup = LogGroup.Builder.create((Construct)eCService, (String)"ecsLogGroup").logGroupName(applicationEnvironment.prefixed("logs")).retention(inParameters.getLogRetention()).removalPolicy(RemovalPolicy.DESTROY).build();
        Role ecsTaskExecutionRole = ElasticContainerService.ecsTaskExecutionRole(eCService, appEnv);
        Role ecsTaskRole = ElasticContainerService.ecsTaskRole(eCService, appEnv, inParameters);
        String dockerImageUrl = ElasticContainerService.dockerImageRepositoryUrl(eCService, inParameters, (IGrantable)ecsTaskExecutionRole);
        CfnTaskDefinition.ContainerDefinitionProperty containerDefProperty = ElasticContainerService.containerDefinitionProperty(Objects.requireNonNull(awsEnvironment), (ILogGroup)logGroup, appEnv, inParameters, dockerImageUrl);
        CfnTaskDefinition taskDefinition = ElasticContainerService.taskDefinition(eCService, inParameters, (IRole)ecsTaskExecutionRole, (IRole)ecsTaskRole, containerDefProperty);
        CfnSecurityGroup ecsSecurityGroup = ElasticContainerService.ecsSecurityGroup(eCService, inParameters, netOutputParams);
        CfnService cfnService = ElasticContainerService.cfnService(eCService, taskDefinition, targetGroup, ecsSecurityGroup, appEnv, inParameters, netOutputParams);
        cfnService.addDependsOn((CfnResource)serviceHttpListenerRules.getHttpRule());
        return eCService;
    }

    private static CfnTargetGroup targetGroup(ElasticContainerService scope, InputParameters params, Network.OutputParameters netOutputParameters) {
        return CfnTargetGroup.Builder.create((Construct)scope, (String)"targetGroup").healthCheckIntervalSeconds((Number)params.getHealthCheckIntervalSeconds()).healthCheckPath(params.getHealthCheckPath()).healthCheckPort(params.getHealthCheckPortString()).healthCheckProtocol(params.getHealthCheckProtocol()).healthCheckTimeoutSeconds((Number)params.getHealthCheckTimeoutSeconds()).healthyThresholdCount((Number)params.getHealthyThresholdCount()).unhealthyThresholdCount((Number)params.getUnhealthyThresholdCount()).targetGroupAttributes(ElasticContainerService.stickySessionsConf(params)).targetType(TARGET_TYPE_IP).port((Number)params.getApplicationPort()).protocol(params.getApplicationProtocol()).vpcId(netOutputParameters.getVpcId()).build();
    }

    private static List<CfnTargetGroup.TargetGroupAttributeProperty> stickySessionsConf(InputParameters params) {
        String cookieDuration = String.valueOf(params.getStickySessionsCookieDuration());
        return !params.isStickySessionsEnabled() ? Collections.emptyList() : List.of(CfnTargetGroup.TargetGroupAttributeProperty.builder().key(STICKY_SESSIONS_ENABLED).value(STRING_TRUE).build(), CfnTargetGroup.TargetGroupAttributeProperty.builder().key(STICKY_SESSIONS_TYPE).value(STICKY_SESSIONS_TYPE_LB_COOKIE).build(), CfnTargetGroup.TargetGroupAttributeProperty.builder().key(STICKY_SESSIONS_LB_COOKIE_DURATION).value(cookieDuration).build());
    }

    private static ServiceListenerRules httpListenerRules(Construct scope, CfnTargetGroup targetGroup, Network.OutputParameters netOutputParams) {
        CfnListenerRule.ActionProperty actionProperty = CfnListenerRule.ActionProperty.builder().targetGroupArn(targetGroup.getRef()).type(LISTENER_RULE_ACTION_TYPE_FORWARD).build();
        CfnListenerRule.RuleConditionProperty conditionProperty = CfnListenerRule.RuleConditionProperty.builder().field(LISTENER_RULE_CONDITION_PATH_PATTERN).values(List.of("*")).build();
        String nullValue = "null";
        String httpsListenerArn = netOutputParams.getHttpsListenerArn().orElse(nullValue);
        ICfnRuleConditionExpression httpsListenerIsNotNull = Fn.conditionNot((ICfnConditionExpression)Fn.conditionEquals((Object)httpsListenerArn, (Object)nullValue));
        CfnCondition httpsListenerArnExists = CfnCondition.Builder.create((Construct)scope, (String)"httpsListenerRuleCondition").expression((ICfnConditionExpression)httpsListenerIsNotNull).build();
        CfnListenerRule httpsListenerRule = CfnListenerRule.Builder.create((Construct)scope, (String)"httpsListenerRule").actions(List.of(actionProperty)).conditions(List.of(conditionProperty)).listenerArn(httpsListenerArn).priority((Number)3).build();
        httpsListenerRule.getCfnOptions().setCondition(httpsListenerArnExists);
        CfnListenerRule httpListenerRule = CfnListenerRule.Builder.create((Construct)scope, (String)"httpListenerRule").actions(List.of(actionProperty)).conditions(List.of(conditionProperty)).listenerArn(netOutputParams.getHttpListenerArn()).priority((Number)5).build();
        return new ServiceListenerRules(httpListenerRule, httpsListenerRule);
    }

    private static Role ecsTaskExecutionRole(Construct scope, ApplicationEnvironment appEnv) {
        List<String> resources = List.of("*");
        List<String> actions = List.of("ecr:GetAuthorizationToken", "ecr:BatchCheckLayerAvailability", "ecr:GetDownloadUrlForLayer", "ecr:BatchGetImage", "logs:CreateLogStream", "logs:PutLogEvents");
        List<PolicyStatement> statements = List.of(PolicyStatement.Builder.create().effect(Effect.ALLOW).resources(resources).actions(actions).build());
        PolicyDocument policyDocument = PolicyDocument.Builder.create().statements(statements).build();
        Map<String, PolicyDocument> policies = Map.of(appEnv.prefixed("ecsTaskExecRolePolicy"), policyDocument);
        return Role.Builder.create((Construct)scope, (String)"ecsTaskExecRole").assumedBy((IPrincipal)ServicePrincipal.Builder.create((String)ECS_TASKS_AMAZONAWS_PRINCIPAL).build()).path("/").inlinePolicies(policies).build();
    }

    private static Role ecsTaskRole(Construct scope, ApplicationEnvironment appEnv, InputParameters params) {
        ServicePrincipal iamPrincipal = ServicePrincipal.Builder.create((String)ECS_TASKS_AMAZONAWS_PRINCIPAL).build();
        Role.Builder roleBuilder = Role.Builder.create((Construct)scope, (String)"ecsTaskRole").assumedBy((IPrincipal)iamPrincipal).path("/");
        List<PolicyStatement> taskRolePolicyStatements = params.getTaskRolePolicyStatements();
        if (taskRolePolicyStatements != null && !taskRolePolicyStatements.isEmpty()) {
            PolicyDocument policyDocument = PolicyDocument.Builder.create().statements(taskRolePolicyStatements).build();
            roleBuilder.inlinePolicies(Map.of(appEnv.prefixed("ecsTaskRolePolicy"), policyDocument));
        }
        return roleBuilder.build();
    }

    private static String dockerImageRepositoryUrl(Construct scope, InputParameters params, IGrantable ecsTaskExecutionRole) {
        DockerImage dockerImage = Objects.requireNonNull(params.getDockerImage());
        if (dockerImage.isEcrSource()) {
            String dockerRepositoryName = Objects.requireNonNull(dockerImage.getDockerRepositoryName());
            IRepository dockerRepository = Repository.fromRepositoryName((Construct)scope, (String)"ecRepository", (String)dockerRepositoryName);
            dockerRepository.grantPullPush(ecsTaskExecutionRole);
            String dockerImageTag = Objects.requireNonNull(dockerImage.getDockerImageTag());
            return dockerRepository.repositoryUriForTag(dockerImageTag);
        }
        return Objects.requireNonNull(dockerImage.getDockerImageUrl());
    }

    private static CfnTaskDefinition.ContainerDefinitionProperty containerDefinitionProperty(Environment awsEnv, ILogGroup logGroup, ApplicationEnvironment appEnv, InputParameters params, String dockerImageRepositoryUrl) {
        Map<String, String> logConfOptions = Map.of("awslogs-group", logGroup.getLogGroupName(), "awslogs-region", Objects.requireNonNull(awsEnv.getRegion()), "awslogs-stream-prefix", appEnv.prefixed("stream"), "awslogs-datetime-format", params.getAwsLogsDateTimeFormat());
        CfnTaskDefinition.LogConfigurationProperty logConf = CfnTaskDefinition.LogConfigurationProperty.builder().logDriver(LOG_DRIVER_AWS_LOGS).options(logConfOptions).build();
        List portMappings = Stream.of(params.getApplicationPort(), params.getHealthCheckPort()).distinct().map(port -> CfnTaskDefinition.PortMappingProperty.builder().containerPort((Number)port).build()).collect(Collectors.toList());
        List<CfnTaskDefinition.KeyValuePairProperty> environmentVars = ElasticContainerService.cfnTaskDefKeyValuePropertiesFrom(params.getEnvironmentVariables());
        return CfnTaskDefinition.ContainerDefinitionProperty.builder().name(ElasticContainerService.containerName(appEnv)).cpu((Number)params.getCpu()).memory((Number)params.getMemory()).image(dockerImageRepositoryUrl).logConfiguration(logConf).portMappings(portMappings).environment(environmentVars).build();
    }

    private static String containerName(ApplicationEnvironment appEnv) {
        return appEnv.prefixed("container");
    }

    private static List<CfnTaskDefinition.KeyValuePairProperty> cfnTaskDefKeyValuePropertiesFrom(Map<String, String> source) {
        return source.entrySet().stream().map(ElasticContainerService::cfnTaskDefKeyValuePropertyFrom).toList();
    }

    private static CfnTaskDefinition.KeyValuePairProperty cfnTaskDefKeyValuePropertyFrom(Map.Entry<String, String> entry) {
        return CfnTaskDefinition.KeyValuePairProperty.builder().name(entry.getKey()).value(entry.getValue()).build();
    }

    private static CfnTaskDefinition taskDefinition(Construct scope, InputParameters params, IRole ecsTaskExecutionRole, IRole ecsTaskRole, CfnTaskDefinition.ContainerDefinitionProperty prop) {
        return CfnTaskDefinition.Builder.create((Construct)scope, (String)"taskDefinition").cpu(String.valueOf(params.getCpu())).memory(String.valueOf(params.getMemory())).networkMode(NETWORK_MODE_AWS_VPC).requiresCompatibilities(List.of(LUNCH_TYPE_FARGATE)).executionRoleArn(ecsTaskExecutionRole.getRoleArn()).taskRoleArn(ecsTaskRole.getRoleArn()).containerDefinitions(List.of(prop)).build();
    }

    private static CfnSecurityGroup ecsSecurityGroup(Construct scope, InputParameters params, Network.OutputParameters netOutputParameters) {
        CfnSecurityGroup secGroup = CfnSecurityGroup.Builder.create((Construct)scope, (String)"ecsSecurityGroup").vpcId(netOutputParameters.getVpcId()).groupDescription("Security Group for the ECS container").build();
        CfnSecurityGroupIngress.Builder.create((Construct)scope, (String)"ecsIngressFromSelf").ipProtocol("-1").sourceSecurityGroupId(secGroup.getAttrGroupId()).groupId(secGroup.getAttrGroupId()).build();
        CfnSecurityGroupIngress.Builder.create((Construct)scope, (String)"ecsIngressFromLoadBalancer").ipProtocol("-1").sourceSecurityGroupId(netOutputParameters.getLoadbalancerSecurityGroupId()).groupId(secGroup.getAttrGroupId()).build();
        ElasticContainerService.allowIngressFromEcsToSecurityGroupIds(scope, secGroup.getAttrGroupId(), params.getSecurityGroupIdsToGrantIngressFromEcs());
        return secGroup;
    }

    private static void allowIngressFromEcsToSecurityGroupIds(Construct scope, String ecsSecGroupId, Collection<String> sGroupsAccFromEcs) {
        IntFunction<String> idFn = counter -> String.format("securityGroupIngress%s", counter);
        AtomicInteger counter2 = new AtomicInteger(1);
        ((Collection)Optional.ofNullable(sGroupsAccFromEcs).orElse(Collections.emptyList())).forEach(id -> CfnSecurityGroupIngress.Builder.create((Construct)scope, (String)((String)idFn.apply(counter2.getAndIncrement()))).sourceSecurityGroupId(ecsSecGroupId).groupId(id).ipProtocol("-1").build());
    }

    private static CfnService cfnService(Construct scope, CfnTaskDefinition taskDefinition, CfnTargetGroup targetGroup, CfnSecurityGroup securityGroup, ApplicationEnvironment appEnv, InputParameters params, Network.OutputParameters netOutputParameters) {
        CfnService.DeploymentConfigurationProperty deployConf = CfnService.DeploymentConfigurationProperty.builder().maximumPercent((Number)params.getMaximumInstancesPercent()).minimumHealthyPercent((Number)params.getMinimumHealthyInstancesPercent()).build();
        CfnService.LoadBalancerProperty lBalancerConf = CfnService.LoadBalancerProperty.builder().containerName(ElasticContainerService.containerName(appEnv)).containerPort((Number)params.getApplicationPort()).targetGroupArn(targetGroup.getRef()).build();
        CfnService.AwsVpcConfigurationProperty vpcConf = CfnService.AwsVpcConfigurationProperty.builder().assignPublicIp(ASSIGN_PUBLIC_IP_ENABLED).securityGroups(List.of(securityGroup.getAttrGroupId())).subnets(netOutputParameters.getPublicSubnets()).build();
        CfnService.NetworkConfigurationProperty netProps = CfnService.NetworkConfigurationProperty.builder().awsvpcConfiguration(vpcConf).build();
        return CfnService.Builder.create((Construct)scope, (String)"ecsService").cluster(netOutputParameters.getEcsClusterName()).launchType(LUNCH_TYPE_FARGATE).deploymentConfiguration(deployConf).desiredCount((Number)params.getDesiredInstancesCount()).taskDefinition(taskDefinition.getRef()).loadBalancers(List.of(lBalancerConf)).networkConfiguration(netProps).build();
    }

    public static InputParameters newInputParameters(DockerImage dockerImage) {
        return InputParameters.builder().dockerImage(dockerImage).build();
    }

    public static final class InputParameters {
        private static final String DEFAULT_PROTOCOL = "HTTP";
        private static final int DEFAULT_PORT = 8080;
        private static final String DEFAULT_PATH = "/";
        private DockerImage dockerImage;
        private Map<String, String> environmentVariables;
        private List<String> securityGroupIdsToGrantIngressFromEcs;
        private List<PolicyStatement> taskRolePolicyStatements;
        private String applicationProtocol;
        private int applicationPort;
        private String healthCheckProtocol;
        private int healthCheckPort;
        private String healthCheckPath;
        private int healthCheckIntervalSeconds;
        private int healthCheckTimeoutSeconds;
        private int healthyThresholdCount;
        private int unhealthyThresholdCount;
        private RetentionDays logRetention;
        private int cpu;
        private int memory;
        private int desiredInstancesCount;
        private int maximumInstancesPercent;
        private int minimumHealthyInstancesPercent;
        private boolean stickySessionsEnabled;
        private int stickySessionsCookieDuration;
        private String awsLogsDateTimeFormat;

        String getHealthCheckPortString() {
            return Objects.nonNull(this.healthCheckPort) ? String.valueOf(this.healthCheckPort) : "";
        }

        private static Map<String, String> $default$environmentVariables() {
            return Collections.emptyMap();
        }

        private static List<String> $default$securityGroupIdsToGrantIngressFromEcs() {
            return Collections.emptyList();
        }

        private static List<PolicyStatement> $default$taskRolePolicyStatements() {
            return Collections.emptyList();
        }

        private static String $default$applicationProtocol() {
            return DEFAULT_PROTOCOL;
        }

        private static int $default$applicationPort() {
            return 8080;
        }

        private static String $default$healthCheckProtocol() {
            return DEFAULT_PROTOCOL;
        }

        private static int $default$healthCheckPort() {
            return 8080;
        }

        private static String $default$healthCheckPath() {
            return DEFAULT_PATH;
        }

        private static int $default$healthCheckIntervalSeconds() {
            return 15;
        }

        private static int $default$healthCheckTimeoutSeconds() {
            return 5;
        }

        private static int $default$healthyThresholdCount() {
            return 2;
        }

        private static int $default$unhealthyThresholdCount() {
            return 8;
        }

        private static RetentionDays $default$logRetention() {
            return RetentionDays.ONE_WEEK;
        }

        private static int $default$cpu() {
            return 256;
        }

        private static int $default$memory() {
            return 512;
        }

        private static int $default$desiredInstancesCount() {
            return 2;
        }

        private static int $default$maximumInstancesPercent() {
            return 200;
        }

        private static int $default$minimumHealthyInstancesPercent() {
            return 50;
        }

        private static int $default$stickySessionsCookieDuration() {
            return 3600;
        }

        private static String $default$awsLogsDateTimeFormat() {
            return "%Y-%m-%dT%H:%M:%S.%f%z";
        }

        InputParameters(DockerImage dockerImage, Map<String, String> environmentVariables, List<String> securityGroupIdsToGrantIngressFromEcs, List<PolicyStatement> taskRolePolicyStatements, String applicationProtocol, int applicationPort, String healthCheckProtocol, int healthCheckPort, String healthCheckPath, int healthCheckIntervalSeconds, int healthCheckTimeoutSeconds, int healthyThresholdCount, int unhealthyThresholdCount, RetentionDays logRetention, int cpu, int memory, int desiredInstancesCount, int maximumInstancesPercent, int minimumHealthyInstancesPercent, boolean stickySessionsEnabled, int stickySessionsCookieDuration, String awsLogsDateTimeFormat) {
            this.dockerImage = dockerImage;
            this.environmentVariables = environmentVariables;
            this.securityGroupIdsToGrantIngressFromEcs = securityGroupIdsToGrantIngressFromEcs;
            this.taskRolePolicyStatements = taskRolePolicyStatements;
            this.applicationProtocol = applicationProtocol;
            this.applicationPort = applicationPort;
            this.healthCheckProtocol = healthCheckProtocol;
            this.healthCheckPort = healthCheckPort;
            this.healthCheckPath = healthCheckPath;
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            this.healthyThresholdCount = healthyThresholdCount;
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            this.logRetention = logRetention;
            this.cpu = cpu;
            this.memory = memory;
            this.desiredInstancesCount = desiredInstancesCount;
            this.maximumInstancesPercent = maximumInstancesPercent;
            this.minimumHealthyInstancesPercent = minimumHealthyInstancesPercent;
            this.stickySessionsEnabled = stickySessionsEnabled;
            this.stickySessionsCookieDuration = stickySessionsCookieDuration;
            this.awsLogsDateTimeFormat = awsLogsDateTimeFormat;
        }

        public static InputParametersBuilder builder() {
            return new InputParametersBuilder();
        }

        DockerImage getDockerImage() {
            return this.dockerImage;
        }

        Map<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        List<String> getSecurityGroupIdsToGrantIngressFromEcs() {
            return this.securityGroupIdsToGrantIngressFromEcs;
        }

        List<PolicyStatement> getTaskRolePolicyStatements() {
            return this.taskRolePolicyStatements;
        }

        String getApplicationProtocol() {
            return this.applicationProtocol;
        }

        int getApplicationPort() {
            return this.applicationPort;
        }

        String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        int getHealthCheckPort() {
            return this.healthCheckPort;
        }

        String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        int getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        int getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        int getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        int getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        RetentionDays getLogRetention() {
            return this.logRetention;
        }

        int getCpu() {
            return this.cpu;
        }

        int getMemory() {
            return this.memory;
        }

        int getDesiredInstancesCount() {
            return this.desiredInstancesCount;
        }

        int getMaximumInstancesPercent() {
            return this.maximumInstancesPercent;
        }

        int getMinimumHealthyInstancesPercent() {
            return this.minimumHealthyInstancesPercent;
        }

        boolean isStickySessionsEnabled() {
            return this.stickySessionsEnabled;
        }

        int getStickySessionsCookieDuration() {
            return this.stickySessionsCookieDuration;
        }

        String getAwsLogsDateTimeFormat() {
            return this.awsLogsDateTimeFormat;
        }

        public static class InputParametersBuilder {
            private DockerImage dockerImage;
            private boolean environmentVariables$set;
            private Map<String, String> environmentVariables$value;
            private boolean securityGroupIdsToGrantIngressFromEcs$set;
            private List<String> securityGroupIdsToGrantIngressFromEcs$value;
            private boolean taskRolePolicyStatements$set;
            private List<PolicyStatement> taskRolePolicyStatements$value;
            private boolean applicationProtocol$set;
            private String applicationProtocol$value;
            private boolean applicationPort$set;
            private int applicationPort$value;
            private boolean healthCheckProtocol$set;
            private String healthCheckProtocol$value;
            private boolean healthCheckPort$set;
            private int healthCheckPort$value;
            private boolean healthCheckPath$set;
            private String healthCheckPath$value;
            private boolean healthCheckIntervalSeconds$set;
            private int healthCheckIntervalSeconds$value;
            private boolean healthCheckTimeoutSeconds$set;
            private int healthCheckTimeoutSeconds$value;
            private boolean healthyThresholdCount$set;
            private int healthyThresholdCount$value;
            private boolean unhealthyThresholdCount$set;
            private int unhealthyThresholdCount$value;
            private boolean logRetention$set;
            private RetentionDays logRetention$value;
            private boolean cpu$set;
            private int cpu$value;
            private boolean memory$set;
            private int memory$value;
            private boolean desiredInstancesCount$set;
            private int desiredInstancesCount$value;
            private boolean maximumInstancesPercent$set;
            private int maximumInstancesPercent$value;
            private boolean minimumHealthyInstancesPercent$set;
            private int minimumHealthyInstancesPercent$value;
            private boolean stickySessionsEnabled;
            private boolean stickySessionsCookieDuration$set;
            private int stickySessionsCookieDuration$value;
            private boolean awsLogsDateTimeFormat$set;
            private String awsLogsDateTimeFormat$value;

            InputParametersBuilder() {
            }

            public InputParametersBuilder dockerImage(DockerImage dockerImage) {
                this.dockerImage = dockerImage;
                return this;
            }

            public InputParametersBuilder environmentVariables(Map<String, String> environmentVariables) {
                this.environmentVariables$value = environmentVariables;
                this.environmentVariables$set = true;
                return this;
            }

            public InputParametersBuilder securityGroupIdsToGrantIngressFromEcs(List<String> securityGroupIdsToGrantIngressFromEcs) {
                this.securityGroupIdsToGrantIngressFromEcs$value = securityGroupIdsToGrantIngressFromEcs;
                this.securityGroupIdsToGrantIngressFromEcs$set = true;
                return this;
            }

            public InputParametersBuilder taskRolePolicyStatements(List<PolicyStatement> taskRolePolicyStatements) {
                this.taskRolePolicyStatements$value = taskRolePolicyStatements;
                this.taskRolePolicyStatements$set = true;
                return this;
            }

            public InputParametersBuilder applicationProtocol(String applicationProtocol) {
                this.applicationProtocol$value = applicationProtocol;
                this.applicationProtocol$set = true;
                return this;
            }

            public InputParametersBuilder applicationPort(int applicationPort) {
                this.applicationPort$value = applicationPort;
                this.applicationPort$set = true;
                return this;
            }

            public InputParametersBuilder healthCheckProtocol(String healthCheckProtocol) {
                this.healthCheckProtocol$value = healthCheckProtocol;
                this.healthCheckProtocol$set = true;
                return this;
            }

            public InputParametersBuilder healthCheckPort(int healthCheckPort) {
                this.healthCheckPort$value = healthCheckPort;
                this.healthCheckPort$set = true;
                return this;
            }

            public InputParametersBuilder healthCheckPath(String healthCheckPath) {
                this.healthCheckPath$value = healthCheckPath;
                this.healthCheckPath$set = true;
                return this;
            }

            public InputParametersBuilder healthCheckIntervalSeconds(int healthCheckIntervalSeconds) {
                this.healthCheckIntervalSeconds$value = healthCheckIntervalSeconds;
                this.healthCheckIntervalSeconds$set = true;
                return this;
            }

            public InputParametersBuilder healthCheckTimeoutSeconds(int healthCheckTimeoutSeconds) {
                this.healthCheckTimeoutSeconds$value = healthCheckTimeoutSeconds;
                this.healthCheckTimeoutSeconds$set = true;
                return this;
            }

            public InputParametersBuilder healthyThresholdCount(int healthyThresholdCount) {
                this.healthyThresholdCount$value = healthyThresholdCount;
                this.healthyThresholdCount$set = true;
                return this;
            }

            public InputParametersBuilder unhealthyThresholdCount(int unhealthyThresholdCount) {
                this.unhealthyThresholdCount$value = unhealthyThresholdCount;
                this.unhealthyThresholdCount$set = true;
                return this;
            }

            public InputParametersBuilder logRetention(RetentionDays logRetention) {
                this.logRetention$value = logRetention;
                this.logRetention$set = true;
                return this;
            }

            public InputParametersBuilder cpu(int cpu) {
                this.cpu$value = cpu;
                this.cpu$set = true;
                return this;
            }

            public InputParametersBuilder memory(int memory) {
                this.memory$value = memory;
                this.memory$set = true;
                return this;
            }

            public InputParametersBuilder desiredInstancesCount(int desiredInstancesCount) {
                this.desiredInstancesCount$value = desiredInstancesCount;
                this.desiredInstancesCount$set = true;
                return this;
            }

            public InputParametersBuilder maximumInstancesPercent(int maximumInstancesPercent) {
                this.maximumInstancesPercent$value = maximumInstancesPercent;
                this.maximumInstancesPercent$set = true;
                return this;
            }

            public InputParametersBuilder minimumHealthyInstancesPercent(int minimumHealthyInstancesPercent) {
                this.minimumHealthyInstancesPercent$value = minimumHealthyInstancesPercent;
                this.minimumHealthyInstancesPercent$set = true;
                return this;
            }

            public InputParametersBuilder stickySessionsEnabled(boolean stickySessionsEnabled) {
                this.stickySessionsEnabled = stickySessionsEnabled;
                return this;
            }

            public InputParametersBuilder stickySessionsCookieDuration(int stickySessionsCookieDuration) {
                this.stickySessionsCookieDuration$value = stickySessionsCookieDuration;
                this.stickySessionsCookieDuration$set = true;
                return this;
            }

            public InputParametersBuilder awsLogsDateTimeFormat(String awsLogsDateTimeFormat) {
                this.awsLogsDateTimeFormat$value = awsLogsDateTimeFormat;
                this.awsLogsDateTimeFormat$set = true;
                return this;
            }

            public InputParameters build() {
                Map<String, String> environmentVariables$value = this.environmentVariables$value;
                if (!this.environmentVariables$set) {
                    environmentVariables$value = InputParameters.$default$environmentVariables();
                }
                List<String> securityGroupIdsToGrantIngressFromEcs$value = this.securityGroupIdsToGrantIngressFromEcs$value;
                if (!this.securityGroupIdsToGrantIngressFromEcs$set) {
                    securityGroupIdsToGrantIngressFromEcs$value = InputParameters.$default$securityGroupIdsToGrantIngressFromEcs();
                }
                List<PolicyStatement> taskRolePolicyStatements$value = this.taskRolePolicyStatements$value;
                if (!this.taskRolePolicyStatements$set) {
                    taskRolePolicyStatements$value = InputParameters.$default$taskRolePolicyStatements();
                }
                String applicationProtocol$value = this.applicationProtocol$value;
                if (!this.applicationProtocol$set) {
                    applicationProtocol$value = InputParameters.$default$applicationProtocol();
                }
                int applicationPort$value = this.applicationPort$value;
                if (!this.applicationPort$set) {
                    applicationPort$value = InputParameters.$default$applicationPort();
                }
                String healthCheckProtocol$value = this.healthCheckProtocol$value;
                if (!this.healthCheckProtocol$set) {
                    healthCheckProtocol$value = InputParameters.$default$healthCheckProtocol();
                }
                int healthCheckPort$value = this.healthCheckPort$value;
                if (!this.healthCheckPort$set) {
                    healthCheckPort$value = InputParameters.$default$healthCheckPort();
                }
                String healthCheckPath$value = this.healthCheckPath$value;
                if (!this.healthCheckPath$set) {
                    healthCheckPath$value = InputParameters.$default$healthCheckPath();
                }
                int healthCheckIntervalSeconds$value = this.healthCheckIntervalSeconds$value;
                if (!this.healthCheckIntervalSeconds$set) {
                    healthCheckIntervalSeconds$value = InputParameters.$default$healthCheckIntervalSeconds();
                }
                int healthCheckTimeoutSeconds$value = this.healthCheckTimeoutSeconds$value;
                if (!this.healthCheckTimeoutSeconds$set) {
                    healthCheckTimeoutSeconds$value = InputParameters.$default$healthCheckTimeoutSeconds();
                }
                int healthyThresholdCount$value = this.healthyThresholdCount$value;
                if (!this.healthyThresholdCount$set) {
                    healthyThresholdCount$value = InputParameters.$default$healthyThresholdCount();
                }
                int unhealthyThresholdCount$value = this.unhealthyThresholdCount$value;
                if (!this.unhealthyThresholdCount$set) {
                    unhealthyThresholdCount$value = InputParameters.$default$unhealthyThresholdCount();
                }
                RetentionDays logRetention$value = this.logRetention$value;
                if (!this.logRetention$set) {
                    logRetention$value = InputParameters.$default$logRetention();
                }
                int cpu$value = this.cpu$value;
                if (!this.cpu$set) {
                    cpu$value = InputParameters.$default$cpu();
                }
                int memory$value = this.memory$value;
                if (!this.memory$set) {
                    memory$value = InputParameters.$default$memory();
                }
                int desiredInstancesCount$value = this.desiredInstancesCount$value;
                if (!this.desiredInstancesCount$set) {
                    desiredInstancesCount$value = InputParameters.$default$desiredInstancesCount();
                }
                int maximumInstancesPercent$value = this.maximumInstancesPercent$value;
                if (!this.maximumInstancesPercent$set) {
                    maximumInstancesPercent$value = InputParameters.$default$maximumInstancesPercent();
                }
                int minimumHealthyInstancesPercent$value = this.minimumHealthyInstancesPercent$value;
                if (!this.minimumHealthyInstancesPercent$set) {
                    minimumHealthyInstancesPercent$value = InputParameters.$default$minimumHealthyInstancesPercent();
                }
                int stickySessionsCookieDuration$value = this.stickySessionsCookieDuration$value;
                if (!this.stickySessionsCookieDuration$set) {
                    stickySessionsCookieDuration$value = InputParameters.$default$stickySessionsCookieDuration();
                }
                String awsLogsDateTimeFormat$value = this.awsLogsDateTimeFormat$value;
                if (!this.awsLogsDateTimeFormat$set) {
                    awsLogsDateTimeFormat$value = InputParameters.$default$awsLogsDateTimeFormat();
                }
                return new InputParameters(this.dockerImage, environmentVariables$value, securityGroupIdsToGrantIngressFromEcs$value, taskRolePolicyStatements$value, applicationProtocol$value, applicationPort$value, healthCheckProtocol$value, healthCheckPort$value, healthCheckPath$value, healthCheckIntervalSeconds$value, healthCheckTimeoutSeconds$value, healthyThresholdCount$value, unhealthyThresholdCount$value, logRetention$value, cpu$value, memory$value, desiredInstancesCount$value, maximumInstancesPercent$value, minimumHealthyInstancesPercent$value, this.stickySessionsEnabled, stickySessionsCookieDuration$value, awsLogsDateTimeFormat$value);
            }

            public String toString() {
                return "ElasticContainerService.InputParameters.InputParametersBuilder(dockerImage=" + this.dockerImage + ", environmentVariables$value=" + this.environmentVariables$value + ", securityGroupIdsToGrantIngressFromEcs$value=" + this.securityGroupIdsToGrantIngressFromEcs$value + ", taskRolePolicyStatements$value=" + this.taskRolePolicyStatements$value + ", applicationProtocol$value=" + this.applicationProtocol$value + ", applicationPort$value=" + this.applicationPort$value + ", healthCheckProtocol$value=" + this.healthCheckProtocol$value + ", healthCheckPort$value=" + this.healthCheckPort$value + ", healthCheckPath$value=" + this.healthCheckPath$value + ", healthCheckIntervalSeconds$value=" + this.healthCheckIntervalSeconds$value + ", healthCheckTimeoutSeconds$value=" + this.healthCheckTimeoutSeconds$value + ", healthyThresholdCount$value=" + this.healthyThresholdCount$value + ", unhealthyThresholdCount$value=" + this.unhealthyThresholdCount$value + ", logRetention$value=" + this.logRetention$value + ", cpu$value=" + this.cpu$value + ", memory$value=" + this.memory$value + ", desiredInstancesCount$value=" + this.desiredInstancesCount$value + ", maximumInstancesPercent$value=" + this.maximumInstancesPercent$value + ", minimumHealthyInstancesPercent$value=" + this.minimumHealthyInstancesPercent$value + ", stickySessionsEnabled=" + this.stickySessionsEnabled + ", stickySessionsCookieDuration$value=" + this.stickySessionsCookieDuration$value + ", awsLogsDateTimeFormat$value=" + this.awsLogsDateTimeFormat$value + ")";
            }
        }
    }

    static class ServiceListenerRules {
        private final CfnListenerRule httpRule;
        private final CfnListenerRule httpsRule;

        CfnListenerRule getHttpRule() {
            return this.httpRule;
        }

        CfnListenerRule getHttpsRule() {
            return this.httpsRule;
        }

        ServiceListenerRules(CfnListenerRule httpRule, CfnListenerRule httpsRule) {
            this.httpRule = httpRule;
            this.httpsRule = httpsRule;
        }
    }

    public static final class DockerImage {
        private String dockerRepositoryName;
        private String dockerImageTag;
        private String dockerImageUrl;

        boolean isEcrSource() {
            return Objects.nonNull(this.dockerRepositoryName);
        }

        DockerImage(String dockerRepositoryName, String dockerImageTag, String dockerImageUrl) {
            this.dockerRepositoryName = dockerRepositoryName;
            this.dockerImageTag = dockerImageTag;
            this.dockerImageUrl = dockerImageUrl;
        }

        public static DockerImageBuilder builder() {
            return new DockerImageBuilder();
        }

        String getDockerRepositoryName() {
            return this.dockerRepositoryName;
        }

        String getDockerImageTag() {
            return this.dockerImageTag;
        }

        String getDockerImageUrl() {
            return this.dockerImageUrl;
        }

        public static class DockerImageBuilder {
            private String dockerRepositoryName;
            private String dockerImageTag;
            private String dockerImageUrl;

            DockerImageBuilder() {
            }

            public DockerImageBuilder dockerRepositoryName(String dockerRepositoryName) {
                this.dockerRepositoryName = dockerRepositoryName;
                return this;
            }

            public DockerImageBuilder dockerImageTag(String dockerImageTag) {
                this.dockerImageTag = dockerImageTag;
                return this;
            }

            public DockerImageBuilder dockerImageUrl(String dockerImageUrl) {
                this.dockerImageUrl = dockerImageUrl;
                return this;
            }

            public DockerImage build() {
                return new DockerImage(this.dockerRepositoryName, this.dockerImageTag, this.dockerImageUrl);
            }

            public String toString() {
                return "ElasticContainerService.DockerImage.DockerImageBuilder(dockerRepositoryName=" + this.dockerRepositoryName + ", dockerImageTag=" + this.dockerImageTag + ", dockerImageUrl=" + this.dockerImageUrl + ")";
            }
        }
    }
}

