/*
 * Decompiled with CFR 0.152.
 */
package org.wcdevs.blog.cdk;

import java.util.List;
import java.util.Objects;
import org.wcdevs.blog.cdk.ApplicationEnvironment;
import org.wcdevs.blog.cdk.Network;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.Stack;
import software.amazon.awscdk.StackProps;
import software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2;
import software.amazon.awscdk.services.route53.ARecord;
import software.amazon.awscdk.services.route53.HostedZone;
import software.amazon.awscdk.services.route53.HostedZoneProviderProps;
import software.amazon.awscdk.services.route53.IAliasRecordTarget;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.awscdk.services.route53.RecordTarget;
import software.amazon.awscdk.services.route53.targets.LoadBalancerTarget;
import software.constructs.Construct;
import software.constructs.IConstruct;

public final class DomainStack
extends Stack {
    private static final String CONSTRUCT_NAME = "domain-stack";

    private DomainStack(Construct scope, String id, Environment awsEnvironment, ApplicationEnvironment applicationEnvironment) {
        super(scope, id, StackProps.builder().stackName(applicationEnvironment.prefixed(CONSTRUCT_NAME)).env(awsEnvironment).build());
    }

    public static DomainStack newInstance(Construct scope, String id, Environment awsEnvironment, ApplicationEnvironment applicationEnvironment, String hostedZoneDomainName, String applicationDomainName) {
        DomainStack domainStack = new DomainStack(Objects.requireNonNull(scope), Objects.requireNonNull(id), Objects.requireNonNull(awsEnvironment), Objects.requireNonNull(applicationEnvironment));
        IHostedZone hostedZone = DomainStack.hostedZone((Construct)domainStack, Objects.requireNonNull(hostedZoneDomainName));
        Network.OutputParameters networkParams = Network.outputParametersFrom((Construct)domainStack, applicationEnvironment);
        ApplicationLoadBalancerAttributes albAttrs = ApplicationLoadBalancerAttributes.builder().loadBalancerArn(networkParams.getLoadBalancerArn()).securityGroupId(networkParams.getLoadbalancerSecurityGroupId()).loadBalancerCanonicalHostedZoneId(networkParams.getLoadBalancerCanonicalHostedZoneId()).loadBalancerDnsName(networkParams.getLoadBalancerDnsName()).build();
        IApplicationLoadBalancer appLoadBalancer = ApplicationLoadBalancer.fromApplicationLoadBalancerAttributes((Construct)domainStack, (String)"AppLoadBalancer", (ApplicationLoadBalancerAttributes)albAttrs);
        if (Network.isArnNotNull(networkParams.getSslCertificateArn())) {
            DnsValidatedCertificate.Builder.create((Construct)domainStack, (String)"AppCertificate").hostedZone(hostedZone).region(awsEnvironment.getRegion()).domainName(applicationDomainName).subjectAlternativeNames(List.of(applicationDomainName)).build();
        }
        ARecord.Builder.create((Construct)domainStack, (String)"ARecord").recordName(applicationDomainName).zone(hostedZone).target(RecordTarget.fromAlias((IAliasRecordTarget)new LoadBalancerTarget((ILoadBalancerV2)appLoadBalancer))).build();
        applicationEnvironment.tag((IConstruct)domainStack);
        return domainStack;
    }

    private static IHostedZone hostedZone(Construct scope, String hostedZoneDomainName) {
        HostedZoneProviderProps hostedZoneProviderProps = HostedZoneProviderProps.builder().domainName(hostedZoneDomainName).build();
        return HostedZone.fromLookup((Construct)scope, (String)"HostedZone", (HostedZoneProviderProps)hostedZoneProviderProps);
    }
}

