/*
 * Decompiled with CFR 0.152.
 */
package org.wcdevs.blog.cdk;

import java.util.Collections;
import java.util.Objects;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.ecr.IRepository;
import software.amazon.awscdk.services.ecr.LifecycleRule;
import software.amazon.awscdk.services.ecr.Repository;
import software.amazon.awscdk.services.ecr.TagMutability;
import software.amazon.awscdk.services.iam.AccountPrincipal;
import software.amazon.awscdk.services.iam.IGrantable;
import software.constructs.Construct;

public final class DockerRepository
extends Construct {
    private static final int LCR_PRIORITY = 1;
    static final String DOCKER_EC_REPOSITORY_ID = "ecRepository";
    private IRepository ecRepository;

    private DockerRepository(Construct scope, String id) {
        super(Objects.requireNonNull(scope), Objects.requireNonNull(id));
    }

    public static DockerRepository newInstance(Construct scope, String id, InputParameters inputParameters) {
        Construct validScope = Objects.requireNonNull(scope);
        InputParameters validInParams = Objects.requireNonNull(inputParameters);
        DockerRepository dockerRepository = new DockerRepository(validScope, Objects.requireNonNull(id));
        LifecycleRule lifecycleRule = LifecycleRule.builder().rulePriority((Number)1).description(DockerRepository.descriptionFrom(validInParams)).maxImageCount((Number)validInParams.getMaxImageCount()).build();
        Repository ecRepository = Repository.Builder.create((Construct)dockerRepository, (String)DOCKER_EC_REPOSITORY_ID).imageTagMutability(validInParams.tagMutability()).repositoryName(validInParams.getRepositoryName()).removalPolicy(validInParams.removalPolicy()).lifecycleRules(Collections.singletonList(lifecycleRule)).build();
        ecRepository.grantPullPush((IGrantable)new AccountPrincipal((Object)validInParams.getAccountId()));
        dockerRepository.setEcRepository((IRepository)ecRepository);
        return dockerRepository;
    }

    private static String descriptionFrom(InputParameters inParameter) {
        String description = "Docker ECR '%s' will hold a maximum of %s images. It will %s retained on deletion and tags are %s";
        return String.format(description, inParameter.getRepositoryName(), inParameter.getMaxImageCount(), inParameter.isRetainRegistryOnDelete() ? "be" : "not be", inParameter.isInmutableTags() ? "inmutables" : "mutables");
    }

    public static InputParameters newInputParameters(String repoName, String accountId) {
        return InputParameters.builder().repositoryName(repoName).accountId(accountId).build();
    }

    public IRepository getEcRepository() {
        return this.ecRepository;
    }

    private void setEcRepository(IRepository ecRepository) {
        this.ecRepository = ecRepository;
    }

    public static final class InputParameters {
        static final int DEFAULT_MAX_IMAGE_COUNT = 10;
        static final boolean DEFAULT_RETAIN_POLICY = true;
        static final boolean DEFAULT_INMUTABLE_TAGS = true;
        private String repositoryName;
        private String accountId;
        private int maxImageCount;
        private boolean retainRegistryOnDelete;
        private boolean inmutableTags;

        RemovalPolicy removalPolicy() {
            return this.retainRegistryOnDelete ? RemovalPolicy.RETAIN : RemovalPolicy.DESTROY;
        }

        TagMutability tagMutability() {
            return this.inmutableTags ? TagMutability.IMMUTABLE : TagMutability.MUTABLE;
        }

        private static int $default$maxImageCount() {
            return 10;
        }

        private static boolean $default$retainRegistryOnDelete() {
            return true;
        }

        private static boolean $default$inmutableTags() {
            return true;
        }

        InputParameters(String repositoryName, String accountId, int maxImageCount, boolean retainRegistryOnDelete, boolean inmutableTags) {
            this.repositoryName = repositoryName;
            this.accountId = accountId;
            this.maxImageCount = maxImageCount;
            this.retainRegistryOnDelete = retainRegistryOnDelete;
            this.inmutableTags = inmutableTags;
        }

        public static InputParametersBuilder builder() {
            return new InputParametersBuilder();
        }

        String getRepositoryName() {
            return this.repositoryName;
        }

        String getAccountId() {
            return this.accountId;
        }

        int getMaxImageCount() {
            return this.maxImageCount;
        }

        boolean isRetainRegistryOnDelete() {
            return this.retainRegistryOnDelete;
        }

        boolean isInmutableTags() {
            return this.inmutableTags;
        }

        public static class InputParametersBuilder {
            private String repositoryName;
            private String accountId;
            private boolean maxImageCount$set;
            private int maxImageCount$value;
            private boolean retainRegistryOnDelete$set;
            private boolean retainRegistryOnDelete$value;
            private boolean inmutableTags$set;
            private boolean inmutableTags$value;

            InputParametersBuilder() {
            }

            public InputParametersBuilder repositoryName(String repositoryName) {
                this.repositoryName = repositoryName;
                return this;
            }

            public InputParametersBuilder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            public InputParametersBuilder maxImageCount(int maxImageCount) {
                this.maxImageCount$value = maxImageCount;
                this.maxImageCount$set = true;
                return this;
            }

            public InputParametersBuilder retainRegistryOnDelete(boolean retainRegistryOnDelete) {
                this.retainRegistryOnDelete$value = retainRegistryOnDelete;
                this.retainRegistryOnDelete$set = true;
                return this;
            }

            public InputParametersBuilder inmutableTags(boolean inmutableTags) {
                this.inmutableTags$value = inmutableTags;
                this.inmutableTags$set = true;
                return this;
            }

            public InputParameters build() {
                int maxImageCount$value = this.maxImageCount$value;
                if (!this.maxImageCount$set) {
                    maxImageCount$value = InputParameters.$default$maxImageCount();
                }
                boolean retainRegistryOnDelete$value = this.retainRegistryOnDelete$value;
                if (!this.retainRegistryOnDelete$set) {
                    retainRegistryOnDelete$value = InputParameters.$default$retainRegistryOnDelete();
                }
                boolean inmutableTags$value = this.inmutableTags$value;
                if (!this.inmutableTags$set) {
                    inmutableTags$value = InputParameters.$default$inmutableTags();
                }
                return new InputParameters(this.repositoryName, this.accountId, maxImageCount$value, retainRegistryOnDelete$value, inmutableTags$value);
            }

            public String toString() {
                return "DockerRepository.InputParameters.InputParametersBuilder(repositoryName=" + this.repositoryName + ", accountId=" + this.accountId + ", maxImageCount$value=" + this.maxImageCount$value + ", retainRegistryOnDelete$value=" + this.retainRegistryOnDelete$value + ", inmutableTags$value=" + this.inmutableTags$value + ")";
            }
        }
    }
}

