/*
 * Decompiled with CFR 0.152.
 */
package org.wcdevs.blog.cdk;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.wcdevs.blog.cdk.ApplicationEnvironment;
import org.wcdevs.blog.cdk.Util;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.Stack;
import software.amazon.awscdk.StackProps;
import software.amazon.awscdk.services.events.targets.LambdaFunction;
import software.amazon.awscdk.services.lambda.AssetCode;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.Function;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.Runtime;
import software.amazon.awscdk.services.lambda.eventsources.SqsEventSource;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.awscdk.services.sqs.Queue;
import software.constructs.Construct;

public final class DeploymentSequencerStack
extends Stack {
    private static final String GITHUB_TOKEN_KEY = "GITHUB_TOKEN";
    private static final String QUEUE_URL_KEY = "QUEUE_URL";
    private static final String REGION_KEY = "REGION";
    private static final String FUNCTION_ID = "depSeqFun";

    private DeploymentSequencerStack(Construct scope, String id, StackProps props) {
        super(Objects.requireNonNull(scope), Objects.requireNonNull(id), Objects.requireNonNull(props));
    }

    public static DeploymentSequencerStack newInstance(Construct scope, Environment awsEnvironment, ApplicationEnvironment applicationEnvironment, InputParameters inputParameters) {
        InputParameters inParams = Objects.requireNonNull(inputParameters);
        ApplicationEnvironment appEnv = Objects.requireNonNull(applicationEnvironment);
        String name = appEnv.prefixed(Util.joinedString("-", "deployment", "seq", "stack"));
        StackProps stackProps = StackProps.builder().stackName(name).env(awsEnvironment).build();
        DeploymentSequencerStack stack = new DeploymentSequencerStack(scope, name, stackProps);
        String queueName = appEnv.prefixed(inParams.getQueueName());
        Queue deploymentQueue = Queue.Builder.create((Construct)stack, (String)queueName).queueName(queueName).fifo(Boolean.valueOf(inParams.isFifo())).build();
        SqsEventSource eventSource = SqsEventSource.Builder.create((IQueue)deploymentQueue).build();
        AssetCode code = Code.fromAsset((String)Objects.requireNonNull(inParams.getCodeDirectory()));
        Map<String, String> envVars = Map.of(inParams.getGithubTokenKey(), Objects.requireNonNull(inParams.getGithubToken()), inParams.getQueueUrlKey(), Objects.requireNonNull(deploymentQueue.getQueueUrl()), inParams.getRegionKey(), Objects.requireNonNull(awsEnvironment.getRegion()));
        FunctionProps functionProps = FunctionProps.builder().code((Code)code).runtime(inParams.getRuntime()).handler(inParams.getHandler()).logRetention(inParams.getLogRetentionDays()).reservedConcurrentExecutions((Number)inParams.getReservedConcurrentExecutions()).events(List.of(eventSource)).environment(envVars).build();
        String fnId = appEnv.prefixed(FUNCTION_ID);
        LambdaFunction.Builder.create((IFunction)new Function((Construct)stack, fnId, functionProps)).build();
        return stack;
    }

    public static class InputParameters {
        private static final String FIFO_SUFFIX = ".fifo";
        private static final String QUEUE_ID = "depQueue";
        private String codeDirectory;
        private String githubToken;
        private boolean fifo;
        private String queueName;
        private Runtime runtime;
        private String handler;
        private RetentionDays logRetentionDays;
        private int reservedConcurrentExecutions;
        private String githubTokenKey;
        private String queueUrlKey;
        private String regionKey;

        String getQueueName() {
            return this.queueName + this.suffix();
        }

        private String suffix() {
            return this.isFifo() ? FIFO_SUFFIX : "";
        }

        private static boolean $default$fifo() {
            return true;
        }

        private static String $default$queueName() {
            return QUEUE_ID;
        }

        private static Runtime $default$runtime() {
            return Runtime.NODEJS_12_X;
        }

        private static String $default$handler() {
            return "index.handler";
        }

        private static RetentionDays $default$logRetentionDays() {
            return RetentionDays.TWO_WEEKS;
        }

        private static int $default$reservedConcurrentExecutions() {
            return 1;
        }

        private static String $default$githubTokenKey() {
            return DeploymentSequencerStack.GITHUB_TOKEN_KEY;
        }

        private static String $default$queueUrlKey() {
            return DeploymentSequencerStack.QUEUE_URL_KEY;
        }

        private static String $default$regionKey() {
            return DeploymentSequencerStack.REGION_KEY;
        }

        InputParameters(String codeDirectory, String githubToken, boolean fifo, String queueName, Runtime runtime, String handler, RetentionDays logRetentionDays, int reservedConcurrentExecutions, String githubTokenKey, String queueUrlKey, String regionKey) {
            this.codeDirectory = codeDirectory;
            this.githubToken = githubToken;
            this.fifo = fifo;
            this.queueName = queueName;
            this.runtime = runtime;
            this.handler = handler;
            this.logRetentionDays = logRetentionDays;
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            this.githubTokenKey = githubTokenKey;
            this.queueUrlKey = queueUrlKey;
            this.regionKey = regionKey;
        }

        public static InputParametersBuilder builder() {
            return new InputParametersBuilder();
        }

        String getCodeDirectory() {
            return this.codeDirectory;
        }

        String getGithubToken() {
            return this.githubToken;
        }

        boolean isFifo() {
            return this.fifo;
        }

        Runtime getRuntime() {
            return this.runtime;
        }

        String getHandler() {
            return this.handler;
        }

        RetentionDays getLogRetentionDays() {
            return this.logRetentionDays;
        }

        int getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        String getGithubTokenKey() {
            return this.githubTokenKey;
        }

        String getQueueUrlKey() {
            return this.queueUrlKey;
        }

        String getRegionKey() {
            return this.regionKey;
        }

        public static class InputParametersBuilder {
            private String codeDirectory;
            private String githubToken;
            private boolean fifo$set;
            private boolean fifo$value;
            private boolean queueName$set;
            private String queueName$value;
            private boolean runtime$set;
            private Runtime runtime$value;
            private boolean handler$set;
            private String handler$value;
            private boolean logRetentionDays$set;
            private RetentionDays logRetentionDays$value;
            private boolean reservedConcurrentExecutions$set;
            private int reservedConcurrentExecutions$value;
            private boolean githubTokenKey$set;
            private String githubTokenKey$value;
            private boolean queueUrlKey$set;
            private String queueUrlKey$value;
            private boolean regionKey$set;
            private String regionKey$value;

            InputParametersBuilder() {
            }

            public InputParametersBuilder codeDirectory(String codeDirectory) {
                this.codeDirectory = codeDirectory;
                return this;
            }

            public InputParametersBuilder githubToken(String githubToken) {
                this.githubToken = githubToken;
                return this;
            }

            public InputParametersBuilder fifo(boolean fifo) {
                this.fifo$value = fifo;
                this.fifo$set = true;
                return this;
            }

            public InputParametersBuilder queueName(String queueName) {
                this.queueName$value = queueName;
                this.queueName$set = true;
                return this;
            }

            public InputParametersBuilder runtime(Runtime runtime) {
                this.runtime$value = runtime;
                this.runtime$set = true;
                return this;
            }

            public InputParametersBuilder handler(String handler) {
                this.handler$value = handler;
                this.handler$set = true;
                return this;
            }

            public InputParametersBuilder logRetentionDays(RetentionDays logRetentionDays) {
                this.logRetentionDays$value = logRetentionDays;
                this.logRetentionDays$set = true;
                return this;
            }

            public InputParametersBuilder reservedConcurrentExecutions(int reservedConcurrentExecutions) {
                this.reservedConcurrentExecutions$value = reservedConcurrentExecutions;
                this.reservedConcurrentExecutions$set = true;
                return this;
            }

            public InputParametersBuilder githubTokenKey(String githubTokenKey) {
                this.githubTokenKey$value = githubTokenKey;
                this.githubTokenKey$set = true;
                return this;
            }

            public InputParametersBuilder queueUrlKey(String queueUrlKey) {
                this.queueUrlKey$value = queueUrlKey;
                this.queueUrlKey$set = true;
                return this;
            }

            public InputParametersBuilder regionKey(String regionKey) {
                this.regionKey$value = regionKey;
                this.regionKey$set = true;
                return this;
            }

            public InputParameters build() {
                boolean fifo$value = this.fifo$value;
                if (!this.fifo$set) {
                    fifo$value = InputParameters.$default$fifo();
                }
                String queueName$value = this.queueName$value;
                if (!this.queueName$set) {
                    queueName$value = InputParameters.$default$queueName();
                }
                Runtime runtime$value = this.runtime$value;
                if (!this.runtime$set) {
                    runtime$value = InputParameters.$default$runtime();
                }
                String handler$value = this.handler$value;
                if (!this.handler$set) {
                    handler$value = InputParameters.$default$handler();
                }
                RetentionDays logRetentionDays$value = this.logRetentionDays$value;
                if (!this.logRetentionDays$set) {
                    logRetentionDays$value = InputParameters.$default$logRetentionDays();
                }
                int reservedConcurrentExecutions$value = this.reservedConcurrentExecutions$value;
                if (!this.reservedConcurrentExecutions$set) {
                    reservedConcurrentExecutions$value = InputParameters.$default$reservedConcurrentExecutions();
                }
                String githubTokenKey$value = this.githubTokenKey$value;
                if (!this.githubTokenKey$set) {
                    githubTokenKey$value = InputParameters.$default$githubTokenKey();
                }
                String queueUrlKey$value = this.queueUrlKey$value;
                if (!this.queueUrlKey$set) {
                    queueUrlKey$value = InputParameters.$default$queueUrlKey();
                }
                String regionKey$value = this.regionKey$value;
                if (!this.regionKey$set) {
                    regionKey$value = InputParameters.$default$regionKey();
                }
                return new InputParameters(this.codeDirectory, this.githubToken, fifo$value, queueName$value, runtime$value, handler$value, logRetentionDays$value, reservedConcurrentExecutions$value, githubTokenKey$value, queueUrlKey$value, regionKey$value);
            }

            public String toString() {
                return "DeploymentSequencerStack.InputParameters.InputParametersBuilder(codeDirectory=" + this.codeDirectory + ", githubToken=" + this.githubToken + ", fifo$value=" + this.fifo$value + ", queueName$value=" + this.queueName$value + ", runtime$value=" + this.runtime$value + ", handler$value=" + this.handler$value + ", logRetentionDays$value=" + this.logRetentionDays$value + ", reservedConcurrentExecutions$value=" + this.reservedConcurrentExecutions$value + ", githubTokenKey$value=" + this.githubTokenKey$value + ", queueUrlKey$value=" + this.queueUrlKey$value + ", regionKey$value=" + this.regionKey$value + ")";
            }
        }
    }
}

