/*
 * Decompiled with CFR 0.152.
 */
package org.wcdevs.blog.cdk;

import java.util.List;
import java.util.Objects;
import org.wcdevs.blog.cdk.ApplicationEnvironment;
import org.wcdevs.blog.cdk.Network;
import org.wcdevs.blog.cdk.Util;
import software.amazon.awscdk.services.ec2.CfnSecurityGroup;
import software.amazon.awscdk.services.rds.CfnDBInstance;
import software.amazon.awscdk.services.rds.CfnDBSubnetGroup;
import software.amazon.awscdk.services.rds.StorageType;
import software.amazon.awscdk.services.secretsmanager.CfnSecretTargetAttachment;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.Secret;
import software.amazon.awscdk.services.secretsmanager.SecretStringGenerator;
import software.amazon.awscdk.services.ssm.StringParameter;
import software.constructs.Construct;
import software.constructs.IConstruct;

public final class Database
extends Construct {
    private static final String TARGET_TYPE_AWS_RDS_DB_INSTANCE = "AWS::RDS::DBInstance";
    private static final String CONSTRUCT_NAME = "Database";
    private static final String DASH_JOINER = "-";
    private static final String PARAM_ENDPOINT_ADDRESS = "endpointAddress";
    private static final String PARAM_ENDPOINT_PORT = "endpointPort";
    private static final String PARAM_DATABASE_NAME = "databaseName";
    private static final String PARAM_SECURITY_GROUP_ID = "securityGroupId";
    private static final String PARAM_SECRET_ARN = "secretArn";
    private static final String DATABASE_SECRET = "databaseSecret";
    public static final String USERNAME_SECRET_HOLDER = "username";
    public static final String PASSWORD_SECRET_HOLDER = "password";
    private CfnSecurityGroup dbSecurityGroup;
    private Secret dbSecret;
    private CfnDBInstance dbInstance;

    private Database(Construct scope, String id) {
        super(scope, id);
    }

    public static Database newInstance(Construct scope, String id, ApplicationEnvironment applicationEnvironment, InputParameters inputParameters) {
        InputParameters inParams = Objects.requireNonNull(inputParameters);
        Database database = new Database(Objects.requireNonNull(scope), Objects.requireNonNull(id));
        Network.OutputParameters netOutParams = Network.outputParametersFrom(database, applicationEnvironment);
        List<String> availabilityZones = netOutParams.getAvailabilityZones();
        if (availabilityZones == null || availabilityZones.isEmpty()) {
            throw new IllegalArgumentException("No availability zones in network");
        }
        String vpcId = netOutParams.getVpcId();
        if (vpcId == null) {
            throw new IllegalArgumentException("No VPC in network");
        }
        CfnSecurityGroup secGroup = Database.cfnSecurityGroup(database, vpcId, applicationEnvironment.prefixed("databaseSecurityGroup"));
        database.setDbSecurityGroup(secGroup);
        String username = Util.dbSanitized(applicationEnvironment.prefixed("dbuser"));
        Secret dbSecret = Database.dbSecret(database, applicationEnvironment.prefixed(DATABASE_SECRET), username);
        database.setDbSecret(dbSecret);
        String subnetGroupName = applicationEnvironment.prefixed("databaseSubnetGroup");
        CfnDBSubnetGroup subnetGroup = Database.cfnDBSubnetGroup(database, subnetGroupName, netOutParams.getIsolatedSubnets());
        subnetGroupName = subnetGroup.getDbSubnetGroupName();
        String dbName = Util.dbSanitized(applicationEnvironment.prefixed("database"));
        String dbPassword = dbSecret.secretValueFromJson(PASSWORD_SECRET_HOLDER).toString();
        CfnDBInstance dbInstance = Database.dbInstance(database, inParams, availabilityZones.get(0), subnetGroupName, dbName, username, dbPassword, secGroup.getAttrGroupId());
        database.setDbInstance(dbInstance);
        Database.cfnSecretTargetAttachment(database, dbSecret.getSecretArn(), dbInstance.getRef());
        Database.saveDatabaseInfoToParameterStore(database, applicationEnvironment);
        applicationEnvironment.tag((IConstruct)database);
        return database;
    }

    private static CfnSecurityGroup cfnSecurityGroup(Construct scope, String vpcId, String securityGroupName) {
        return CfnSecurityGroup.Builder.create((Construct)scope, (String)"databaseSecurityGroup").vpcId(vpcId).groupDescription("Database security group").groupName(securityGroupName).build();
    }

    private static Secret dbSecret(Construct scope, String secretName, String username) {
        String secretTemplate = String.format("{\"%s\":\"%s\"}", USERNAME_SECRET_HOLDER, username);
        SecretStringGenerator secretString = SecretStringGenerator.builder().secretStringTemplate(secretTemplate).generateStringKey(PASSWORD_SECRET_HOLDER).passwordLength((Number)37).excludeCharacters("@/\\\" ").build();
        return Secret.Builder.create((Construct)scope, (String)DATABASE_SECRET).secretName(secretName).description("Credentials to be used by the RDB (Database) instance").generateSecretString(secretString).build();
    }

    private static CfnDBSubnetGroup cfnDBSubnetGroup(Construct scope, String subnetGroupName, List<String> subnetIds) {
        if (subnetIds.size() < 2) {
            throw new IllegalArgumentException("Subnet groups must contain at least two subnets in two different Availability Zones in the same region. More info at https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Subnets");
        }
        return CfnDBSubnetGroup.Builder.create((Construct)scope, (String)"databaseSubnetGroup").dbSubnetGroupDescription("RDB subnet group").dbSubnetGroupName(subnetGroupName).subnetIds(subnetIds).build();
    }

    private static CfnDBInstance dbInstance(Construct scope, InputParameters inParams, String availabilityZone, String subnetGroupName, String dbName, String dbUsername, String dbPassword, String securityGroupId) {
        return CfnDBInstance.Builder.create((Construct)scope, (String)"databaseInstance").allocatedStorage(inParams.getStorageCapacityInGBString()).availabilityZone(availabilityZone).dbInstanceClass(inParams.getInstanceClass()).dbName(dbName).dbSubnetGroupName(subnetGroupName).engine(inParams.getEngine()).engineVersion(inParams.getEngineVersion()).masterUsername(dbUsername).masterUserPassword(dbPassword).publiclyAccessible(Boolean.valueOf(inParams.isPubliclyAccessible())).vpcSecurityGroups(List.of(securityGroupId)).deletionProtection(Boolean.valueOf(inParams.isProtectedAgainstDeletion())).autoMinorVersionUpgrade(Boolean.valueOf(inParams.isMinorVersionAutoUpgradeEnabled())).enablePerformanceInsights(Boolean.valueOf(inParams.isPerformanceInsightsEnabled())).storageEncrypted(Boolean.valueOf(inParams.isEncryptionEnabled())).port(inParams.getPort()).storageType(inParams.getStorageType().name()).backupRetentionPeriod(inParams.getBackUpRetentionPeriodInDays()).deleteAutomatedBackups(Boolean.valueOf(inParams.isDeleteAutomatedBackupsEnabled())).build();
    }

    private static CfnSecretTargetAttachment cfnSecretTargetAttachment(Construct scope, String dbSecretArn, String dbRef) {
        return CfnSecretTargetAttachment.Builder.create((Construct)scope, (String)"databaseSecretTargetAttachment").secretId(dbSecretArn).targetId(dbRef).targetType(TARGET_TYPE_AWS_RDS_DB_INSTANCE).build();
    }

    private static void saveDatabaseInfoToParameterStore(Database database, ApplicationEnvironment appEnvironment) {
        Database.createStringParameter(database, appEnvironment, PARAM_ENDPOINT_ADDRESS, database.getDbInstance().getAttrEndpointAddress());
        Database.createStringParameter(database, appEnvironment, PARAM_ENDPOINT_PORT, database.getDbInstance().getAttrEndpointPort());
        Database.createStringParameter(database, appEnvironment, PARAM_DATABASE_NAME, database.getDbInstance().getDbName());
        Database.createStringParameter(database, appEnvironment, PARAM_SECURITY_GROUP_ID, database.getDbSecurityGroup().getAttrGroupId());
        Database.createStringParameter(database, appEnvironment, PARAM_SECRET_ARN, database.getDbSecret().getSecretArn());
    }

    private static void createStringParameter(Construct scope, ApplicationEnvironment appEnvironment, String id, String stringValue) {
        StringParameter.Builder.create((Construct)scope, (String)id).parameterName(Database.parameterName(appEnvironment, id)).stringValue(stringValue).build();
    }

    private static String parameterName(ApplicationEnvironment appEnvironment, String parameterName) {
        return Util.joinedString(DASH_JOINER, appEnvironment.getEnvironmentName(), appEnvironment.getApplicationName(), CONSTRUCT_NAME, parameterName);
    }

    public static ISecret getDataBaseSecret(Construct scope, OutputParameters outParams) {
        return Secret.fromSecretCompleteArn((Construct)scope, (String)DATABASE_SECRET, (String)Objects.requireNonNull(outParams.getDbSecretArn()));
    }

    public static String getParameter(Construct scope, ApplicationEnvironment appEnvironment, String id) {
        String parameterName = Database.parameterName(appEnvironment, id);
        return StringParameter.fromStringParameterName((Construct)scope, (String)id, (String)parameterName).getStringValue();
    }

    public static String getDbEndpointAddress(Construct scope, ApplicationEnvironment appEnvironment) {
        return Database.getParameter(scope, appEnvironment, PARAM_ENDPOINT_ADDRESS);
    }

    public static String getDbEndpointPort(Construct scope, ApplicationEnvironment appEnvironment) {
        return Database.getParameter(scope, appEnvironment, PARAM_ENDPOINT_PORT);
    }

    public static String getDbName(Construct scope, ApplicationEnvironment appEnvironment) {
        return Database.getParameter(scope, appEnvironment, PARAM_DATABASE_NAME);
    }

    public static String getDbSecretArn(Construct scope, ApplicationEnvironment appEnvironment) {
        return Database.getParameter(scope, appEnvironment, PARAM_SECRET_ARN);
    }

    public static String getDbSecurityGroupId(Construct scope, ApplicationEnvironment appEnvironment) {
        return Database.getParameter(scope, appEnvironment, PARAM_SECURITY_GROUP_ID);
    }

    public static OutputParameters outputParametersFrom(Construct scope, ApplicationEnvironment appEnvironment) {
        return new OutputParameters(Database.getDbEndpointAddress(scope, appEnvironment), Database.getDbEndpointPort(scope, appEnvironment), Database.getDbName(scope, appEnvironment), Database.getDbSecretArn(scope, appEnvironment), Database.getDbSecurityGroupId(scope, appEnvironment));
    }

    private void setDbSecurityGroup(CfnSecurityGroup dbSecurityGroup) {
        this.dbSecurityGroup = dbSecurityGroup;
    }

    private void setDbSecret(Secret dbSecret) {
        this.dbSecret = dbSecret;
    }

    private void setDbInstance(CfnDBInstance dbInstance) {
        this.dbInstance = dbInstance;
    }

    CfnSecurityGroup getDbSecurityGroup() {
        return this.dbSecurityGroup;
    }

    Secret getDbSecret() {
        return this.dbSecret;
    }

    CfnDBInstance getDbInstance() {
        return this.dbInstance;
    }

    public static final class InputParameters {
        public static final String ENGINE_POSTGRES = "postgres";
        public static final String DEFAULT_ENGINE_VERSION = "12.8";
        public static final String DEFAULT_INSTANCE_CLASS = "db.t2.micro";
        public static final StorageType SSD = StorageType.GP2;
        public static final StorageType MAGNETIC = StorageType.STANDARD;
        public static final StorageType PROVISIONED_IOPS = StorageType.IO1;
        private static final StorageType DEFAULT_STORAGE_TYPE = SSD;
        private int storageCapacityInGB;
        private String instanceClass;
        private String engine;
        private String engineVersion;
        private boolean publiclyAccessible;
        private boolean protectedAgainstDeletion;
        private boolean minorVersionAutoUpgradeEnabled;
        private boolean performanceInsightsEnabled;
        private boolean encryptionEnabled;
        private int portNumber;
        private StorageType storageType;
        private Number backUpRetentionPeriodInDays;
        private boolean deleteAutomatedBackupsEnabled;

        String getStorageCapacityInGBString() {
            return String.valueOf(this.storageCapacityInGB);
        }

        String getPort() {
            return String.valueOf(this.portNumber);
        }

        private static int $default$storageCapacityInGB() {
            return 10;
        }

        private static String $default$instanceClass() {
            return DEFAULT_INSTANCE_CLASS;
        }

        private static String $default$engine() {
            return ENGINE_POSTGRES;
        }

        private static String $default$engineVersion() {
            return DEFAULT_ENGINE_VERSION;
        }

        private static boolean $default$minorVersionAutoUpgradeEnabled() {
            return true;
        }

        private static int $default$portNumber() {
            return 5432;
        }

        private static StorageType $default$storageType() {
            return DEFAULT_STORAGE_TYPE;
        }

        private static Number $default$backUpRetentionPeriodInDays() {
            return 1;
        }

        private static boolean $default$deleteAutomatedBackupsEnabled() {
            return true;
        }

        InputParameters(int storageCapacityInGB, String instanceClass, String engine, String engineVersion, boolean publiclyAccessible, boolean protectedAgainstDeletion, boolean minorVersionAutoUpgradeEnabled, boolean performanceInsightsEnabled, boolean encryptionEnabled, int portNumber, StorageType storageType, Number backUpRetentionPeriodInDays, boolean deleteAutomatedBackupsEnabled) {
            this.storageCapacityInGB = storageCapacityInGB;
            this.instanceClass = instanceClass;
            this.engine = engine;
            this.engineVersion = engineVersion;
            this.publiclyAccessible = publiclyAccessible;
            this.protectedAgainstDeletion = protectedAgainstDeletion;
            this.minorVersionAutoUpgradeEnabled = minorVersionAutoUpgradeEnabled;
            this.performanceInsightsEnabled = performanceInsightsEnabled;
            this.encryptionEnabled = encryptionEnabled;
            this.portNumber = portNumber;
            this.storageType = storageType;
            this.backUpRetentionPeriodInDays = backUpRetentionPeriodInDays;
            this.deleteAutomatedBackupsEnabled = deleteAutomatedBackupsEnabled;
        }

        public static InputParametersBuilder builder() {
            return new InputParametersBuilder();
        }

        int getStorageCapacityInGB() {
            return this.storageCapacityInGB;
        }

        String getInstanceClass() {
            return this.instanceClass;
        }

        String getEngine() {
            return this.engine;
        }

        String getEngineVersion() {
            return this.engineVersion;
        }

        boolean isPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        boolean isProtectedAgainstDeletion() {
            return this.protectedAgainstDeletion;
        }

        boolean isMinorVersionAutoUpgradeEnabled() {
            return this.minorVersionAutoUpgradeEnabled;
        }

        boolean isPerformanceInsightsEnabled() {
            return this.performanceInsightsEnabled;
        }

        boolean isEncryptionEnabled() {
            return this.encryptionEnabled;
        }

        int getPortNumber() {
            return this.portNumber;
        }

        StorageType getStorageType() {
            return this.storageType;
        }

        Number getBackUpRetentionPeriodInDays() {
            return this.backUpRetentionPeriodInDays;
        }

        boolean isDeleteAutomatedBackupsEnabled() {
            return this.deleteAutomatedBackupsEnabled;
        }

        public static class InputParametersBuilder {
            private boolean storageCapacityInGB$set;
            private int storageCapacityInGB$value;
            private boolean instanceClass$set;
            private String instanceClass$value;
            private boolean engine$set;
            private String engine$value;
            private boolean engineVersion$set;
            private String engineVersion$value;
            private boolean publiclyAccessible;
            private boolean protectedAgainstDeletion;
            private boolean minorVersionAutoUpgradeEnabled$set;
            private boolean minorVersionAutoUpgradeEnabled$value;
            private boolean performanceInsightsEnabled;
            private boolean encryptionEnabled;
            private boolean portNumber$set;
            private int portNumber$value;
            private boolean storageType$set;
            private StorageType storageType$value;
            private boolean backUpRetentionPeriodInDays$set;
            private Number backUpRetentionPeriodInDays$value;
            private boolean deleteAutomatedBackupsEnabled$set;
            private boolean deleteAutomatedBackupsEnabled$value;

            InputParametersBuilder() {
            }

            public InputParametersBuilder storageCapacityInGB(int storageCapacityInGB) {
                this.storageCapacityInGB$value = storageCapacityInGB;
                this.storageCapacityInGB$set = true;
                return this;
            }

            public InputParametersBuilder instanceClass(String instanceClass) {
                this.instanceClass$value = instanceClass;
                this.instanceClass$set = true;
                return this;
            }

            public InputParametersBuilder engine(String engine) {
                this.engine$value = engine;
                this.engine$set = true;
                return this;
            }

            public InputParametersBuilder engineVersion(String engineVersion) {
                this.engineVersion$value = engineVersion;
                this.engineVersion$set = true;
                return this;
            }

            public InputParametersBuilder publiclyAccessible(boolean publiclyAccessible) {
                this.publiclyAccessible = publiclyAccessible;
                return this;
            }

            public InputParametersBuilder protectedAgainstDeletion(boolean protectedAgainstDeletion) {
                this.protectedAgainstDeletion = protectedAgainstDeletion;
                return this;
            }

            public InputParametersBuilder minorVersionAutoUpgradeEnabled(boolean minorVersionAutoUpgradeEnabled) {
                this.minorVersionAutoUpgradeEnabled$value = minorVersionAutoUpgradeEnabled;
                this.minorVersionAutoUpgradeEnabled$set = true;
                return this;
            }

            public InputParametersBuilder performanceInsightsEnabled(boolean performanceInsightsEnabled) {
                this.performanceInsightsEnabled = performanceInsightsEnabled;
                return this;
            }

            public InputParametersBuilder encryptionEnabled(boolean encryptionEnabled) {
                this.encryptionEnabled = encryptionEnabled;
                return this;
            }

            public InputParametersBuilder portNumber(int portNumber) {
                this.portNumber$value = portNumber;
                this.portNumber$set = true;
                return this;
            }

            public InputParametersBuilder storageType(StorageType storageType) {
                this.storageType$value = storageType;
                this.storageType$set = true;
                return this;
            }

            public InputParametersBuilder backUpRetentionPeriodInDays(Number backUpRetentionPeriodInDays) {
                this.backUpRetentionPeriodInDays$value = backUpRetentionPeriodInDays;
                this.backUpRetentionPeriodInDays$set = true;
                return this;
            }

            public InputParametersBuilder deleteAutomatedBackupsEnabled(boolean deleteAutomatedBackupsEnabled) {
                this.deleteAutomatedBackupsEnabled$value = deleteAutomatedBackupsEnabled;
                this.deleteAutomatedBackupsEnabled$set = true;
                return this;
            }

            public InputParameters build() {
                int storageCapacityInGB$value = this.storageCapacityInGB$value;
                if (!this.storageCapacityInGB$set) {
                    storageCapacityInGB$value = InputParameters.$default$storageCapacityInGB();
                }
                String instanceClass$value = this.instanceClass$value;
                if (!this.instanceClass$set) {
                    instanceClass$value = InputParameters.$default$instanceClass();
                }
                String engine$value = this.engine$value;
                if (!this.engine$set) {
                    engine$value = InputParameters.$default$engine();
                }
                String engineVersion$value = this.engineVersion$value;
                if (!this.engineVersion$set) {
                    engineVersion$value = InputParameters.$default$engineVersion();
                }
                boolean minorVersionAutoUpgradeEnabled$value = this.minorVersionAutoUpgradeEnabled$value;
                if (!this.minorVersionAutoUpgradeEnabled$set) {
                    minorVersionAutoUpgradeEnabled$value = InputParameters.$default$minorVersionAutoUpgradeEnabled();
                }
                int portNumber$value = this.portNumber$value;
                if (!this.portNumber$set) {
                    portNumber$value = InputParameters.$default$portNumber();
                }
                StorageType storageType$value = this.storageType$value;
                if (!this.storageType$set) {
                    storageType$value = InputParameters.$default$storageType();
                }
                Number backUpRetentionPeriodInDays$value = this.backUpRetentionPeriodInDays$value;
                if (!this.backUpRetentionPeriodInDays$set) {
                    backUpRetentionPeriodInDays$value = InputParameters.$default$backUpRetentionPeriodInDays();
                }
                boolean deleteAutomatedBackupsEnabled$value = this.deleteAutomatedBackupsEnabled$value;
                if (!this.deleteAutomatedBackupsEnabled$set) {
                    deleteAutomatedBackupsEnabled$value = InputParameters.$default$deleteAutomatedBackupsEnabled();
                }
                return new InputParameters(storageCapacityInGB$value, instanceClass$value, engine$value, engineVersion$value, this.publiclyAccessible, this.protectedAgainstDeletion, minorVersionAutoUpgradeEnabled$value, this.performanceInsightsEnabled, this.encryptionEnabled, portNumber$value, storageType$value, backUpRetentionPeriodInDays$value, deleteAutomatedBackupsEnabled$value);
            }

            public String toString() {
                return "Database.InputParameters.InputParametersBuilder(storageCapacityInGB$value=" + this.storageCapacityInGB$value + ", instanceClass$value=" + this.instanceClass$value + ", engine$value=" + this.engine$value + ", engineVersion$value=" + this.engineVersion$value + ", publiclyAccessible=" + this.publiclyAccessible + ", protectedAgainstDeletion=" + this.protectedAgainstDeletion + ", minorVersionAutoUpgradeEnabled$value=" + this.minorVersionAutoUpgradeEnabled$value + ", performanceInsightsEnabled=" + this.performanceInsightsEnabled + ", encryptionEnabled=" + this.encryptionEnabled + ", portNumber$value=" + this.portNumber$value + ", storageType$value=" + this.storageType$value + ", backUpRetentionPeriodInDays$value=" + this.backUpRetentionPeriodInDays$value + ", deleteAutomatedBackupsEnabled$value=" + this.deleteAutomatedBackupsEnabled$value + ")";
            }
        }
    }

    public static final class OutputParameters {
        private final String endpointAddress;
        private final String endpointPort;
        private final String dbName;
        private final String dbSecretArn;
        private final String dbSecurityGroupId;

        public String getEndpointAddress() {
            return this.endpointAddress;
        }

        public String getEndpointPort() {
            return this.endpointPort;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getDbSecretArn() {
            return this.dbSecretArn;
        }

        public String getDbSecurityGroupId() {
            return this.dbSecurityGroupId;
        }

        OutputParameters(String endpointAddress, String endpointPort, String dbName, String dbSecretArn, String dbSecurityGroupId) {
            this.endpointAddress = endpointAddress;
            this.endpointPort = endpointPort;
            this.dbName = dbName;
            this.dbSecretArn = dbSecretArn;
            this.dbSecurityGroupId = dbSecurityGroupId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OutputParameters)) {
                return false;
            }
            OutputParameters other = (OutputParameters)o;
            String this$endpointAddress = this.getEndpointAddress();
            String other$endpointAddress = other.getEndpointAddress();
            if (this$endpointAddress == null ? other$endpointAddress != null : !this$endpointAddress.equals(other$endpointAddress)) {
                return false;
            }
            String this$endpointPort = this.getEndpointPort();
            String other$endpointPort = other.getEndpointPort();
            if (this$endpointPort == null ? other$endpointPort != null : !this$endpointPort.equals(other$endpointPort)) {
                return false;
            }
            String this$dbName = this.getDbName();
            String other$dbName = other.getDbName();
            if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
                return false;
            }
            String this$dbSecretArn = this.getDbSecretArn();
            String other$dbSecretArn = other.getDbSecretArn();
            if (this$dbSecretArn == null ? other$dbSecretArn != null : !this$dbSecretArn.equals(other$dbSecretArn)) {
                return false;
            }
            String this$dbSecurityGroupId = this.getDbSecurityGroupId();
            String other$dbSecurityGroupId = other.getDbSecurityGroupId();
            return !(this$dbSecurityGroupId == null ? other$dbSecurityGroupId != null : !this$dbSecurityGroupId.equals(other$dbSecurityGroupId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $endpointAddress = this.getEndpointAddress();
            result = result * 59 + ($endpointAddress == null ? 43 : $endpointAddress.hashCode());
            String $endpointPort = this.getEndpointPort();
            result = result * 59 + ($endpointPort == null ? 43 : $endpointPort.hashCode());
            String $dbName = this.getDbName();
            result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
            String $dbSecretArn = this.getDbSecretArn();
            result = result * 59 + ($dbSecretArn == null ? 43 : $dbSecretArn.hashCode());
            String $dbSecurityGroupId = this.getDbSecurityGroupId();
            result = result * 59 + ($dbSecurityGroupId == null ? 43 : $dbSecurityGroupId.hashCode());
            return result;
        }
    }
}

