/*
 * Decompiled with CFR 0.152.
 */
package org.wcdevs.blog.cdk;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wcdevs.blog.cdk.ApplicationEnvironment;
import org.wcdevs.blog.cdk.Util;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.Stack;
import software.amazon.awscdk.StackProps;
import software.amazon.awscdk.customresources.AwsCustomResource;
import software.amazon.awscdk.customresources.AwsCustomResourcePolicy;
import software.amazon.awscdk.customresources.AwsSdkCall;
import software.amazon.awscdk.customresources.PhysicalResourceId;
import software.amazon.awscdk.customresources.SdkCallsPolicyOptions;
import software.amazon.awscdk.services.cognito.AccountRecovery;
import software.amazon.awscdk.services.cognito.AutoVerifiedAttrs;
import software.amazon.awscdk.services.cognito.CognitoDomainOptions;
import software.amazon.awscdk.services.cognito.IUserPool;
import software.amazon.awscdk.services.cognito.Mfa;
import software.amazon.awscdk.services.cognito.OAuthFlows;
import software.amazon.awscdk.services.cognito.OAuthScope;
import software.amazon.awscdk.services.cognito.OAuthSettings;
import software.amazon.awscdk.services.cognito.PasswordPolicy;
import software.amazon.awscdk.services.cognito.SignInAliases;
import software.amazon.awscdk.services.cognito.StandardAttribute;
import software.amazon.awscdk.services.cognito.StandardAttributes;
import software.amazon.awscdk.services.cognito.UserPool;
import software.amazon.awscdk.services.cognito.UserPoolClient;
import software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider;
import software.amazon.awscdk.services.cognito.UserPoolDomain;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.Secret;
import software.amazon.awscdk.services.secretsmanager.SecretStringGenerator;
import software.amazon.awscdk.services.ssm.StringParameter;
import software.constructs.Construct;

public final class CognitoStack
extends Stack {
    static final String DEFAULT_COGNITO_LOGOUT_URL_TPL = "https://%s.auth.%s.amazoncognito.com/logout";
    private static final String DEFAULT_COGNITO_OAUTH_LOGIN_URL_TEMPLATE = "%s/login/oauth2/code/cognito";
    private static final String PARAM_USER_POOL_CLIENT_SECRET_ARN = "userPoolClientSecretArn";
    private static final String PARAM_USER_POOL_LOGOUT_URL = "userPoolLogoutUrl";
    private static final String PARAM_USER_POOL_PROVIDER_URL = "userPoolProviderUrl";
    private static final String CONSTRUCT_NAME = "cognito-stack";
    public static final String USER_POOL_CLIENT_SECRET_HOLDER = "userPoolClientSecret";
    public static final String USER_POOL_ID_HOLDER = "userPoolId";
    public static final String USER_POOL_CLIENT_ID_HOLDER = "userPoolClientId";
    public static final String USER_POOL_CLIENT_NAME_HOLDER = "userPoolClientName";

    private CognitoStack(Construct scope, String id, StackProps props) {
        super(scope, id, props);
    }

    public static CognitoStack newInstance(Construct scope, Environment awsEnvironment, String environmentName, InputParameters inputParameters) {
        InputParameters inParams = Objects.requireNonNull(inputParameters);
        String region = Objects.requireNonNull(awsEnvironment.getRegion());
        String envName = Objects.requireNonNull(environmentName);
        String stackName = Util.joinedString("-", envName, CONSTRUCT_NAME);
        StackProps cognitoProps = StackProps.builder().stackName(stackName).env(awsEnvironment).build();
        CognitoStack cognitoStack = new CognitoStack(scope, stackName, cognitoProps);
        UserPool userPool = CognitoStack.userPool(cognitoStack, inParams, envName);
        CognitoStack.createUserPoolDomain(cognitoStack, (IUserPool)userPool, inParams);
        String clientsSecretBaseName = Util.joinedString("-", envName, USER_POOL_CLIENT_SECRET_HOLDER);
        CognitoStack.createUserPoolClients(cognitoStack, (IUserPool)userPool, inParams.getUserPoolClientConfigurations()).forEach(clientWrapper -> {
            String secretArn = CognitoStack.createUserPoolClientSecret(cognitoStack, region, userPool.getUserPoolId(), clientWrapper, clientsSecretBaseName);
            String clientName = clientWrapper.getClient().getUserPoolClientName();
            String arnParamHolder = CognitoStack.clientSecretArnParamHolder(clientName);
            CognitoStack.createStringParameter(cognitoStack, envName, arnParamHolder, secretArn);
        });
        CognitoStack.createStringParameter(cognitoStack, envName, PARAM_USER_POOL_LOGOUT_URL, inParams.getFullLogoutUrlForRegion(region));
        CognitoStack.createStringParameter(cognitoStack, envName, PARAM_USER_POOL_PROVIDER_URL, userPool.getUserPoolProviderUrl());
        return cognitoStack;
    }

    private static Stream<UserPoolClientWrapper> createUserPoolClients(Stack scope, IUserPool userPool, Collection<UserPoolClientParameter> clientParams) {
        return clientParams.stream().map(clientParam -> CognitoStack.userPoolClient(scope, userPool, clientParam));
    }

    private static String clientSecretArnParamHolder(String userPoolClientName) {
        return PARAM_USER_POOL_CLIENT_SECRET_ARN + userPoolClientName;
    }

    private static String clientName(String applicationName) {
        return Util.joinedString("-", applicationName, "up", "client");
    }

    private static UserPool userPool(Stack scope, InputParameters inParams, String environment) {
        AutoVerifiedAttrs autoVerifyEmail = AutoVerifiedAttrs.builder().email(Boolean.valueOf(inParams.isSignInAutoVerifyEmail())).phone(Boolean.valueOf(inParams.isSignInAutoVerifyPhone())).build();
        SignInAliases signInAliases = SignInAliases.builder().username(Boolean.valueOf(inParams.isSignInAliasUsername())).email(Boolean.valueOf(inParams.isSignInAliasEmail())).phone(Boolean.valueOf(inParams.isSignInAliasPhone())).build();
        StandardAttribute signInEmailAttributes = StandardAttribute.builder().required(Boolean.valueOf(inParams.isSignInEmailRequired())).mutable(Boolean.valueOf(inParams.isSignInEmailMutable())).build();
        StandardAttribute signInPhoneAttributes = StandardAttribute.builder().required(Boolean.valueOf(inParams.isSignInPhoneRequired())).mutable(Boolean.valueOf(inParams.isSignInPhoneMutable())).build();
        StandardAttributes signInAttributes = StandardAttributes.builder().email(signInEmailAttributes).phoneNumber(signInPhoneAttributes).build();
        Duration tempPasswordValidityDays = Duration.days((Number)inParams.getTempPasswordValidityInDays());
        PasswordPolicy passwordPolicy = PasswordPolicy.builder().requireLowercase(Boolean.valueOf(inParams.isPasswordRequireLowercase())).requireDigits(Boolean.valueOf(inParams.isPasswordRequireDigits())).requireSymbols(Boolean.valueOf(inParams.isPasswordRequireSymbols())).requireUppercase(Boolean.valueOf(inParams.isPasswordRequireUppercase())).minLength((Number)inParams.getPasswordMinLength()).tempPasswordValidity(tempPasswordValidityDays).build();
        return UserPool.Builder.create((Construct)scope, (String)"userPool").userPoolName(Util.joinedString("-", environment, "user-pool")).selfSignUpEnabled(Boolean.valueOf(inParams.isSelfSignUpEnabled())).accountRecovery(inParams.getAccountRecovery()).autoVerify(autoVerifyEmail).signInAliases(signInAliases).signInCaseSensitive(Boolean.valueOf(inParams.isSignInCaseSensitive())).standardAttributes(signInAttributes).mfa(inParams.getMfa()).passwordPolicy(passwordPolicy).build();
    }

    private static UserPoolClientWrapper userPoolClient(Stack scope, IUserPool userPool, UserPoolClientParameter clientParam) {
        OAuthSettings.Builder oauthBuilder = OAuthSettings.builder();
        if (!clientParam.isOauthDisabled()) {
            List callbacks = CognitoStack.join(clientParam.getUserPoolOauthCallBackUrls(), Optional.ofNullable(clientParam.getAppLoginUrl()).orElse("")).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
            oauthBuilder.callbackUrls(callbacks).logoutUrls(List.of(clientParam.getApplicationUrl()));
            if (clientParam.isThereAScopeConfigured()) {
                oauthBuilder.scopes(clientParam.getScopes());
            }
            if (clientParam.isThereAFlowEnabled()) {
                oauthBuilder.flows(OAuthFlows.builder().authorizationCodeGrant(Boolean.valueOf(clientParam.isFlowAuthorizationCodeGrantEnabled())).implicitCodeGrant(Boolean.valueOf(clientParam.isFlowImplicitCodeGrantEnabled())).clientCredentials(Boolean.valueOf(clientParam.isFlowClientCredentialsEnabled())).build());
            }
        }
        List<UserPoolClientIdentityProvider> identityProviders = CognitoStack.join(clientParam.getUserPoolSuppoertedIdentityProviders(), UserPoolClientIdentityProvider.COGNITO);
        String clientName = CognitoStack.clientName(clientParam.getApplicationName());
        UserPoolClient.Builder builder = UserPoolClient.Builder.create((Construct)scope, (String)("userPoolClient" + clientName)).userPoolClientName(clientName).generateSecret(Boolean.valueOf(clientParam.isGenerateSecretEnabled())).userPool(userPool).supportedIdentityProviders(identityProviders).accessTokenValidity(clientParam.getAccessTokenValidity()).idTokenValidity(clientParam.getIdTokenValidity()).refreshTokenValidity(clientParam.getRefreshTokenValidity()).enableTokenRevocation(Boolean.valueOf(clientParam.isTokenRevocationEnabled())).preventUserExistenceErrors(Boolean.valueOf(clientParam.isReturnGenericErrorOnLoginFailed()));
        UserPoolClient userPoolClient = clientParam.isOauthDisabled() ? builder.disableOAuth(Boolean.valueOf(true)).build() : builder.oAuth(oauthBuilder.build()).build();
        return new UserPoolClientWrapper(userPoolClient, clientParam.isGenerateSecretEnabled());
    }

    private static void createUserPoolDomain(Stack scope, IUserPool userPool, InputParameters inParams) {
        CognitoDomainOptions cognitoDomain = CognitoDomainOptions.builder().domainPrefix(inParams.getLoginPageDomainPrefix()).build();
        UserPoolDomain.Builder.create((Construct)scope, (String)"userPoolDomain").userPool(userPool).cognitoDomain(cognitoDomain).build();
    }

    private static void createStringParameter(Stack scope, String envName, String id, String value) {
        StringParameter.Builder.create((Construct)scope, (String)CognitoStack.parameterId(id)).parameterName(CognitoStack.createParameterName(envName, id)).stringValue(value).build();
    }

    private static String parameterId(String id) {
        return Util.joinedString("-", CONSTRUCT_NAME, "param", id);
    }

    private static String createParameterName(String envName, String parameterName) {
        return Util.joinedString("-", envName, CONSTRUCT_NAME, parameterName);
    }

    @SafeVarargs
    private static <T> List<T> join(Collection<? extends T> additional, T ... elements) {
        return Stream.concat(Stream.of(Objects.requireNonNull(elements)), ((Collection)Optional.ofNullable(additional).orElse(Collections.emptyList())).stream()).toList();
    }

    private static String createUserPoolClientSecret(Stack scope, String awsRegion, String userPoolId, UserPoolClientWrapper clientWrapper, String secretName) {
        String userPoolClientId = clientWrapper.getClient().getUserPoolClientId();
        String clientName = clientWrapper.getClient().getUserPoolClientName();
        String userPoolClientSecretValue = clientWrapper.isSecretGenerated() ? CognitoStack.userPoolClientSecretValue(scope, awsRegion, userPoolId, userPoolClientId, clientName) : "";
        String secretTpl = String.format("{\"%s\": \"%s\",\"%s\": \"%s\",\"%s\": \"%s\",\"%s\": \"%s\"}", USER_POOL_ID_HOLDER, userPoolId, USER_POOL_CLIENT_ID_HOLDER, userPoolClientId, USER_POOL_CLIENT_NAME_HOLDER, clientName, USER_POOL_CLIENT_SECRET_HOLDER, userPoolClientSecretValue);
        SecretStringGenerator secretString = SecretStringGenerator.builder().secretStringTemplate(secretTpl).generateStringKey("ignored").passwordLength((Number)10).build();
        return Secret.Builder.create((Construct)scope, (String)(USER_POOL_CLIENT_SECRET_HOLDER + clientName)).secretName(secretName + userPoolClientId).description("Secret holding the user pool client (" + clientName + ") secret values").generateSecretString(secretString).build().getSecretArn();
    }

    private static String userPoolClientSecretValue(Stack scope, String awsRegion, String userPoolId, String userPoolClientId, String clientName) {
        Map<String, String> parameters = Map.of("UserPoolId", userPoolId, "ClientId", userPoolClientId);
        PhysicalResourceId physicalResourceId = PhysicalResourceId.of((String)userPoolClientId);
        AwsSdkCall userPoolClientMetadata = AwsSdkCall.builder().region(awsRegion).service("CognitoIdentityServiceProvider").action("describeUserPoolClient").parameters(parameters).physicalResourceId(physicalResourceId).build();
        String resourceType = "Custom::DescribeCognitoUserPoolClient";
        AwsCustomResourcePolicy policy = AwsCustomResourcePolicy.fromSdkCalls((SdkCallsPolicyOptions)SdkCallsPolicyOptions.builder().resources(AwsCustomResourcePolicy.ANY_RESOURCE).build());
        AwsCustomResource userPoolResource = AwsCustomResource.Builder.create((Construct)scope, (String)("describeUserPool" + clientName)).resourceType(resourceType).installLatestAwsSdk(Boolean.valueOf(false)).onUpdate(userPoolClientMetadata).onCreate(userPoolClientMetadata).policy(policy).build();
        return userPoolResource.getResponseField("UserPoolClient.ClientSecret");
    }

    public static ISecret getUserPoolClientSecret(Stack scope, ApplicationEnvironment appEnv) {
        String clientName = CognitoStack.clientName(appEnv.getApplicationName());
        String secConstructId = Util.joinedString("-", CognitoStack.clientSecretArnParamHolder(clientName), "sec");
        String arn = CognitoStack.getParameterUserPoolClientSecretArn(scope, appEnv);
        return Secret.fromSecretCompleteArn((Construct)scope, (String)secConstructId, (String)arn);
    }

    public static OutputParameters getOutputParameters(Stack scope, String appEnv) {
        return new OutputParameters(CognitoStack.getParameterLogoutUrl(scope, appEnv), CognitoStack.getParameterUserPoolProviderUrl(scope, appEnv));
    }

    public static String getParameter(Stack scope, String appEnv, String id) {
        return StringParameter.fromStringParameterName((Construct)scope, (String)CognitoStack.parameterId(id), (String)CognitoStack.createParameterName(appEnv, id)).getStringValue();
    }

    public static String getParameterUserPoolClientSecretArn(Stack scope, ApplicationEnvironment appEnv) {
        String clientName = CognitoStack.clientName(appEnv.getApplicationName());
        return CognitoStack.getParameter(scope, appEnv.getEnvironmentName(), CognitoStack.clientSecretArnParamHolder(clientName));
    }

    public static String getParameterLogoutUrl(Stack scope, String appEnv) {
        return CognitoStack.getParameter(scope, appEnv, PARAM_USER_POOL_LOGOUT_URL);
    }

    public static String getParameterUserPoolProviderUrl(Stack scope, String appEnv) {
        return CognitoStack.getParameter(scope, appEnv, PARAM_USER_POOL_PROVIDER_URL);
    }

    public static final class InputParameters {
        private String cognitoLogoutUrlTemplate;
        private String loginPageDomainPrefix;
        private boolean selfSignUpEnabled;
        private AccountRecovery accountRecovery;
        private boolean signInAutoVerifyEmail;
        private boolean signInAutoVerifyPhone;
        private boolean signInAliasUsername;
        private boolean signInAliasEmail;
        private boolean signInAliasPhone;
        private boolean signInCaseSensitive;
        private boolean signInEmailRequired;
        private boolean signInEmailMutable;
        private boolean signInPhoneRequired;
        private boolean signInPhoneMutable;
        private Mfa mfa;
        private boolean passwordRequireLowercase;
        private boolean passwordRequireDigits;
        private boolean passwordRequireSymbols;
        private boolean passwordRequireUppercase;
        private int passwordMinLength;
        private int tempPasswordValidityInDays;
        private List<UserPoolClientParameter> userPoolClientConfigurations;

        String getFullLogoutUrlForRegion(String region) {
            return String.format(this.getCognitoLogoutUrlTemplate(), this.getLoginPageDomainPrefix(), region);
        }

        private static String $default$cognitoLogoutUrlTemplate() {
            return CognitoStack.DEFAULT_COGNITO_LOGOUT_URL_TPL;
        }

        private static AccountRecovery $default$accountRecovery() {
            return AccountRecovery.EMAIL_ONLY;
        }

        private static boolean $default$signInAliasUsername() {
            return true;
        }

        private static boolean $default$signInAliasEmail() {
            return true;
        }

        private static boolean $default$signInCaseSensitive() {
            return true;
        }

        private static boolean $default$signInEmailRequired() {
            return true;
        }

        private static Mfa $default$mfa() {
            return Mfa.OFF;
        }

        private static boolean $default$passwordRequireLowercase() {
            return true;
        }

        private static boolean $default$passwordRequireDigits() {
            return true;
        }

        private static boolean $default$passwordRequireSymbols() {
            return true;
        }

        private static boolean $default$passwordRequireUppercase() {
            return true;
        }

        private static int $default$passwordMinLength() {
            return 8;
        }

        private static int $default$tempPasswordValidityInDays() {
            return 7;
        }

        private static List<UserPoolClientParameter> $default$userPoolClientConfigurations() {
            return Collections.emptyList();
        }

        InputParameters(String cognitoLogoutUrlTemplate, String loginPageDomainPrefix, boolean selfSignUpEnabled, AccountRecovery accountRecovery, boolean signInAutoVerifyEmail, boolean signInAutoVerifyPhone, boolean signInAliasUsername, boolean signInAliasEmail, boolean signInAliasPhone, boolean signInCaseSensitive, boolean signInEmailRequired, boolean signInEmailMutable, boolean signInPhoneRequired, boolean signInPhoneMutable, Mfa mfa, boolean passwordRequireLowercase, boolean passwordRequireDigits, boolean passwordRequireSymbols, boolean passwordRequireUppercase, int passwordMinLength, int tempPasswordValidityInDays, List<UserPoolClientParameter> userPoolClientConfigurations) {
            this.cognitoLogoutUrlTemplate = cognitoLogoutUrlTemplate;
            this.loginPageDomainPrefix = loginPageDomainPrefix;
            this.selfSignUpEnabled = selfSignUpEnabled;
            this.accountRecovery = accountRecovery;
            this.signInAutoVerifyEmail = signInAutoVerifyEmail;
            this.signInAutoVerifyPhone = signInAutoVerifyPhone;
            this.signInAliasUsername = signInAliasUsername;
            this.signInAliasEmail = signInAliasEmail;
            this.signInAliasPhone = signInAliasPhone;
            this.signInCaseSensitive = signInCaseSensitive;
            this.signInEmailRequired = signInEmailRequired;
            this.signInEmailMutable = signInEmailMutable;
            this.signInPhoneRequired = signInPhoneRequired;
            this.signInPhoneMutable = signInPhoneMutable;
            this.mfa = mfa;
            this.passwordRequireLowercase = passwordRequireLowercase;
            this.passwordRequireDigits = passwordRequireDigits;
            this.passwordRequireSymbols = passwordRequireSymbols;
            this.passwordRequireUppercase = passwordRequireUppercase;
            this.passwordMinLength = passwordMinLength;
            this.tempPasswordValidityInDays = tempPasswordValidityInDays;
            this.userPoolClientConfigurations = userPoolClientConfigurations;
        }

        public static InputParametersBuilder builder() {
            return new InputParametersBuilder();
        }

        String getCognitoLogoutUrlTemplate() {
            return this.cognitoLogoutUrlTemplate;
        }

        String getLoginPageDomainPrefix() {
            return this.loginPageDomainPrefix;
        }

        boolean isSelfSignUpEnabled() {
            return this.selfSignUpEnabled;
        }

        AccountRecovery getAccountRecovery() {
            return this.accountRecovery;
        }

        boolean isSignInAutoVerifyEmail() {
            return this.signInAutoVerifyEmail;
        }

        boolean isSignInAutoVerifyPhone() {
            return this.signInAutoVerifyPhone;
        }

        boolean isSignInAliasUsername() {
            return this.signInAliasUsername;
        }

        boolean isSignInAliasEmail() {
            return this.signInAliasEmail;
        }

        boolean isSignInAliasPhone() {
            return this.signInAliasPhone;
        }

        boolean isSignInCaseSensitive() {
            return this.signInCaseSensitive;
        }

        boolean isSignInEmailRequired() {
            return this.signInEmailRequired;
        }

        boolean isSignInEmailMutable() {
            return this.signInEmailMutable;
        }

        boolean isSignInPhoneRequired() {
            return this.signInPhoneRequired;
        }

        boolean isSignInPhoneMutable() {
            return this.signInPhoneMutable;
        }

        Mfa getMfa() {
            return this.mfa;
        }

        boolean isPasswordRequireLowercase() {
            return this.passwordRequireLowercase;
        }

        boolean isPasswordRequireDigits() {
            return this.passwordRequireDigits;
        }

        boolean isPasswordRequireSymbols() {
            return this.passwordRequireSymbols;
        }

        boolean isPasswordRequireUppercase() {
            return this.passwordRequireUppercase;
        }

        int getPasswordMinLength() {
            return this.passwordMinLength;
        }

        int getTempPasswordValidityInDays() {
            return this.tempPasswordValidityInDays;
        }

        List<UserPoolClientParameter> getUserPoolClientConfigurations() {
            return this.userPoolClientConfigurations;
        }

        public static class InputParametersBuilder {
            private boolean cognitoLogoutUrlTemplate$set;
            private String cognitoLogoutUrlTemplate$value;
            private String loginPageDomainPrefix;
            private boolean selfSignUpEnabled;
            private boolean accountRecovery$set;
            private AccountRecovery accountRecovery$value;
            private boolean signInAutoVerifyEmail;
            private boolean signInAutoVerifyPhone;
            private boolean signInAliasUsername$set;
            private boolean signInAliasUsername$value;
            private boolean signInAliasEmail$set;
            private boolean signInAliasEmail$value;
            private boolean signInAliasPhone;
            private boolean signInCaseSensitive$set;
            private boolean signInCaseSensitive$value;
            private boolean signInEmailRequired$set;
            private boolean signInEmailRequired$value;
            private boolean signInEmailMutable;
            private boolean signInPhoneRequired;
            private boolean signInPhoneMutable;
            private boolean mfa$set;
            private Mfa mfa$value;
            private boolean passwordRequireLowercase$set;
            private boolean passwordRequireLowercase$value;
            private boolean passwordRequireDigits$set;
            private boolean passwordRequireDigits$value;
            private boolean passwordRequireSymbols$set;
            private boolean passwordRequireSymbols$value;
            private boolean passwordRequireUppercase$set;
            private boolean passwordRequireUppercase$value;
            private boolean passwordMinLength$set;
            private int passwordMinLength$value;
            private boolean tempPasswordValidityInDays$set;
            private int tempPasswordValidityInDays$value;
            private boolean userPoolClientConfigurations$set;
            private List<UserPoolClientParameter> userPoolClientConfigurations$value;

            InputParametersBuilder() {
            }

            public InputParametersBuilder cognitoLogoutUrlTemplate(String cognitoLogoutUrlTemplate) {
                this.cognitoLogoutUrlTemplate$value = cognitoLogoutUrlTemplate;
                this.cognitoLogoutUrlTemplate$set = true;
                return this;
            }

            public InputParametersBuilder loginPageDomainPrefix(String loginPageDomainPrefix) {
                this.loginPageDomainPrefix = loginPageDomainPrefix;
                return this;
            }

            public InputParametersBuilder selfSignUpEnabled(boolean selfSignUpEnabled) {
                this.selfSignUpEnabled = selfSignUpEnabled;
                return this;
            }

            public InputParametersBuilder accountRecovery(AccountRecovery accountRecovery) {
                this.accountRecovery$value = accountRecovery;
                this.accountRecovery$set = true;
                return this;
            }

            public InputParametersBuilder signInAutoVerifyEmail(boolean signInAutoVerifyEmail) {
                this.signInAutoVerifyEmail = signInAutoVerifyEmail;
                return this;
            }

            public InputParametersBuilder signInAutoVerifyPhone(boolean signInAutoVerifyPhone) {
                this.signInAutoVerifyPhone = signInAutoVerifyPhone;
                return this;
            }

            public InputParametersBuilder signInAliasUsername(boolean signInAliasUsername) {
                this.signInAliasUsername$value = signInAliasUsername;
                this.signInAliasUsername$set = true;
                return this;
            }

            public InputParametersBuilder signInAliasEmail(boolean signInAliasEmail) {
                this.signInAliasEmail$value = signInAliasEmail;
                this.signInAliasEmail$set = true;
                return this;
            }

            public InputParametersBuilder signInAliasPhone(boolean signInAliasPhone) {
                this.signInAliasPhone = signInAliasPhone;
                return this;
            }

            public InputParametersBuilder signInCaseSensitive(boolean signInCaseSensitive) {
                this.signInCaseSensitive$value = signInCaseSensitive;
                this.signInCaseSensitive$set = true;
                return this;
            }

            public InputParametersBuilder signInEmailRequired(boolean signInEmailRequired) {
                this.signInEmailRequired$value = signInEmailRequired;
                this.signInEmailRequired$set = true;
                return this;
            }

            public InputParametersBuilder signInEmailMutable(boolean signInEmailMutable) {
                this.signInEmailMutable = signInEmailMutable;
                return this;
            }

            public InputParametersBuilder signInPhoneRequired(boolean signInPhoneRequired) {
                this.signInPhoneRequired = signInPhoneRequired;
                return this;
            }

            public InputParametersBuilder signInPhoneMutable(boolean signInPhoneMutable) {
                this.signInPhoneMutable = signInPhoneMutable;
                return this;
            }

            public InputParametersBuilder mfa(Mfa mfa) {
                this.mfa$value = mfa;
                this.mfa$set = true;
                return this;
            }

            public InputParametersBuilder passwordRequireLowercase(boolean passwordRequireLowercase) {
                this.passwordRequireLowercase$value = passwordRequireLowercase;
                this.passwordRequireLowercase$set = true;
                return this;
            }

            public InputParametersBuilder passwordRequireDigits(boolean passwordRequireDigits) {
                this.passwordRequireDigits$value = passwordRequireDigits;
                this.passwordRequireDigits$set = true;
                return this;
            }

            public InputParametersBuilder passwordRequireSymbols(boolean passwordRequireSymbols) {
                this.passwordRequireSymbols$value = passwordRequireSymbols;
                this.passwordRequireSymbols$set = true;
                return this;
            }

            public InputParametersBuilder passwordRequireUppercase(boolean passwordRequireUppercase) {
                this.passwordRequireUppercase$value = passwordRequireUppercase;
                this.passwordRequireUppercase$set = true;
                return this;
            }

            public InputParametersBuilder passwordMinLength(int passwordMinLength) {
                this.passwordMinLength$value = passwordMinLength;
                this.passwordMinLength$set = true;
                return this;
            }

            public InputParametersBuilder tempPasswordValidityInDays(int tempPasswordValidityInDays) {
                this.tempPasswordValidityInDays$value = tempPasswordValidityInDays;
                this.tempPasswordValidityInDays$set = true;
                return this;
            }

            public InputParametersBuilder userPoolClientConfigurations(List<UserPoolClientParameter> userPoolClientConfigurations) {
                this.userPoolClientConfigurations$value = userPoolClientConfigurations;
                this.userPoolClientConfigurations$set = true;
                return this;
            }

            public InputParameters build() {
                String cognitoLogoutUrlTemplate$value = this.cognitoLogoutUrlTemplate$value;
                if (!this.cognitoLogoutUrlTemplate$set) {
                    cognitoLogoutUrlTemplate$value = InputParameters.$default$cognitoLogoutUrlTemplate();
                }
                AccountRecovery accountRecovery$value = this.accountRecovery$value;
                if (!this.accountRecovery$set) {
                    accountRecovery$value = InputParameters.$default$accountRecovery();
                }
                boolean signInAliasUsername$value = this.signInAliasUsername$value;
                if (!this.signInAliasUsername$set) {
                    signInAliasUsername$value = InputParameters.$default$signInAliasUsername();
                }
                boolean signInAliasEmail$value = this.signInAliasEmail$value;
                if (!this.signInAliasEmail$set) {
                    signInAliasEmail$value = InputParameters.$default$signInAliasEmail();
                }
                boolean signInCaseSensitive$value = this.signInCaseSensitive$value;
                if (!this.signInCaseSensitive$set) {
                    signInCaseSensitive$value = InputParameters.$default$signInCaseSensitive();
                }
                boolean signInEmailRequired$value = this.signInEmailRequired$value;
                if (!this.signInEmailRequired$set) {
                    signInEmailRequired$value = InputParameters.$default$signInEmailRequired();
                }
                Mfa mfa$value = this.mfa$value;
                if (!this.mfa$set) {
                    mfa$value = InputParameters.$default$mfa();
                }
                boolean passwordRequireLowercase$value = this.passwordRequireLowercase$value;
                if (!this.passwordRequireLowercase$set) {
                    passwordRequireLowercase$value = InputParameters.$default$passwordRequireLowercase();
                }
                boolean passwordRequireDigits$value = this.passwordRequireDigits$value;
                if (!this.passwordRequireDigits$set) {
                    passwordRequireDigits$value = InputParameters.$default$passwordRequireDigits();
                }
                boolean passwordRequireSymbols$value = this.passwordRequireSymbols$value;
                if (!this.passwordRequireSymbols$set) {
                    passwordRequireSymbols$value = InputParameters.$default$passwordRequireSymbols();
                }
                boolean passwordRequireUppercase$value = this.passwordRequireUppercase$value;
                if (!this.passwordRequireUppercase$set) {
                    passwordRequireUppercase$value = InputParameters.$default$passwordRequireUppercase();
                }
                int passwordMinLength$value = this.passwordMinLength$value;
                if (!this.passwordMinLength$set) {
                    passwordMinLength$value = InputParameters.$default$passwordMinLength();
                }
                int tempPasswordValidityInDays$value = this.tempPasswordValidityInDays$value;
                if (!this.tempPasswordValidityInDays$set) {
                    tempPasswordValidityInDays$value = InputParameters.$default$tempPasswordValidityInDays();
                }
                List<UserPoolClientParameter> userPoolClientConfigurations$value = this.userPoolClientConfigurations$value;
                if (!this.userPoolClientConfigurations$set) {
                    userPoolClientConfigurations$value = InputParameters.$default$userPoolClientConfigurations();
                }
                return new InputParameters(cognitoLogoutUrlTemplate$value, this.loginPageDomainPrefix, this.selfSignUpEnabled, accountRecovery$value, this.signInAutoVerifyEmail, this.signInAutoVerifyPhone, signInAliasUsername$value, signInAliasEmail$value, this.signInAliasPhone, signInCaseSensitive$value, signInEmailRequired$value, this.signInEmailMutable, this.signInPhoneRequired, this.signInPhoneMutable, mfa$value, passwordRequireLowercase$value, passwordRequireDigits$value, passwordRequireSymbols$value, passwordRequireUppercase$value, passwordMinLength$value, tempPasswordValidityInDays$value, userPoolClientConfigurations$value);
            }

            public String toString() {
                return "CognitoStack.InputParameters.InputParametersBuilder(cognitoLogoutUrlTemplate$value=" + this.cognitoLogoutUrlTemplate$value + ", loginPageDomainPrefix=" + this.loginPageDomainPrefix + ", selfSignUpEnabled=" + this.selfSignUpEnabled + ", accountRecovery$value=" + this.accountRecovery$value + ", signInAutoVerifyEmail=" + this.signInAutoVerifyEmail + ", signInAutoVerifyPhone=" + this.signInAutoVerifyPhone + ", signInAliasUsername$value=" + this.signInAliasUsername$value + ", signInAliasEmail$value=" + this.signInAliasEmail$value + ", signInAliasPhone=" + this.signInAliasPhone + ", signInCaseSensitive$value=" + this.signInCaseSensitive$value + ", signInEmailRequired$value=" + this.signInEmailRequired$value + ", signInEmailMutable=" + this.signInEmailMutable + ", signInPhoneRequired=" + this.signInPhoneRequired + ", signInPhoneMutable=" + this.signInPhoneMutable + ", mfa$value=" + this.mfa$value + ", passwordRequireLowercase$value=" + this.passwordRequireLowercase$value + ", passwordRequireDigits$value=" + this.passwordRequireDigits$value + ", passwordRequireSymbols$value=" + this.passwordRequireSymbols$value + ", passwordRequireUppercase$value=" + this.passwordRequireUppercase$value + ", passwordMinLength$value=" + this.passwordMinLength$value + ", tempPasswordValidityInDays$value=" + this.tempPasswordValidityInDays$value + ", userPoolClientConfigurations$value=" + this.userPoolClientConfigurations$value + ")";
            }
        }
    }

    public static final class UserPoolClientParameter {
        private String cognitoOauthLoginUrlTemplate;
        private String applicationName;
        private String applicationUrl;
        private Collection<String> userPoolOauthCallBackUrls;
        private boolean flowAuthorizationCodeGrantEnabled;
        private boolean flowImplicitCodeGrantEnabled;
        private boolean flowClientCredentialsEnabled;
        private List<OAuthScope> scopes;
        private Collection<UserPoolClientIdentityProvider> userPoolSuppoertedIdentityProviders;
        private Duration accessTokenValidity;
        private Duration idTokenValidity;
        private Duration refreshTokenValidity;
        private boolean tokenRevocationEnabled;
        private boolean returnGenericErrorOnLoginFailed;
        private boolean generateSecretEnabled;
        private boolean oauthDisabled;

        String getAppLoginUrl() {
            return String.format(this.getCognitoOauthLoginUrlTemplate(), this.getApplicationUrl());
        }

        boolean isThereAFlowEnabled() {
            return this.isFlowAuthorizationCodeGrantEnabled() || this.isFlowImplicitCodeGrantEnabled() || this.isFlowClientCredentialsEnabled();
        }

        boolean isThereAScopeConfigured() {
            return Objects.nonNull(this.getScopes()) && !this.getScopes().isEmpty();
        }

        private static String $default$cognitoOauthLoginUrlTemplate() {
            return CognitoStack.DEFAULT_COGNITO_OAUTH_LOGIN_URL_TEMPLATE;
        }

        private static Collection<String> $default$userPoolOauthCallBackUrls() {
            return Collections.emptyList();
        }

        private static List<OAuthScope> $default$scopes() {
            return Collections.emptyList();
        }

        private static Collection<UserPoolClientIdentityProvider> $default$userPoolSuppoertedIdentityProviders() {
            return Collections.emptyList();
        }

        private static Duration $default$accessTokenValidity() {
            return Duration.hours((Number)1);
        }

        private static Duration $default$idTokenValidity() {
            return Duration.hours((Number)1);
        }

        private static Duration $default$refreshTokenValidity() {
            return Duration.days((Number)15);
        }

        private static boolean $default$returnGenericErrorOnLoginFailed() {
            return true;
        }

        private static boolean $default$generateSecretEnabled() {
            return true;
        }

        UserPoolClientParameter(String cognitoOauthLoginUrlTemplate, String applicationName, String applicationUrl, Collection<String> userPoolOauthCallBackUrls, boolean flowAuthorizationCodeGrantEnabled, boolean flowImplicitCodeGrantEnabled, boolean flowClientCredentialsEnabled, List<OAuthScope> scopes, Collection<UserPoolClientIdentityProvider> userPoolSuppoertedIdentityProviders, Duration accessTokenValidity, Duration idTokenValidity, Duration refreshTokenValidity, boolean tokenRevocationEnabled, boolean returnGenericErrorOnLoginFailed, boolean generateSecretEnabled, boolean oauthDisabled) {
            this.cognitoOauthLoginUrlTemplate = cognitoOauthLoginUrlTemplate;
            this.applicationName = applicationName;
            this.applicationUrl = applicationUrl;
            this.userPoolOauthCallBackUrls = userPoolOauthCallBackUrls;
            this.flowAuthorizationCodeGrantEnabled = flowAuthorizationCodeGrantEnabled;
            this.flowImplicitCodeGrantEnabled = flowImplicitCodeGrantEnabled;
            this.flowClientCredentialsEnabled = flowClientCredentialsEnabled;
            this.scopes = scopes;
            this.userPoolSuppoertedIdentityProviders = userPoolSuppoertedIdentityProviders;
            this.accessTokenValidity = accessTokenValidity;
            this.idTokenValidity = idTokenValidity;
            this.refreshTokenValidity = refreshTokenValidity;
            this.tokenRevocationEnabled = tokenRevocationEnabled;
            this.returnGenericErrorOnLoginFailed = returnGenericErrorOnLoginFailed;
            this.generateSecretEnabled = generateSecretEnabled;
            this.oauthDisabled = oauthDisabled;
        }

        public static UserPoolClientParameterBuilder builder() {
            return new UserPoolClientParameterBuilder();
        }

        String getCognitoOauthLoginUrlTemplate() {
            return this.cognitoOauthLoginUrlTemplate;
        }

        String getApplicationName() {
            return this.applicationName;
        }

        String getApplicationUrl() {
            return this.applicationUrl;
        }

        Collection<String> getUserPoolOauthCallBackUrls() {
            return this.userPoolOauthCallBackUrls;
        }

        boolean isFlowAuthorizationCodeGrantEnabled() {
            return this.flowAuthorizationCodeGrantEnabled;
        }

        boolean isFlowImplicitCodeGrantEnabled() {
            return this.flowImplicitCodeGrantEnabled;
        }

        boolean isFlowClientCredentialsEnabled() {
            return this.flowClientCredentialsEnabled;
        }

        List<OAuthScope> getScopes() {
            return this.scopes;
        }

        Collection<UserPoolClientIdentityProvider> getUserPoolSuppoertedIdentityProviders() {
            return this.userPoolSuppoertedIdentityProviders;
        }

        Duration getAccessTokenValidity() {
            return this.accessTokenValidity;
        }

        Duration getIdTokenValidity() {
            return this.idTokenValidity;
        }

        Duration getRefreshTokenValidity() {
            return this.refreshTokenValidity;
        }

        boolean isTokenRevocationEnabled() {
            return this.tokenRevocationEnabled;
        }

        boolean isReturnGenericErrorOnLoginFailed() {
            return this.returnGenericErrorOnLoginFailed;
        }

        boolean isGenerateSecretEnabled() {
            return this.generateSecretEnabled;
        }

        boolean isOauthDisabled() {
            return this.oauthDisabled;
        }

        public static class UserPoolClientParameterBuilder {
            private boolean cognitoOauthLoginUrlTemplate$set;
            private String cognitoOauthLoginUrlTemplate$value;
            private String applicationName;
            private String applicationUrl;
            private boolean userPoolOauthCallBackUrls$set;
            private Collection<String> userPoolOauthCallBackUrls$value;
            private boolean flowAuthorizationCodeGrantEnabled;
            private boolean flowImplicitCodeGrantEnabled;
            private boolean flowClientCredentialsEnabled;
            private boolean scopes$set;
            private List<OAuthScope> scopes$value;
            private boolean userPoolSuppoertedIdentityProviders$set;
            private Collection<UserPoolClientIdentityProvider> userPoolSuppoertedIdentityProviders$value;
            private boolean accessTokenValidity$set;
            private Duration accessTokenValidity$value;
            private boolean idTokenValidity$set;
            private Duration idTokenValidity$value;
            private boolean refreshTokenValidity$set;
            private Duration refreshTokenValidity$value;
            private boolean tokenRevocationEnabled;
            private boolean returnGenericErrorOnLoginFailed$set;
            private boolean returnGenericErrorOnLoginFailed$value;
            private boolean generateSecretEnabled$set;
            private boolean generateSecretEnabled$value;
            private boolean oauthDisabled;

            UserPoolClientParameterBuilder() {
            }

            public UserPoolClientParameterBuilder cognitoOauthLoginUrlTemplate(String cognitoOauthLoginUrlTemplate) {
                this.cognitoOauthLoginUrlTemplate$value = cognitoOauthLoginUrlTemplate;
                this.cognitoOauthLoginUrlTemplate$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder applicationName(String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            public UserPoolClientParameterBuilder applicationUrl(String applicationUrl) {
                this.applicationUrl = applicationUrl;
                return this;
            }

            public UserPoolClientParameterBuilder userPoolOauthCallBackUrls(Collection<String> userPoolOauthCallBackUrls) {
                this.userPoolOauthCallBackUrls$value = userPoolOauthCallBackUrls;
                this.userPoolOauthCallBackUrls$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder flowAuthorizationCodeGrantEnabled(boolean flowAuthorizationCodeGrantEnabled) {
                this.flowAuthorizationCodeGrantEnabled = flowAuthorizationCodeGrantEnabled;
                return this;
            }

            public UserPoolClientParameterBuilder flowImplicitCodeGrantEnabled(boolean flowImplicitCodeGrantEnabled) {
                this.flowImplicitCodeGrantEnabled = flowImplicitCodeGrantEnabled;
                return this;
            }

            public UserPoolClientParameterBuilder flowClientCredentialsEnabled(boolean flowClientCredentialsEnabled) {
                this.flowClientCredentialsEnabled = flowClientCredentialsEnabled;
                return this;
            }

            public UserPoolClientParameterBuilder scopes(List<OAuthScope> scopes) {
                this.scopes$value = scopes;
                this.scopes$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder userPoolSuppoertedIdentityProviders(Collection<UserPoolClientIdentityProvider> userPoolSuppoertedIdentityProviders) {
                this.userPoolSuppoertedIdentityProviders$value = userPoolSuppoertedIdentityProviders;
                this.userPoolSuppoertedIdentityProviders$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder accessTokenValidity(Duration accessTokenValidity) {
                this.accessTokenValidity$value = accessTokenValidity;
                this.accessTokenValidity$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder idTokenValidity(Duration idTokenValidity) {
                this.idTokenValidity$value = idTokenValidity;
                this.idTokenValidity$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder refreshTokenValidity(Duration refreshTokenValidity) {
                this.refreshTokenValidity$value = refreshTokenValidity;
                this.refreshTokenValidity$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder tokenRevocationEnabled(boolean tokenRevocationEnabled) {
                this.tokenRevocationEnabled = tokenRevocationEnabled;
                return this;
            }

            public UserPoolClientParameterBuilder returnGenericErrorOnLoginFailed(boolean returnGenericErrorOnLoginFailed) {
                this.returnGenericErrorOnLoginFailed$value = returnGenericErrorOnLoginFailed;
                this.returnGenericErrorOnLoginFailed$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder generateSecretEnabled(boolean generateSecretEnabled) {
                this.generateSecretEnabled$value = generateSecretEnabled;
                this.generateSecretEnabled$set = true;
                return this;
            }

            public UserPoolClientParameterBuilder oauthDisabled(boolean oauthDisabled) {
                this.oauthDisabled = oauthDisabled;
                return this;
            }

            public UserPoolClientParameter build() {
                String cognitoOauthLoginUrlTemplate$value = this.cognitoOauthLoginUrlTemplate$value;
                if (!this.cognitoOauthLoginUrlTemplate$set) {
                    cognitoOauthLoginUrlTemplate$value = UserPoolClientParameter.$default$cognitoOauthLoginUrlTemplate();
                }
                Collection<String> userPoolOauthCallBackUrls$value = this.userPoolOauthCallBackUrls$value;
                if (!this.userPoolOauthCallBackUrls$set) {
                    userPoolOauthCallBackUrls$value = UserPoolClientParameter.$default$userPoolOauthCallBackUrls();
                }
                List<OAuthScope> scopes$value = this.scopes$value;
                if (!this.scopes$set) {
                    scopes$value = UserPoolClientParameter.$default$scopes();
                }
                Collection<UserPoolClientIdentityProvider> userPoolSuppoertedIdentityProviders$value = this.userPoolSuppoertedIdentityProviders$value;
                if (!this.userPoolSuppoertedIdentityProviders$set) {
                    userPoolSuppoertedIdentityProviders$value = UserPoolClientParameter.$default$userPoolSuppoertedIdentityProviders();
                }
                Duration accessTokenValidity$value = this.accessTokenValidity$value;
                if (!this.accessTokenValidity$set) {
                    accessTokenValidity$value = UserPoolClientParameter.$default$accessTokenValidity();
                }
                Duration idTokenValidity$value = this.idTokenValidity$value;
                if (!this.idTokenValidity$set) {
                    idTokenValidity$value = UserPoolClientParameter.$default$idTokenValidity();
                }
                Duration refreshTokenValidity$value = this.refreshTokenValidity$value;
                if (!this.refreshTokenValidity$set) {
                    refreshTokenValidity$value = UserPoolClientParameter.$default$refreshTokenValidity();
                }
                boolean returnGenericErrorOnLoginFailed$value = this.returnGenericErrorOnLoginFailed$value;
                if (!this.returnGenericErrorOnLoginFailed$set) {
                    returnGenericErrorOnLoginFailed$value = UserPoolClientParameter.$default$returnGenericErrorOnLoginFailed();
                }
                boolean generateSecretEnabled$value = this.generateSecretEnabled$value;
                if (!this.generateSecretEnabled$set) {
                    generateSecretEnabled$value = UserPoolClientParameter.$default$generateSecretEnabled();
                }
                return new UserPoolClientParameter(cognitoOauthLoginUrlTemplate$value, this.applicationName, this.applicationUrl, userPoolOauthCallBackUrls$value, this.flowAuthorizationCodeGrantEnabled, this.flowImplicitCodeGrantEnabled, this.flowClientCredentialsEnabled, scopes$value, userPoolSuppoertedIdentityProviders$value, accessTokenValidity$value, idTokenValidity$value, refreshTokenValidity$value, this.tokenRevocationEnabled, returnGenericErrorOnLoginFailed$value, generateSecretEnabled$value, this.oauthDisabled);
            }

            public String toString() {
                return "CognitoStack.UserPoolClientParameter.UserPoolClientParameterBuilder(cognitoOauthLoginUrlTemplate$value=" + this.cognitoOauthLoginUrlTemplate$value + ", applicationName=" + this.applicationName + ", applicationUrl=" + this.applicationUrl + ", userPoolOauthCallBackUrls$value=" + this.userPoolOauthCallBackUrls$value + ", flowAuthorizationCodeGrantEnabled=" + this.flowAuthorizationCodeGrantEnabled + ", flowImplicitCodeGrantEnabled=" + this.flowImplicitCodeGrantEnabled + ", flowClientCredentialsEnabled=" + this.flowClientCredentialsEnabled + ", scopes$value=" + this.scopes$value + ", userPoolSuppoertedIdentityProviders$value=" + this.userPoolSuppoertedIdentityProviders$value + ", accessTokenValidity$value=" + this.accessTokenValidity$value + ", idTokenValidity$value=" + this.idTokenValidity$value + ", refreshTokenValidity$value=" + this.refreshTokenValidity$value + ", tokenRevocationEnabled=" + this.tokenRevocationEnabled + ", returnGenericErrorOnLoginFailed$value=" + this.returnGenericErrorOnLoginFailed$value + ", generateSecretEnabled$value=" + this.generateSecretEnabled$value + ", oauthDisabled=" + this.oauthDisabled + ")";
            }
        }
    }

    static final class UserPoolClientWrapper {
        private final UserPoolClient client;
        private final boolean secretGenerated;

        public UserPoolClientWrapper(UserPoolClient client, boolean secretGenerated) {
            this.client = client;
            this.secretGenerated = secretGenerated;
        }

        UserPoolClient getClient() {
            return this.client;
        }

        boolean isSecretGenerated() {
            return this.secretGenerated;
        }
    }

    public static final class OutputParameters {
        private final String logoutUrl;
        private final String providerUrl;

        public String getLogoutUrl() {
            return this.logoutUrl;
        }

        public String getProviderUrl() {
            return this.providerUrl;
        }

        OutputParameters(String logoutUrl, String providerUrl) {
            this.logoutUrl = logoutUrl;
            this.providerUrl = providerUrl;
        }
    }
}

