/*
 * Decompiled with CFR 0.152.
 */
package org.wcdevs.blog.cdk;

import org.wcdevs.blog.cdk.Util;
import software.amazon.awscdk.Tags;
import software.constructs.IConstruct;

public final class ApplicationEnvironment {
    private final String applicationName;
    private final String environmentName;

    public String toString() {
        return Util.sanitize(Util.joinedString("-", this.environmentName, this.applicationName));
    }

    public String prefixed(String string) {
        return Util.joinedString("-", this, string);
    }

    public void tag(IConstruct construct) {
        Tags.of((IConstruct)construct).add("environment", this.environmentName);
        Tags.of((IConstruct)construct).add("application", this.applicationName);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public ApplicationEnvironment(String applicationName, String environmentName) {
        this.applicationName = applicationName;
        this.environmentName = environmentName;
    }
}

